/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.sqlview;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.Icon;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.sqlworksheet.sqlview.SQLEditorURLFileSystemHelper;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditor;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Attributes;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.db.Database;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public final class SqlEditorNode
extends Node
implements List {
    private Attributes _attrs = new ElementAttributes(ElementAttributes.CLOSEABLE | ElementAttributes.SAVEABLE_AS | ElementAttributes.SAVEABLE | ElementAttributes.RENAMEABLE);
    private SqlEditor se = null;
    private Database _db;
    public static final String PROTOCOL = "sqldev.worksheet";
    private static Map _protocols = new HashMap();
    private String _connName;
    private SqlNode _sqlNode;
    private boolean _isTemp = true;
    private String _tabName;
    public boolean promptWhenClose;
    private Node _parentNode = null;

    public SqlEditorNode(URL uRL, String string) {
        super(uRL);
        this.setConnectionName(string);
        this.getAttributes().set(ElementAttributes.SAVEABLE);
        this.promptWhenClose = DBConfig.getInstance().getBoolean("PROMPTWHENCLOSE");
        DBConfig.getInstance().addStructureChangeListener((StructureChangeListener)new WorksheetPreferenceChangeListener());
        this.ensureOpen();
    }

    public SqlEditorNode(String string) {
        this(SqlEditor.createSqlEditorURL(string), string);
    }

    public static void registerProtocol(String string, Class clazz) {
        if (clazz == null || !SqlEditorNode.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("The nodeClass must be a subclass of DatabaseEditorNode");
        }
        _protocols.put(string, clazz);
        URLFileSystem.registerHelper((String)string, (URLFileSystemHelper)new SQLEditorURLFileSystemHelper());
    }

    public static SqlEditorNode findOrCreateNode(URL uRL) {
        String string;
        Class clazz;
        SqlEditorNode sqlEditorNode = null;
        if (uRL != null && (clazz = (Class)_protocols.get(string = uRL.getProtocol())) != null) {
            try {
                sqlEditorNode = (SqlEditorNode)NodeFactory.findOrCreate((Class)clazz, (URL)uRL);
            }
            catch (ClassCastException classCastException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return sqlEditorNode;
    }

    public String getToolTipText() {
        return this.getShortLabel();
    }

    public void updateSqlNode(SqlEditor sqlEditor) {
    }

    protected void closeImpl() throws IOException {
        this._sqlNode.close();
        this.notifyObservers(this, new UpdateMessage(UpdateMessage.OBJECT_CLOSED, (Object)this));
    }

    public boolean isDirty() {
        if (!this._isTemp) {
            return this._sqlNode.isDirty();
        }
        if (this.promptWhenClose) {
            if (this.se != null) {
                return this.se.hasText(false);
            }
            return false;
        }
        return false;
    }

    public void saveImpl() throws IOException {
        List list = EditorManager.getEditorManager().getEditorsInfo();
        for (EditorInfo editorInfo : list) {
            if (editorInfo._getEditor() != this.se) continue;
            EditorManager.getEditorManager().activateEditor(editorInfo);
        }
        if (this._isTemp) {
            this.se.saveWorksheet();
        } else if (this._sqlNode != null) {
            this._sqlNode.save();
        }
        this.se.markDirty(false);
    }

    public String getShortLabel() {
        this._tabName = !this._isTemp && this._sqlNode != null ? this._sqlNode.getShortLabel() : (this._connName != null ? DBURLFormatHelper.getName((URL)this.getURL()) : super.getURL().toString().substring(super.getURL().toString().lastIndexOf(".")));
        return this._tabName;
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"run.png");
    }

    public URL getURL() {
        return this._isTemp || this._sqlNode == null ? super.getURL() : this._sqlNode.getURL();
    }

    public boolean isTempFile() {
        return this._isTemp;
    }

    public void setTempFile(boolean bl) {
        this._isTemp = bl;
    }

    public String getLongLabel() {
        if (this.getParentNode() != null) {
            return this.getParentNode().getLongLabel();
        }
        return this.getLongLabelText();
    }

    public String getLongLabelText() {
        if (this._isTemp) {
            return this._connName != null ? Connections.getDisplayName((String)this._connName) : "";
        }
        String string = this.getShortLabel();
        if (this._sqlNode != null && this._db != null) {
            string = this._sqlNode.getLongLabel() + "@" + this._db.getConnectionName();
        }
        return string;
    }

    public String getToolTip() {
        return this._db != null ? Connections.getInstance().getConnectionName(this._db) : this._sqlNode.getToolTipText();
    }

    private void setConnectionName(String string) {
        this._connName = string;
    }

    public String getConnectionName() {
        return this._connName;
    }

    public Database getDatabase() {
        if (this._connName == null) {
            return null;
        }
        if (this._db == null || ModelUtil.areDifferent((Object)Connections.getInstance().getConnectionName(this._db), (Object)this._connName)) {
            try {
                this._db = Connections.getInstance().getDatabase(this._connName);
                if (this._db == null) {
                    this._connName = null;
                }
            }
            catch (Exception exception) {
                this._connName = null;
            }
        }
        return this._db;
    }

    public void setDatbase(Database database) {
        if (this._db != database) {
            this._db = database;
            if (this._db != null) {
                this.setConnectionName(Connections.getInstance().getConnectionName(this._db));
                this.update();
            }
        }
    }

    public void update() {
        this.notifyObservers(this, new UpdateMessage(UpdateMessage.OBJECT_RENAMED, (Object)this));
    }

    public Attributes getAttributes() {
        return this._attrs;
    }

    public boolean add(Object object) {
        if (object.getClass().getName().endsWith("sqlview.SqlEditor")) {
            this.se = (SqlEditor)object;
        } else {
            this.se.setText((String)object);
        }
        return true;
    }

    public Object get(int n) {
        return this.se.getText();
    }

    public void add(int n, Object object) {
    }

    public boolean addAll(Collection collection) {
        return true;
    }

    public boolean addAll(int n, Collection collection) {
        return true;
    }

    public void clear() {
    }

    public boolean contains(Object object) {
        return true;
    }

    public boolean containsAll(Collection collection) {
        return true;
    }

    public int indexOf(Object object) {
        return 1;
    }

    public boolean isEmpty() {
        return true;
    }

    public Iterator iterator() {
        return null;
    }

    public int lastIndexOf(Object object) {
        return 0;
    }

    public ListIterator listIterator() {
        return null;
    }

    public ListIterator listIterator(int n) {
        return null;
    }

    public Object remove(int n) {
        return null;
    }

    public boolean remove(Object object) {
        return true;
    }

    public boolean removeAll(Collection collection) {
        return true;
    }

    public boolean retainAll(Collection collection) {
        return true;
    }

    public Object set(int n, Object object) {
        return null;
    }

    public int size() {
        return 0;
    }

    public List subList(int n, int n2) {
        return null;
    }

    public Object[] toArray() {
        return null;
    }

    public Object[] toArray(Object[] objectArray) {
        return null;
    }

    public SqlNode getSqlNode() {
        return this._sqlNode;
    }

    public void setSqlNode(SqlNode sqlNode) {
        try {
            if (this._sqlNode != null) {
                this._sqlNode.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._sqlNode = sqlNode;
        this._sqlNode.getAttributes().unset(ElementAttributes.SAVEABLE);
        this.notifyObservers(this, new UpdateMessage(UpdateMessage.OBJECT_RENAMED, (Object)this));
        this.notifyObservers(this, new UpdateMessage(UpdateMessage.OBJECT_RELOADED, (Object)this));
    }

    public void setTabName(String string) {
        this._tabName = string;
        this.notifyObservers(this, new UpdateMessage(UpdateMessage.OBJECT_RENAMED, (Object)this));
        this.notifyObservers(this, new UpdateMessage(UpdateMessage.OBJECT_RELOADED, (Object)this));
    }

    public void setParentNode(Node node) {
        this._parentNode = node;
    }

    public Node getParentNode() {
        return this._parentNode;
    }

    public String toString() {
        return this.getURL().toString();
    }

    public void markDirty(boolean bl) {
        super.markDirty(bl);
        if (this._sqlNode != null) {
            this._sqlNode.markDirty(bl);
        }
    }

    private class WorksheetPreferenceChangeListener
    extends StructureChangeListener {
        private WorksheetPreferenceChangeListener() {
        }

        public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
            for (ChangeInfo changeInfo : structureChangeEvent.getChangeDetails()) {
                String string = changeInfo.getPropertyLocalName();
                if (!"PROMPTWHENCLOSE".equals(string)) continue;
                SqlEditorNode.this.promptWhenClose = DBConfig.getInstance().getBoolean("PROMPTWHENCLOSE");
                List list = EditorManager.getEditorManager().getAllEditors();
                for (Object e : list) {
                    if (!(e instanceof SqlEditor)) continue;
                    Node node = ((SqlEditor)e).getView().getNode();
                    SqlEditorNode.this.notifyObservers(node, new UpdateMessage(UpdateMessage.OBJECT_RENAMED, (Object)node));
                }
            }
        }
    }
}

