/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.sqlview;

import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class SqlHistoryFilterModel
extends AbstractTableModel
implements TableModelListener {
    protected ArrayList indexList = new ArrayList(0);
    protected String filter = "";
    protected TableModel model;

    public SqlHistoryFilterModel() {
    }

    public SqlHistoryFilterModel(TableModel tableModel) {
        this.setModel(tableModel);
    }

    public void setModel(TableModel tableModel) {
        this.model = tableModel;
        tableModel.addTableModelListener(this);
        this.reallocateIndexes();
    }

    public TableModel getModel() {
        return this.model;
    }

    public synchronized void setFilter(String string) {
        this.filter = string;
        int n = this.model.getRowCount();
        this.indexList.clear();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)this.model.getValueAt(i, 0);
            if (string.equals("")) {
                this.indexList.add(new Integer(i));
                continue;
            }
            if (!string2.contains(string)) continue;
            this.indexList.add(new Integer(i));
        }
        this.fireTableDataChanged();
    }

    public String getFilter() {
        return this.filter;
    }

    public String getColumnName(int n) {
        return this.model.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this.model.getColumnClass(n);
    }

    public boolean isCellEditable(int n, int n2) {
        return this.model.isCellEditable(n, n2);
    }

    public synchronized void reallocateIndexes() {
        int n = this.model.getRowCount();
        this.indexList.clear();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.model.getValueAt(i, 0);
            if (this.filter.equals("")) {
                this.indexList.add(new Integer(i));
                continue;
            }
            if (!string.contains(this.filter)) continue;
            this.indexList.add(new Integer(i));
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.reallocateIndexes();
        this.fireTableChanged(tableModelEvent);
    }

    public int getRowCount() {
        return this.indexList.size();
    }

    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    public Object getValueAt(int n, int n2) {
        int n3 = (Integer)this.indexList.get(n);
        return this.model.getValueAt(n3, n2);
    }
}

