/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.sqlview;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.nls.OraTIMESTAMPFormat;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.raptor.utils.TableSorter;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditor;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorHistory;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorNode;
import oracle.dbtools.sqlworksheet.sqlview.SqlHistoryFilterModel;
import oracle.dbtools.util.Util;
import oracle.i18n.util.OraLocaleInfo;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.sql.TIMESTAMP;

public class SqlHistoryPanel
extends JPanel
implements DragGestureListener,
DragSourceListener,
Controller,
Observer {
    private static final long serialVersionUID = 1L;
    private static JTable _table = null;
    private static DefaultTableModel _model;
    private static SqlHistoryFilterModel _sqlHistoryFilterModel;
    private TableSorter sorter;
    public static int APPEND_SQL_FROM_HISTORY_CMD;
    public static int REPLACE_SQL_FROM_HISTORY_CMD;
    public static int CLEAR_SQL_FROM_HISTORY_CMD;
    IdeAction appendAction;
    IdeAction replaceAction;
    IdeAction clearAction;
    int _hasSqlEditor = 0;
    boolean _clearSel = true;
    private JTextComponent _editor;
    private JTextField _filterText;
    private JButton _filterButton;
    private Connection _currentConnection;
    private Toolbar _toolbar;
    private DragSource _dragSource;

    public void update(Object object, UpdateMessage updateMessage) {
        int n = updateMessage.getMessageID();
        if (object.getClass() == SqlEditorNode.class || object.getClass() == SqlNode.class) {
            if (n == UpdateMessage.OBJECT_CLOSED) {
                this.appendAction.setEnabled(false);
                this.replaceAction.setEnabled(false);
                --this._hasSqlEditor;
                _table.clearSelection();
            } else if (n == UpdateMessage.OBJECT_OPENED) {
                this.appendAction.setEnabled(true);
                this.replaceAction.setEnabled(true);
                ++this._hasSqlEditor;
                this._clearSel = false;
            }
        }
    }

    public SqlHistoryPanel(DefaultTableModel defaultTableModel) {
        super(new GridBagLayout());
        _model = defaultTableModel;
        _sqlHistoryFilterModel = new SqlHistoryFilterModel(_model){

            @Override
            public Class<?> getColumnClass(int n) {
                if (Translate.translate((String)"TimeStamp").equals(this.getColumnName(n))) {
                    return Timestamp.class;
                }
                return super.getColumnClass(n);
            }
        };
        this.sorter = new TableSorter((TableModel)_sqlHistoryFilterModel);
        this.createGUI();
    }

    protected void createGUI() {
        this.createActions();
        this.installToolbar();
        this.createTable();
        this.addSqlEditorListener();
        _sqlHistoryFilterModel.setFilter(this._filterText.getText());
        this._filterText.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                _table.clearSelection();
            }
        });
        this._filterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                _sqlHistoryFilterModel.setFilter(SqlHistoryPanel.this._filterText.getText());
            }
        });
        String string = Translate.translate((String)"SQL History List");
        JScrollPane jScrollPane = new JScrollPane(_table, 22, 32);
        jScrollPane.setSize(_table.getPreferredSize());
        this.add((Component)this._toolbar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setBackground(UIManager.getColor("EWTDialog.background"));
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_bdbsqlhistory_html");
        this.setPreferredSize(jScrollPane.getPreferredSize());
        int n = SqlHistoryPanel._table.getPreferredSize().width;
        _table.getColumn(_table.getColumnName(0)).setMinWidth((int)(0.8 * (double)n));
        _table.getColumn(_table.getColumnName(0)).setPreferredWidth((int)(0.8 * (double)n));
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    JTable jTable = (JTable)mouseEvent.getSource();
                    String string = SqlHistoryPanel.this.getSqlAt(jTable.getSelectedRow(), false).toString();
                    SqlHistoryPanel.this.setCurrentEditor();
                    if (SqlHistoryPanel.this._editor != null) {
                        SqlHistoryPanel.this._editor.setText(SqlHistoryPanel.this._editor.getText() + Util.getIdeNewLineChar() + string);
                        SqlHistoryPanel.this._editor.requestFocus();
                    }
                }
            }
        };
        _table.addMouseListener(mouseAdapter);
        _table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                View.updateToolbarActions((Toolbar)SqlHistoryPanel.this._toolbar);
            }
        });
        this._dragSource = new DragSource();
        this._dragSource.createDefaultDragGestureRecognizer(_table, 1, this);
    }

    public void createActions() {
        this.appendAction = IdeAction.get((int)APPEND_SQL_FROM_HISTORY_CMD, null, (String)"Append", null, null, null, null, (boolean)true);
        this.appendAction.addController((Controller)this);
        this.replaceAction = IdeAction.get((int)REPLACE_SQL_FROM_HISTORY_CMD, null, (String)"Replace", null, null, null, null, (boolean)true);
        this.replaceAction.addController((Controller)this);
        this.clearAction = IdeAction.get((int)CLEAR_SQL_FROM_HISTORY_CMD, null, (String)"Clear History", null, null, null, null, (boolean)true);
        this.clearAction.addController((Controller)this);
        this.appendAction.putValue("SmallIcon", (Object)OracleIcons.getIcon((String)"update2.png"));
        this.replaceAction.putValue("SmallIcon", (Object)OracleIcons.getIcon((String)"update.png"));
        this.clearAction.putValue("SmallIcon", (Object)OracleIcons.getIcon((String)"clear.png"));
    }

    public void installToolbar() {
        if (this.appendAction == null) {
            this.createActions();
        }
        this._toolbar = new Toolbar();
        this._toolbar.add((ToggleAction)this.appendAction);
        this._toolbar.add((ToggleAction)this.replaceAction);
        this._toolbar.add((ToggleAction)this.clearAction);
        this._toolbar.addSeparator();
        this._filterText = new JTextField("");
        this._toolbar.add((Component)this._filterText);
        this._filterButton = new JButton("Filter");
        this._toolbar.add((Component)this._filterButton);
    }

    protected void setCurrentEditor() {
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor != null && editor instanceof IDBEditor) {
            this._currentConnection = ((IDBEditor)editor).getConnection();
            if (editor instanceof SqlEditor) {
                this._editor = ((SqlEditor)editor).getView().getSQLEditorPane();
            }
        } else {
            this._editor = null;
            this._currentConnection = null;
        }
    }

    protected void createTable() {
        _table = new JTable((TableModel)this.sorter){
            private static final long serialVersionUID = 1L;

            public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
                Object object = this.getValueAt(n, n2);
                TableCellEditor tableCellEditor2 = this.getDefaultEditor(object.getClass());
                Component component = tableCellEditor2.getTableCellEditorComponent(this, object, this.isCellSelected(n, n2), n, n2);
                if (component instanceof JTextComponent) {
                    ((JTextComponent)component).setEditable(false);
                }
                return component;
            }

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    if (this.getValueAt(n, n2) instanceof Integer) {
                        jComponent.setToolTipText("<html>" + ((Integer)this.getValueAt(n, n2)).toString().replaceAll("\n", "<br>") + "</html>");
                    } else if (this.getValueAt(n, n2) != null) {
                        jComponent.setToolTipText("<html>" + ((String)this.getValueAt(n, n2)).replaceAll("\n", "<br>") + "</html>");
                    }
                }
                return component;
            }
        };
        this.sorter.setTableHeader(_table.getTableHeader());
        _table.setCellSelectionEnabled(false);
        _table.setRowSelectionAllowed(true);
        _table.setAutoResizeMode(0);
        _table.getColumn(Translate.translate((String)"TimeStamp")).setCellRenderer(new DefaultTableCellRenderer(){

            public String getText() {
                String string = super.getText();
                try {
                    TIMESTAMP tIMESTAMP;
                    Map map = DBConfig.getInstance().getNLSMap();
                    String string2 = (String)map.get("NLS_TS_FORM");
                    if (SqlHistoryPanel.this._currentConnection != null) {
                        string2 = NLSUtils.getTimeStampFormat((Connection)SqlHistoryPanel.this._currentConnection);
                    }
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
                    Date date = dateFormat.parse(string);
                    if (string2 == null || string2.length() == 0) {
                        return string;
                    }
                    string2 = string2.replaceAll("[FS]", "");
                    OraTIMESTAMPFormat oraTIMESTAMPFormat = new OraTIMESTAMPFormat(string2 = string2.replaceAll("[\\.:]X", ""), OraLocaleInfo.getInstance((String)((String)map.get("NLS_LANGUAGE")), (String)((String)map.get("NLS_TERRITORY"))));
                    String string3 = oraTIMESTAMPFormat.format(tIMESTAMP = new TIMESTAMP(new Timestamp(date.getTime())));
                    if (string3 != null && string3.length() > 0) {
                        string = string3;
                    }
                }
                catch (ParseException parseException) {
                    return string;
                }
                return string;
            }
        });
        this.sorter.setColumnComparator(Timestamp.class, (Comparator)new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                if (string == string2) {
                    return 0;
                }
                if (string == null) {
                    return -1;
                }
                if (string2 == null) {
                    return 1;
                }
                DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
                try {
                    Date date = dateFormat.parse(string);
                    Date date2 = dateFormat.parse(string2);
                    return date.compareTo(date2);
                }
                catch (ParseException parseException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, parseException.getStackTrace()[0].toString(), parseException);
                    return 0;
                }
            }
        });
    }

    protected void addSqlEditorListener() {
        EditorManager.getEditorManager().addEditorListener(new EditorListener(){

            public void editorActivated(Editor editor) {
                if (editor instanceof SqlEditor) {
                    SqlHistoryPanel.this._currentConnection = ((SqlEditor)editor).getCachedConnection();
                    SqlHistoryPanel.this._editor = (JTextComponent)((SqlEditor)editor).getView().getSQLEditorPane();
                }
            }

            public void editorClosed(Editor editor) {
                SqlHistoryPanel.this._currentConnection = null;
                SqlHistoryPanel.this._editor = null;
            }

            public void editorDeactivated(Editor editor) {
            }

            public void editorOpened(Editor editor) {
                if (editor instanceof IDBEditor) {
                    SqlHistoryPanel.this._currentConnection = ((IDBEditor)editor).getConnection();
                }
            }
        });
    }

    protected String getSqlAt(int n, boolean bl) {
        String string = "";
        String string2 = "";
        try {
            string = this.sorter.getValueAt(n, 0).toString().trim();
            string2 = this.sorter.getValueAt(n, 4).toString().trim();
            URL uRL = null;
            try {
                uRL = new URL(string);
                if (URLFileSystem.canRead((URL)uRL)) {
                    string = Util.readFile((InputStream)URLFileSystem.openInputStream((URL)uRL));
                    bl = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!(bl || string.endsWith(";") || string.endsWith("/"))) {
                string = string + ";";
            } else if (bl && string.endsWith(";")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string2.equals(SqlEditorHistory.TYPE_SCRIPT_HISTORY) && !string.endsWith("/")) {
                string = string + Util.getIdeNewLineChar();
                string = string + "/";
            }
            string = string + Util.getIdeNewLineChar();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public Toolbar getToolbar() {
        if (this._toolbar == null) {
            this.installToolbar();
        }
        return this._toolbar;
    }

    public JTable getTable() {
        return _table;
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int n : _table.getSelectedRows()) {
            stringBuffer.append(this.getSqlAt(n, false));
        }
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        this._dragSource.startDrag(dragGestureEvent, DragSource.DefaultCopyDrop, stringSelection, this);
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == APPEND_SQL_FROM_HISTORY_CMD || n == REPLACE_SQL_FROM_HISTORY_CMD) {
            this.setCurrentEditor();
            StringBuffer stringBuffer = new StringBuffer();
            if (n == APPEND_SQL_FROM_HISTORY_CMD && this._editor != null) {
                stringBuffer.append(this._editor.getText() + Util.getIdeNewLineChar());
            }
            _table.isCellSelected(0, 0);
            _table.getSelectedRowCount();
            for (int n2 : _table.getSelectedRows()) {
                stringBuffer.append(this.getSqlAt(n2, false));
            }
            if (this._editor != null) {
                this._editor.setText(stringBuffer.toString());
                this._editor.requestFocus();
            }
            _sqlHistoryFilterModel.setFilter("");
            return true;
        }
        if (n == CLEAR_SQL_FROM_HISTORY_CMD) {
            if (_table.getSelectedRowCount() == 0) {
                int n3 = MessageDialog.confirmOrCancel((Component)this, (Object)"Are you sure you want to remove all of your history?", (String)"Confirm");
                if (n3 == 1) {
                    for (int i = _model.getRowCount(); i > 0; --i) {
                        _model.removeRow(i - 1);
                    }
                }
            } else {
                int n4 = MessageDialog.confirmOrCancel((Component)this, (Object)"Are you sure you want to remove the selected from your history?", (String)"Confirm");
                if (n4 == 1) {
                    int[] nArray = _table.getSelectedRows();
                    TableSorter tableSorter = (TableSorter)_table.getModel();
                    for (int i = nArray.length; i > 0; --i) {
                        int n5 = tableSorter.modelIndex(nArray[i - 1]);
                        _model.removeRow(n5);
                    }
                }
            }
            _model.fireTableDataChanged();
            SqlEditorHistory.writeHistory(_table);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == APPEND_SQL_FROM_HISTORY_CMD || n == REPLACE_SQL_FROM_HISTORY_CMD) {
            ideAction.setEnabled(_table.getSelectedRow() != -1 && this._hasSqlEditor > 0);
            if (this._hasSqlEditor < 1) {
                _table.clearSelection();
            }
            return true;
        }
        if (n == CLEAR_SQL_FROM_HISTORY_CMD) {
            ideAction.setEnabled(true);
            return true;
        }
        return false;
    }

    static {
        APPEND_SQL_FROM_HISTORY_CMD = Ide.findOrCreateCmdID((String)"append_sql_from_history");
        REPLACE_SQL_FROM_HISTORY_CMD = Ide.findOrCreateCmdID((String)"replace_sql_from_history");
        CLEAR_SQL_FROM_HISTORY_CMD = Ide.findOrCreateCmdID((String)"clear_sql_from_history");
    }
}

