/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.sqlview;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditor;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorNode;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.config.ClientSetting;
import oracle.ide.controls.WaitCursor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.util.IdeUtil;

public class SqlLaunchOnOpen
extends NodeListener
implements IdeListener,
ConnectionListener {
    public static boolean OPEN_DEFAULT = true;

    public SqlLaunchOnOpen() {
        Connections.getInstance().addConnectionListener((ConnectionListener)this);
        Ide.addIdeListener((IdeListener)this);
        ExitCommand.addShutdownHook((ShutdownHook)new ShutdownHook(){

            public boolean canShutdown() {
                return true;
            }

            public void shutdown() {
                List list = EditorManager.getEditorManager().getAllEditors();
                ArrayList<Editor> arrayList = new ArrayList<Editor>();
                Node node = null;
                for (Editor editor : list) {
                    node = editor.getContext().getNode();
                    if (!(node instanceof SqlEditorNode) || !((SqlEditorNode)node).isTempFile()) continue;
                    arrayList.add(editor);
                }
                EditorManager.getEditorManager().closeEditors(arrayList);
            }
        });
    }

    public void nodeOpened(NodeEvent nodeEvent) {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.sqldeveloper");
        DBConfig dBConfig = (DBConfig)clientSetting.getData("DBConfig");
        if (!dBConfig.getBoolean("WORKSHEETOPEN").booleanValue()) {
            return;
        }
        final DatabaseConnection databaseConnection = (DatabaseConnection)nodeEvent.getNode();
        if (!ConnectionSelectorUI.SELECTOR_ACTIVE && OPEN_DEFAULT) {
            IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    WaitCursor waitCursor = Ide.getWaitCursor();
                    waitCursor.show();
                    try {
                        SqlEditor.openNewEditor(databaseConnection.getQualifiedConnectionName());
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        waitCursor.hide();
                        throw throwable;
                    }
                    waitCursor.hide();
                }
            });
        }
    }

    public void nodeWillClose(NodeEvent nodeEvent) {
        List list = EditorManager.getEditorManager().getAllEditors();
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof SqlEditor) || !((SqlEditor)list.get(i)).getConnectionName().equals(((DatabaseConnection)nodeEvent.getNode()).getQualifiedConnectionName())) continue;
            ((SqlEditor)list.get(i)).close();
        }
    }

    public void addinsLoaded(IdeEvent ideEvent) {
    }

    public void mainWindowOpened(IdeEvent ideEvent) {
    }

    public void mainWindowClosing(IdeEvent ideEvent) {
        List list = EditorManager.getEditorManager().getAllEditors();
        ArrayList<Editor> arrayList = new ArrayList<Editor>();
        Node node = null;
        for (Editor editor : list) {
            node = editor.getContext().getNode();
            if (!(node instanceof SqlEditorNode) || !((SqlEditorNode)node).isTempFile()) continue;
            arrayList.add(editor);
        }
        EditorManager.getEditorManager().closeEditors(arrayList);
    }

    public void connectionAdded(ConnectionEvent connectionEvent) {
    }

    public void connectionRemoved(ConnectionEvent connectionEvent) {
    }

    public void connectionRenamed(ConnectionEvent connectionEvent) {
    }

    public void connectionModified(ConnectionEvent connectionEvent) {
    }

    public void connectionOpened(ConnectionEvent connectionEvent) {
        boolean bl;
        DBConfig dBConfig = DBConfig.getInstance();
        if (!dBConfig.getBoolean("WORKSHEETOPEN").booleanValue()) {
            return;
        }
        final String string = connectionEvent.getConnectionName();
        String string2 = Connections.getDisplayName((String)string);
        boolean bl2 = false;
        if (Connections.isUnsharedWorksheetConnection((String)string)) {
            bl2 = true;
        }
        boolean bl3 = bl = ConnectionSelectorUI.SELECTOR_ACTIVE || connectionEvent.selectorOpened();
        if (!bl && OPEN_DEFAULT && !bl2) {
            IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    WaitCursor waitCursor = Ide.getWaitCursor();
                    waitCursor.show();
                    try {
                        SqlEditor.openNewEditor(string);
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        waitCursor.hide();
                        throw throwable;
                    }
                    waitCursor.hide();
                }
            });
        }
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        String string = connectionEvent.getConnectionName();
        List list = EditorManager.getEditorManager().getAllEditors();
        for (int i = 0; i < list.size(); ++i) {
            String string2;
            if (!(list.get(i) instanceof SqlEditor) || (string2 = ((SqlEditor)list.get(i)).getConnectionName()) == null || !string2.equals(string)) continue;
            ((SqlEditor)list.get(i)).setDb(null);
        }
    }
}

