/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import oracle.ide.ComponentVersionManager;
import oracle.ide.Context;
import oracle.ide.IdeArgs;
import oracle.ide.IdeCore;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.NullInstanceCore;
import oracle.ide.Version;
import oracle.ide.config.DTCache;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ProgressTracker;
import oracle.ide.controls.StatusBar;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.layout.IdeProperties;
import oracle.ide.model.IdeSystem;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.util.HistoryList;

public final class Ide {
    private static final String PROP_LAUNCHER_PROCESS_ID = "ide.launcherProcessId";
    private static IdeCore _instanceCore;
    private static NullStatusBar nullStatusBar;

    public static IdeCore installNullCore() {
        IdeCore old = _instanceCore;
        _instanceCore = new NullInstanceCore();
        return old;
    }

    public static void uninstallNullCore(IdeCore oldCore) {
        if (!(_instanceCore instanceof NullInstanceCore)) {
            throw new IllegalStateException("Ide has a non-NullObject core:" + _instanceCore);
        }
        _instanceCore = oldCore;
    }

    public static float getVersion() {
        return Version.VERSION;
    }

    public static boolean isRunning() {
        return _instanceCore != null;
    }

    public static IdeMainWindow getMainWindow() {
        return _instanceCore.getMainWindow();
    }

    public static IdeArgs getIdeArgs() {
        return _instanceCore.getIdeArgs();
    }

    public static String getProductID() {
        return _instanceCore.getProductID();
    }

    public static String getProductVersion() {
        return _instanceCore.getProductVersion();
    }

    public static String getBinDirectory() {
        return _instanceCore.getBinDirectory();
    }

    public static String getHomeDirectory() {
        return Ide.getProductHomeDirectory();
    }

    public static String getProductHomeDirectory() {
        return _instanceCore.getHomeDirectory();
    }

    public static String getOracleHomeDirectory() {
        return _instanceCore.getOracleHomeDirectory();
    }

    public static String getLibDirectory() {
        return _instanceCore.getLibDirectory();
    }

    public static String getUserHomeDirectory() {
        return Ide.getUserSettingsDirectory();
    }

    public static String getUserSettingsDirectory() {
        return _instanceCore.getUserHomeDirectory();
    }

    public static String getTrueUserHomeDirectory() {
        return _instanceCore.getTrueUserHomeDirectory();
    }

    public static String getSystemDirectory() {
        return _instanceCore.getSystemDirectory();
    }

    public static String getWorkDirectory() {
        return _instanceCore.getWorkDirectory();
    }

    public static String getProgramName() {
        return _instanceCore.getProgramName();
    }

    public static String getProgramShortName() {
        return _instanceCore.getProgramShortName();
    }

    public static IdeProperties getIdeProperties() {
        return _instanceCore.getIdeProperties();
    }

    public static String getProperty(String key) {
        return Ide.getProperty(key, null);
    }

    public static String getProperty(String key, String def) {
        if (_instanceCore == null) {
            return null;
        }
        return _instanceCore.getProperty(key, def);
    }

    public static String setProperty(String key, String value) {
        return _instanceCore.setProperty(key, value);
    }

    public static WaitCursor getWaitCursor() {
        return _instanceCore.getWaitCursor();
    }

    public static ComponentVersionManager getVersionInfo() {
        return _instanceCore.getVersionInfo();
    }

    public static IdeSettings getSettings() {
        return _instanceCore.getSettings();
    }

    public static KeyStrokeContextRegistry getKeyStrokeContextRegistry() {
        return _instanceCore.getKeyStrokeContextRegistry();
    }

    public static EnvironOptions getEnvironOptions() {
        return _instanceCore.getEnvironOptions();
    }

    public static DTCache getDTCache() {
        return _instanceCore.getDTCache();
    }

    public static IdeSystem getSystem() {
        return _instanceCore.getSystem();
    }

    public static Workspaces getWorkspaces() {
        if (_instanceCore == null) {
            return null;
        }
        return _instanceCore.getWorkspaces();
    }

    public static Workspace getActiveWorkspace() {
        Workspaces wsps = Ide.getWorkspaces();
        return wsps != null ? wsps.currentActiveWorkspace() : null;
    }

    public static void setActiveWorkspace(Workspace workspace) {
        Workspaces wsps = Ide.getWorkspaces();
        if (wsps != null) {
            wsps.setActiveWorkspace(workspace);
        }
    }

    public static Project getActiveProject() {
        Workspace activeWorkspace = Ide.getActiveWorkspace();
        return activeWorkspace != null ? activeWorkspace.currentActiveProject() : null;
    }

    public static void setActiveProject(Project project) {
        Workspace activeWorkspace = Ide.getActiveWorkspace();
        if (activeWorkspace != null) {
            activeWorkspace.setActiveProject(project);
        }
    }

    public static Project getDefaultProject() {
        return Ide.getSystem().getPreferences().getDefaultProject();
    }

    public static Workspace getDefaultWorkspace() {
        return Ide.getSystem().getPreferences().getDefaultWorkspace();
    }

    public static void addIdeListener(IdeListener l) {
        _instanceCore.addIdeListener(l);
    }

    public static void removeIdeListener(IdeListener l) {
        _instanceCore.removeIdeListener(l);
    }

    public static InputMap getIdeInputMap() {
        return _instanceCore.getIdeInputMap();
    }

    public static ActionMap getIdeActionMap() {
        return _instanceCore.getIdeActionMap();
    }

    public static boolean isQuitting() {
        return _instanceCore.isQuitting();
    }

    public static boolean isStarting() {
        return _instanceCore == null ? false : _instanceCore.isStarting();
    }

    public static Integer findCmdID(String commandName) {
        return _instanceCore.findCmdID(commandName);
    }

    public static String findCmdName(int cmdID) {
        return _instanceCore.findCmdName(cmdID);
    }

    public static int createCmdID(String commandName) {
        return _instanceCore.createCmdID(commandName);
    }

    public static int findOrCreateCmdID(String commandName) {
        if (_instanceCore == null) {
            return -1;
        }
        return _instanceCore.findOrCreateCmdID(commandName);
    }

    public static Map getMacros() {
        return _instanceCore.getMacros();
    }

    public static int quit(IdeAction action, Context context) {
        return _instanceCore.quit(action, context);
    }

    public static int quit() {
        return Ide.quit(IdeActions.getFileExitAction(), Ide.getMainWindow().getIdeMainWindowView().getContext());
    }

    public static Menubar getMenubar() {
        return Ide.getMainWindow().getMenubar();
    }

    public static Toolbar getToolbar() {
        return Ide.getMainWindow().getIdeMainWindowView().getToolbar();
    }

    public static StatusBar getStatusBar() {
        if (!Ide.getIdeArgs().getCreateUI()) {
            if (nullStatusBar == null) {
                nullStatusBar = new NullStatusBar();
            }
            return nullStatusBar;
        }
        IdeMainWindow mainWindow = Ide.getMainWindow();
        if (mainWindow == null) {
            return null;
        }
        return mainWindow.getStatusBar();
    }

    public static NavigatorWindow getLastActiveNavigator() {
        IdeMainWindow mainWindow = Ide.getMainWindow();
        if (mainWindow == null) {
            return null;
        }
        return mainWindow.getLastActiveNavigator();
    }

    public static HistoryList loadHistoryList(String name) {
        return new HistoryList(name, Ide.getIdeProperties());
    }

    public static void startup(IdeArgs args) {
        if (_instanceCore != null) {
            throw new IllegalStateException("IDE is already started");
        }
        _instanceCore = new IdeCore(args);
        _instanceCore.startupImpl();
    }

    public static void startup(IdeCore core) {
        if (_instanceCore != null) {
            throw new IllegalStateException("IDE is already started");
        }
        _instanceCore = core;
        _instanceCore.startupImpl();
    }

    public static Controller getIdeController() {
        return _instanceCore.getController();
    }

    public static String getInstallDirectory(File systemDir) {
        return _instanceCore.getInstallDirectory(systemDir);
    }

    static void terminate() {
        _instanceCore.terminate();
    }

    private Ide() {
    }

    public static final boolean canRestart() {
        return System.getProperty(PROP_LAUNCHER_PROCESS_ID) != null;
    }

    public static final void restart() throws UnsupportedOperationException {
        String st;
        ArrayList<String> cmds = new ArrayList<String>();
        int i = 0;
        while ((st = System.getProperty("ide.startingArg" + Integer.toString(i))) != null) {
            cmds.add(st);
            ++i;
        }
        st = System.getProperty(PROP_LAUNCHER_PROCESS_ID);
        if (cmds.size() > 0 && st != null) {
            cmds.add("-pid:" + Integer.parseInt(st));
            cmds.add("-startingcwd:" + System.getProperty("ide.startingcwd", ""));
            String[] cmdArray = new String[cmds.size()];
            cmds.toArray(cmdArray);
            try {
                Process process = Runtime.getRuntime().exec(cmdArray);
                process.exitValue();
                Ide.quit();
                return;
            }
            catch (IllegalThreadStateException e) {
                Ide.quit();
                return;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        throw new UnsupportedOperationException("Restarting not supported on this platform");
    }

    static {
        nullStatusBar = null;
    }

    private static class NullStatusBar
    implements StatusBar {
        public String getText() {
            return null;
        }

        public void setText(String text) {
        }

        public JComponent getGUI() {
            return null;
        }

        public Toolbar getToolbar() {
            return null;
        }

        public ProgressTracker getProgressTracker() {
            return null;
        }
    }
}

