/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import oracle.ide.util.IdeUtil;

public final class IdeArgs {
    private static final char OPTION_PREFIX = '-';
    private static final char VALUE_SEPARATOR = ':';
    private final String[] _args;
    private boolean _bCreateUI;
    private String _sPlatformFileName;
    private boolean _migrate;

    public IdeArgs() {
        this(new String[0]);
    }

    public IdeArgs(String[] args) {
        this._args = (String[])args.clone();
        this.parseArgs(args);
    }

    private void parseArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            String sArg = args[i];
            if (sArg.length() != 0 && sArg.charAt(0) == '-') {
                String sVal;
                String sArgNoDash = sArg.substring(1);
                String sOpt = IdeUtil.getSubString(sArgNoDash, ':', true);
                if (sOpt != null) {
                    sVal = IdeUtil.getSubString(sArgNoDash, ':', false);
                } else {
                    sOpt = sArg;
                    sVal = null;
                }
                if (sOpt.compareTo("pf") == 0 || sOpt.compareTo("platformfile") == 0) {
                    this._sPlatformFileName = IdeArgs.getValue(sVal);
                } else if (sOpt.compareTo("migrate") == 0) {
                    this._migrate = true;
                }
            }
            ++i;
        }
    }

    private static String getValue(String sValue) {
        int n;
        if (sValue != null && (n = sValue.length()) > 1 && (sValue.startsWith("\"") && sValue.endsWith("\"") || sValue.startsWith("'") && sValue.endsWith("'"))) {
            sValue = sValue.substring(1, n - 1);
        }
        return sValue;
    }

    public final String[] getArgs() {
        return (String[])this._args.clone();
    }

    public boolean hasArg(String argName) {
        if (this._args != null && argName != null) {
            int i = 0;
            while (i < this._args.length) {
                if (argName.equals(this._args[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean getCreateUI() {
        return this._bCreateUI;
    }

    public void setCreateUI(boolean bCreateUI) {
        this._bCreateUI = bCreateUI;
    }

    public String getPlatformFileName() {
        return this._sPlatformFileName;
    }

    public boolean isMigrate() {
        return this._migrate;
    }
}

