/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspaces;
import oracle.ide.resource.IdeArb;

public class DeleteTNodeCommand
extends Command {
    Hashtable childParentMap;

    public DeleteTNodeCommand() {
        super(20, 0);
    }

    protected DeleteTNodeCommand(int cmdId, int type) {
        super(cmdId, type);
    }

    public int doit() throws Exception {
        if (this.childParentMap != null) {
            return this.redo();
        }
        Context context = this.getContext();
        TNode[] tnodes = ExplorerContext.getTNodes(context);
        int status = 1;
        if (tnodes != null) {
            this.childParentMap = new Hashtable();
            UpdateMessage update = new UpdateMessage(UpdateMessage.CHILD_REMOVED, null);
            if (tnodes.length == 0) {
                return 1;
            }
            TNode tparent = (TNode)tnodes[0].getParent();
            Folder parentFolder = null;
            if (tparent != null) {
                parentFolder = (Folder)tparent.getData();
            }
            if (parentFolder == null) {
                return 1;
            }
            Folder ownerFolder = null;
            int i = 0;
            while (i < tnodes.length) {
                TNode tnode = tnodes[i];
                Element element = tnode.getData();
                TNode parent = (TNode)tnode.getParent();
                if (tparent == parent && (ownerFolder = this.getElementOwner(element, context, parentFolder)).canRemove(element)) {
                    this.childParentMap.put(element, ownerFolder);
                    ownerFolder.remove(element);
                    update.getRemoveObjects().add(element);
                    status = 0;
                }
                ++i;
            }
            if (ownerFolder instanceof Subject) {
                Subject subject = (Subject)((Object)ownerFolder);
                subject.notifyObservers(ownerFolder, update);
            }
        }
        return status;
    }

    public int undo() throws Exception {
        if (this.childParentMap != null && this.childParentMap.size() > 0) {
            Enumeration e = this.childParentMap.keys();
            Folder parentFolder = null;
            Folder ownerFolder = null;
            UpdateMessage update = new UpdateMessage(UpdateMessage.CHILD_ADDED, null);
            while (e.hasMoreElements()) {
                Element element = (Element)e.nextElement();
                if (parentFolder == null) {
                    parentFolder = (Folder)this.childParentMap.get(element);
                } else if (parentFolder != this.childParentMap.get(element)) continue;
                ownerFolder = this.getElementOwner(element, this.getContext(), parentFolder);
                ownerFolder.add(element);
                update.getAddObjects().add(element);
            }
            if (ownerFolder instanceof Subject) {
                Subject subject = (Subject)((Object)ownerFolder);
                subject.notifyObservers(ownerFolder, update);
            }
            return 0;
        }
        return 1;
    }

    public String getName() {
        return IdeArb.getString(361);
    }

    private int redo() {
        if (this.childParentMap.size() > 0) {
            Enumeration e = this.childParentMap.keys();
            Folder parentFolder = null;
            Folder ownerFolder = null;
            UpdateMessage update = new UpdateMessage(UpdateMessage.CHILD_REMOVED, null);
            while (e.hasMoreElements()) {
                Element element = (Element)e.nextElement();
                if (parentFolder == null) {
                    parentFolder = (Folder)this.childParentMap.get(element);
                } else if (parentFolder != this.childParentMap.get(element)) continue;
                ownerFolder = this.getElementOwner(element, this.getContext(), parentFolder);
                if (!ownerFolder.canRemove(element)) continue;
                ownerFolder.remove(element);
                update.getRemoveObjects().add(element);
            }
            if (ownerFolder instanceof Subject) {
                Subject subject = (Subject)((Object)ownerFolder);
                subject.notifyObservers(ownerFolder, update);
            }
            return 0;
        }
        return 1;
    }

    private Folder getElementOwner(Element element, Context context, Folder parent) {
        Folder owner = Workspaces.findOwner(element, context);
        if (owner == null) {
            owner = parent;
        }
        return owner;
    }
}

