/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import oracle.ide.Ide;
import oracle.ide.cmd.SaveAllCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Command;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.javatools.util.Executors;

@ThreadSafe
public class ExitCommand
extends Command {
    private static final Collection<ShutdownHook> _shutdownHooks = new ConcurrentLinkedQueue<ShutdownHook>();
    private static final ConcurrentMap<ExecutorService, ExecutorServiceRecord> _executors = new ConcurrentHashMap<ExecutorService, ExecutorServiceRecord>();

    public ExitCommand() {
        super(4);
    }

    public static void addShutdownHook(ShutdownHook hook) {
        _shutdownHooks.add(hook);
    }

    public static void removeShutdownHook(ShutdownHook hook) {
        _shutdownHooks.remove(hook);
    }

    public static void addExecutorService(ExecutorService executor, String name) {
        ExitCommand.addExecutorService(executor, name, true);
    }

    public static void addExecutorService(ExecutorService executor, String name, boolean immediate) {
        if (executor == null) {
            throw new NullPointerException("null executor");
        }
        if (name == null) {
            throw new NullPointerException("null name");
        }
        _executors.put(executor, new ExecutorServiceRecord(executor, name, immediate, null));
    }

    public static void removeExecutorService(ExecutorService executor) {
        _executors.remove(executor);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canShutdown() {
        if (_shutdownHooks.isEmpty()) {
            return true;
        }
        try {
            Assert.startTiming((String)(this.getClass().getName() + ".canShutdown"), (String)"Querying ShutdownHooks", (boolean)false);
            for (ShutdownHook hook : _shutdownHooks) {
                try {
                    Assert.startTiming((String)(this.getClass().getName() + ".canShutdown." + hook.getClass().getName()), null, (boolean)false);
                    if (hook.canShutdown()) continue;
                    Assert.println((String)("Shutdown was vetoed by " + hook.getClass().getName()));
                    boolean bl = false;
                    Assert.endTiming((String)(this.getClass().getName() + ".canShutdown"), (String)"Queried ShutdownHooks", null, (boolean)false);
                    return bl;
                }
                catch (ThreadDeath td) {
                    throw td;
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                finally {
                    Assert.endTiming((String)(this.getClass().getName() + ".canShutdown." + hook.getClass().getName()), (String)hook.getClass().getName(), (String)"  ", (boolean)false);
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            Assert.endTiming((String)(this.getClass().getName() + ".canShutdown"), (String)"Queried ShutdownHooks", null, (boolean)false);
        }
    }

    private void shutdown() {
        if (!_shutdownHooks.isEmpty()) {
            try {
                Assert.startTiming((String)(this.getClass().getName() + ".shutdown"), (String)"Calling ShutdownHooks", (boolean)false);
                for (ShutdownHook hook : _shutdownHooks) {
                    try {
                        try {
                            Assert.startTiming((String)(this.getClass().getName() + ".shutdown." + hook.getClass().getName()), null, (boolean)false);
                            hook.shutdown();
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                    finally {
                        Assert.endTiming((String)(this.getClass().getName() + ".shutdown." + hook.getClass().getName()), (String)hook.getClass().getName(), (String)"  ", (boolean)false);
                    }
                }
            }
            finally {
                Assert.endTiming((String)(this.getClass().getName() + ".shutdown"), (String)"Called ShutdownHooks", null, (boolean)false);
            }
        }
        this.shutdownExecutorServices();
    }

    private void shutdownExecutorServices() {
        if (_executors.isEmpty()) {
            return;
        }
        Assert.startTiming((String)(this.getClass().getName() + ".shutdownExecutorServices"), (String)"Shutting down ExecutorService instances", (boolean)false);
        try {
            for (ExecutorServiceRecord record : _executors.values()) {
                Assert.startTiming((String)(this.getClass().getName() + ".shutdownExecutorServices." + ExecutorServiceRecord.ra$name(record)), null, (boolean)false);
                boolean success = false;
                try {
                    try {
                        if (ExecutorServiceRecord.ra$immediate(record)) {
                            Executors.shutdownNow((ExecutorService)ExecutorServiceRecord.ra$executor(record));
                        } else {
                            Executors.shutdown((ExecutorService)ExecutorServiceRecord.ra$executor(record));
                        }
                        success = ExecutorServiceRecord.ra$executor(record).awaitTermination(5, TimeUnit.SECONDS);
                        if (!success) {
                            Assert.println((String)(ExecutorServiceRecord.ra$name(record) + " took longer than 5 seconds to shut down"));
                            if (!ExecutorServiceRecord.ra$immediate(record)) {
                                Executors.shutdownNow((ExecutorService)ExecutorServiceRecord.ra$executor(record));
                            }
                        }
                    }
                    catch (InterruptedException ie) {
                        Assert.println((String)("Interrupted while waiting for " + ExecutorServiceRecord.ra$name(record) + " to shut down"));
                        Thread.currentThread().interrupt();
                        Assert.endTiming((String)(this.getClass().getName() + ".shutdownExecutorServices." + ExecutorServiceRecord.ra$name(record)), success ? "Shut down " + ExecutorServiceRecord.ra$name(record) : null, (String)"  ", (boolean)false);
                        break;
                    }
                }
                catch (Throwable throwable) {
                    Assert.endTiming((String)(this.getClass().getName() + ".shutdownExecutorServices." + ExecutorServiceRecord.ra$name(record)), success ? "Shut down " + ExecutorServiceRecord.ra$name(record) : null, (String)"  ", (boolean)false);
                    throw throwable;
                }
                Assert.endTiming((String)(this.getClass().getName() + ".shutdownExecutorServices." + ExecutorServiceRecord.ra$name(record)), success ? "Shut down " + ExecutorServiceRecord.ra$name(record) : null, (String)"  ", (boolean)false);
            }
        }
        finally {
            Assert.endTiming((String)(this.getClass().getName() + ".shutdownExecutorServices"), (String)"Shut down ExecutorService instances", null, (boolean)false);
        }
    }

    public int doit() throws Exception {
        if (!this.canShutdown()) {
            return 1;
        }
        View view = (View)this.getData();
        if (view == null) {
            view = Ide.getMainWindow().getIdeMainWindowView();
        }
        if (EnvironOptions.getInstance(Preferences.getPreferences()).getSaveOnDeactivation()) {
            try {
                SaveAllCommand.saveAll();
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
        ArrayList<Node> sysNodes = new ArrayList<Node>();
        Iterator<Node> openNodesIter = NodeFactory.getOpenNodes();
        CheckBoxListModel listModel = new CheckBoxListModel();
        while (openNodesIter.hasNext()) {
            Node node = openNodesIter.next();
            if (node.isDirty()) {
                if (!(!node.getAttributes().isSet(ElementAttributes.SAVEABLE) || node instanceof Project && ((Project)node).isDefault())) {
                    listModel.addElement((Object)node, node.getIcon(), true, true, URLFileSystem.getPlatformPathName((URL)node.getURL()));
                    continue;
                }
                sysNodes.add(node);
                continue;
            }
            if (node instanceof Workspace) {
                try {
                    ((Workspace)node).saveUserProperties();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!(node instanceof Project)) continue;
            try {
                ((Project)node).saveUserProperties();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        boolean doClose = true;
        boolean saveNone = true;
        if (listModel.getSize() > 0) {
            int response = SelectFilesPanel.showDialog(IdeArb.getString(337), IdeArb.format(97, listModel.findTextForElement(0)), IdeArb.getString(290), listModel, true, 1, "f1_idedsavefiles_html");
            switch (response) {
                case 0: {
                    saveNone = false;
                    List list = listModel.getSelectionList();
                    Iterator iterator = null;
                    if (list != null) {
                        iterator = list.iterator();
                    }
                    listModel = null;
                    listModel = new CheckBoxListModel();
                    while (iterator != null && iterator.hasNext()) {
                        Node node = (Node)iterator.next();
                        URL url = node.getURL();
                        if (node.isReadOnly()) {
                            URLFileSystem.setReadOnly((URL)url, (boolean)false);
                        }
                        try {
                            node.save();
                        }
                        catch (Exception e) {
                            listModel.addElement((Object)node, node.getIcon(), true, true, URLFileSystem.getPlatformPathName((URL)url));
                        }
                    }
                    if (listModel.getSize() <= 0) break;
                    doClose = this.exitWithUnsavedReadOnlyFiles(listModel, IdeArb.getString(87));
                    break;
                }
                case -1: 
                case 2: {
                    doClose = false;
                    break;
                }
            }
        }
        if (doClose) {
            this.sanitizeWorkspaces(listModel, saveNone);
            listModel = null;
            listModel = new CheckBoxListModel();
            for (Node node : sysNodes) {
                URL url = node.getURL();
                if (node.isReadOnly()) {
                    URLFileSystem.setReadOnly((URL)url, (boolean)false);
                }
                try {
                    node.save();
                }
                catch (Exception e) {
                    listModel.addElement((Object)node, node.getIcon(), true, true, URLFileSystem.getPlatformPathName((URL)url));
                }
            }
            if (listModel.getSize() > 0) {
                doClose = this.exitWithUnsavedReadOnlyFiles(listModel, IdeArb.getString(253));
            }
            if (doClose) {
                view.close();
                this.shutdown();
            }
        }
        return doClose ? 0 : 1;
    }

    private boolean exitWithUnsavedReadOnlyFiles(CheckBoxListModel listModel, String title) {
        int response = SelectFilesPanel.showDialog(title, IdeArb.format(455, listModel.findTextForElement(0)), IdeArb.getString(456), listModel, false, 2, "f1_idedunabletosavefiles_html");
        return response == 0;
    }

    private void sanitizeWorkspaces(CheckBoxListModel listModel, boolean saveNone) {
        if (listModel == null || listModel.getSize() == 0) {
            return;
        }
        Workspaces workspaces = (Workspaces)Ide.getSystem().getChild(Workspaces.class);
        if (workspaces == null) {
            return;
        }
        int numFiles = listModel.getSize();
        int i = 0;
        while (i < numFiles) {
            Node node;
            if ((saveNone || !listModel.isElementSelected(i)) && (node = (Node)listModel.getUserObjectAt(i)).isOpen() && node instanceof Workspace && node.isNew()) {
                workspaces.remove(node);
            }
            ++i;
        }
    }

    private static final class ExecutorServiceRecord {
        private final ExecutorService executor;
        private final String name;
        private final boolean immediate;

        private ExecutorServiceRecord(ExecutorService executor, String name, boolean immediate) {
            this.executor = executor;
            this.name = name;
            this.immediate = immediate;
        }

        static String ra$name(ExecutorServiceRecord executorServiceRecord) {
            return executorServiceRecord.name;
        }

        static boolean ra$immediate(ExecutorServiceRecord executorServiceRecord) {
            return executorServiceRecord.immediate;
        }

        static ExecutorService ra$executor(ExecutorServiceRecord executorServiceRecord) {
            return executorServiceRecord.executor;
        }

        ExecutorServiceRecord(ExecutorService executorService, String string, boolean bl, 1 var4_4) {
            this(executorService, string, bl);
        }

        public final class 1 {
        }
    }
}

