/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.CloseNodeCommand;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.controller.Command;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.VetoableSubject;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;

public class RemoveFileCommand
extends Command {
    private List affectedNodes;

    private void $init$() {
        this.affectedNodes = new ArrayList(1);
    }

    public RemoveFileCommand() {
        super(21, 2);
        this.$init$();
    }

    public RemoveFileCommand(int cmdId, int type) {
        super(cmdId, type);
        this.$init$();
    }

    public int doit() throws Exception {
        int status;
        Context context = this.getContext();
        ArrayList<Node> files = new ArrayList<Node>();
        ArrayList unremovedFiles = new ArrayList();
        TNode[] tnodes = ExplorerContext.getTNodes(context);
        Folder ownerFolder = null;
        if (tnodes != null) {
            ownerFolder = this.findOwner(tnodes, context);
            if (ownerFolder == null) {
                return 1;
            }
            if (!this.canRemove(tnodes, ownerFolder, files, unremovedFiles)) {
                return 1;
            }
        } else {
            Node node = context.getNode();
            if (node instanceof Workspace) {
                files.add(node);
                ownerFolder = Ide.getWorkspaces();
            } else {
                return 1;
            }
        }
        if ((status = this.remove(files, ownerFolder, true, unremovedFiles)) == 0 && unremovedFiles.size() > 0) {
            String fileNames = this.buildFileNamesString(unremovedFiles);
            String msg = IdeArb.format(146, fileNames);
            JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), msg, IdeArb.getString(145), 2);
        }
        return status;
    }

    public Node[] getAffectedNodes() {
        Node[] nodes = new Node[this.affectedNodes.size()];
        this.affectedNodes.toArray(nodes);
        return nodes;
    }

    protected int remove(List files, Folder owner, boolean close) {
        return this.remove(files, owner, close, null);
    }

    protected int remove(List files, Folder owner, boolean close, List output) {
        UpdateMessage update = this.createUpdateMessage();
        if (close) {
            CloseNodeCommand clsCmd = new CloseNodeCommand(update);
            clsCmd.setContext(this.getContext());
            clsCmd.setNeedConfirm(this.isNeedConfirmClose());
            int status = clsCmd.close(files, false, false);
            if (status != 0) {
                return status;
            }
        }
        int i = 0;
        while (i < files.size()) {
            Element element = (Element)files.get(i);
            if (element instanceof Node) {
                if (this.remove((Node)element, owner)) {
                    update.getRemoveObjects().add(element);
                    this.affectedNodes.add(element);
                } else if (output != null) {
                    output.add(element);
                }
            }
            ++i;
        }
        if (update.getRemoveObjects().size() > 0 && owner instanceof Subject) {
            Subject subject = (Subject)((Object)owner);
            update.setContext(this.getContext());
            subject.notifyObservers(owner, update);
        }
        return 0;
    }

    protected UpdateMessage createUpdateMessage() {
        UpdateMessage message = new UpdateMessage(UpdateMessage.CHILD_REMOVED, null);
        message.setProperty("Message.COMMAND_ID_PROP", 21);
        return message;
    }

    protected boolean remove(Node node, Folder owner) {
        boolean result = owner.remove(node);
        if (result) {
            FileOpenHistory.getInstance().updateHistory(node);
        }
        return result;
    }

    protected String buildFileNamesString(List elementList) {
        String result = "";
        int maxLen = Math.min(elementList.size(), 4);
        int i = 0;
        while (i < maxLen) {
            Element element = (Element)elementList.get(i);
            if (element instanceof Node) {
                Node node = (Node)element;
                if (i > 0) {
                    result = result + "\n";
                }
                result = result + URLFileSystem.getPlatformPathName((URL)node.getURL());
            }
            ++i;
        }
        return result;
    }

    Folder findOwner(TNode[] tnodes, Context context) {
        if (tnodes.length == 0) {
            return null;
        }
        Folder owner = null;
        int i = 0;
        while (i < tnodes.length) {
            TNode tnode = tnodes[i];
            Folder newOwner = this.findOwner(tnode, context);
            if (owner == null) {
                owner = newOwner;
            } else if (owner != newOwner) {
                return null;
            }
            ++i;
        }
        return owner;
    }

    Folder findOwner(TNode tnode, Context context) {
        return this.findOwner(tnode.getData(), context);
    }

    Folder findOwner(Element element, Context context) {
        return Workspaces.findOwner(element, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean canRemove(Element element, Folder ownerFolder) {
        if (ownerFolder == null) return true;
        if (!ownerFolder.canRemove(element)) return false;
        try {
            if (!(ownerFolder instanceof VetoableSubject)) return true;
            UpdateMessage.fireCanRemoveChild((VetoableSubject)((Object)ownerFolder), element);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean canRemove(TNode[] tnodes, Folder ownerFolder, List removedFiles, List unremovedFiles) {
        int i = 0;
        while (i < tnodes.length) {
            TNode tnode = tnodes[i];
            Element element = tnode.getData();
            if (this.canRemove(element, ownerFolder)) {
                removedFiles.add(element);
            } else {
                unremovedFiles.add(element);
            }
            ++i;
        }
        return removedFiles.size() > 0;
    }

    protected boolean isNeedConfirmClose() {
        return true;
    }
}

