/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.cmd.RemoveFileCommand;
import oracle.ide.config.DTCache;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.refactoring.RefactorManager;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class RemoveFromDiskCommand
extends RemoveFileCommand {
    private static final String ERASE_SAFELY_PREF = "EraseSafely";

    public RemoveFromDiskCommand() {
        super(47, 2);
    }

    public int doit() throws Exception {
        int ret = 1;
        Context context = this.getContext();
        ArrayList<Element> elements = new ArrayList<Element>();
        boolean areAllLocatables = true;
        Element[] selectedElements = context.getSelection();
        int elementCount = selectedElements.length;
        if (elementCount > 0) {
            String message;
            RefactorManager refactorManager;
            ArrayList<URL> urlList = new ArrayList<URL>(elementCount);
            int i = 0;
            while (i < elementCount) {
                Element element = selectedElements[i];
                elements.add(element);
                if (element instanceof Locatable) {
                    Locatable locatable = (Locatable)((Object)element);
                    URL url = locatable.getURL();
                    urlList.add(url);
                } else if (element instanceof RelativeDirectoryContextFolder) {
                    RelativeDirectoryContextFolder rdcf = (RelativeDirectoryContextFolder)element;
                    URLPath rootURLs = rdcf.getRootDirectories();
                    String relPath = rdcf.getRelativePath();
                    for (URL rootURL : rootURLs) {
                        URL folderURL = URLFactory.newDirURL((URL)rootURL, (String)relPath);
                        urlList.add(folderURL);
                    }
                } else {
                    areAllLocatables = false;
                }
                ++i;
            }
            URL[] urls = urlList.toArray(new URL[urlList.size()]);
            boolean canSafeDelete = false;
            if (areAllLocatables && (refactorManager = RefactorManager.getRefactorManager()).canSafeDelete(context, urls)) {
                canSafeDelete = true;
            }
            if (elements.size() == 1) {
                Element firstElement = (Element)elements.get(0);
                String longLabel = firstElement.getLongLabel();
                message = MessageFormat.format(IdeArb.getString(131), longLabel);
            } else {
                message = IdeArb.getString(116);
            }
            int answer = this.runDialog(message, canSafeDelete);
            switch (answer) {
                case 1: {
                    Folder ownerFolder = this.findOwner(selectedElements[0], this.context);
                    ret = this.eraseElements(ownerFolder, elements);
                    break;
                }
                case 2: {
                    RefactorManager refactorManager2 = RefactorManager.getRefactorManager();
                    if (!refactorManager2.safeDeleteFiles(context, urls)) break;
                    ret = 0;
                    break;
                }
            }
        }
        return ret;
    }

    protected boolean remove(Node node, Folder owner) {
        boolean result = false;
        boolean remove = false;
        if (node.isNew()) {
            remove = true;
        } else if (URLFileSystem.canDelete((URL)node.getURL())) {
            node.delete();
            remove = true;
        }
        if (remove) {
            result = owner != null ? (!owner.containsChild(node) ? true : owner.remove(node)) : true;
            if (result) {
                FileOpenHistory.getInstance().removeHistory(node);
                NodeFactory.uncache(node.getURL());
            }
        }
        return result;
    }

    private int eraseElements(Folder ownerFolder, ArrayList elements) {
        int elementSize = elements.size();
        ArrayList<Element> finalFiles = new ArrayList<Element>(elementSize);
        int i = 0;
        while (i < elementSize) {
            Element element = (Element)elements.get(i);
            if (this.canRemove(element, ownerFolder)) {
                finalFiles.add(element);
            }
            ++i;
        }
        1 runnable = new 1(this, finalFiles, ownerFolder);
        runnable.run();
        return 0;
    }

    private int runDialog(String message, boolean canSafeDelete) {
        boolean confirm;
        int ret = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        MultiLineLabel label = new MultiLineLabel(WordWrapper.getTextWrapper(), message);
        Insets insets = new Insets(2, 2, 2, 2);
        panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        JCheckBox safeDelete = new JCheckBox();
        DTCache dtCache = Ide.getDTCache();
        if (canSafeDelete) {
            ResourceUtils.resButton((AbstractButton)safeDelete, (String)IdeArb.getString(178));
            boolean eraseSafely = dtCache.getBoolean(ERASE_SAFELY_PREF, true);
            safeDelete.setSelected(eraseSafely);
            panel.add((Component)safeDelete, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 16, 0, insets, 0, 0));
            safeDelete.setEnabled(true);
        }
        if (confirm = MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), (Object)panel, (String)IdeArb.getString(391), (String)"f1_idederasefromdisk1_html")) {
            if (canSafeDelete) {
                boolean isSafeDelete = safeDelete.isSelected();
                dtCache.putBoolean(ERASE_SAFELY_PREF, isSafeDelete);
                ret = isSafeDelete ? 2 : 1;
            } else {
                ret = 1;
            }
        }
        return ret;
    }

    protected UpdateMessage createUpdateMessage() {
        UpdateMessage message = new UpdateMessage(UpdateMessage.CHILD_REMOVED, null);
        message.setProperty("Message.COMMAND_ID_PROP", 47);
        return message;
    }

    protected boolean isNeedConfirmClose() {
        return false;
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ List v$finalFiles;
        private final /* synthetic */ Folder v$ownerFolder;
        final /* synthetic */ RemoveFromDiskCommand this$0;

        public void run() {
            ArrayList unremovedFiles = new ArrayList();
            int status = this.this$0.remove(this.v$finalFiles, this.v$ownerFolder, true, unremovedFiles);
            if (status == 0 && unremovedFiles.size() > 0) {
                String fileNames = this.this$0.buildFileNamesString(unremovedFiles);
                String msg = IdeArb.format(388, fileNames);
                MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)msg, (String)IdeArb.getString(389), null);
            }
        }

        public 1(RemoveFromDiskCommand removeFromDiskCommand, List list, Folder folder) {
            this.v$ownerFolder = folder;
            this.v$finalFiles = list;
            this.this$0 = removeFromDiskCommand;
        }
    }
}

