/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd.buffer;

import oracle.ide.cmd.buffer.Edit;
import oracle.javatools.buffer.TextBuffer;

final class SimpleEdit
extends Edit {
    static final int INSERT_EDIT = 1;
    static final int REMOVE_EDIT = 2;
    static final int REPLACE_EDIT = 3;
    static final int REPLACEALL_EDIT = 4;
    private int editType;
    private char[] editData;
    private int startOffset;
    private int endOffset;
    private boolean isUndoable;
    private String editName;

    SimpleEdit(int editType, char[] editData, int startOffset, int endOffset, boolean isUndoable, String editName) {
        this.editType = editType;
        this.editData = editData;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.isUndoable = isUndoable;
        this.editName = editName == null ? "" : editName;
    }

    public void applyEdit(TextBuffer textBuffer) {
        switch (this.editType) {
            case 1: {
                textBuffer.insert(this.startOffset, this.editData);
                break;
            }
            case 2: {
                textBuffer.remove(this.startOffset, this.endOffset - this.startOffset);
                break;
            }
            case 3: {
                textBuffer.remove(this.startOffset, this.endOffset - this.startOffset);
                textBuffer.insert(this.startOffset, this.editData);
                break;
            }
            case 4: {
                textBuffer.removeToEnd(0);
                textBuffer.append(this.editData);
                break;
            }
        }
    }

    public boolean isUndoable() {
        return this.isUndoable;
    }

    public String getUndoName() {
        return this.editName;
    }
}

