/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.composite;

import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import oracle.ide.composite.AbstractCompositeFileElementProxy;
import oracle.ide.composite.CompositeFileElementRegistry;
import oracle.ide.model.Element;
import oracle.ide.model.LazyLoadable;
import oracle.ide.model.Locatable;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public class DefaultCompositeFileElementProxy
extends AbstractCompositeFileElementProxy {
    private final Observer _compositeContainerObserver;
    private final Observer _compositeOpenObserver;
    private final Class _compositeElementClass;

    private void $init$() {
        this._compositeContainerObserver = new 1();
        this._compositeOpenObserver = new 2();
    }

    public DefaultCompositeFileElementProxy(Class compositeElementClass) {
        this.$init$();
        this._compositeElementClass = compositeElementClass;
    }

    public DefaultCompositeFileElementProxy(String viewType, Class compositeElementClass) {
        super(viewType);
        this.$init$();
        this._compositeElementClass = compositeElementClass;
    }

    public Class getCompositeElementClass() {
        return this._compositeElementClass;
    }

    public URL[] getCompositeFileURLs(Element compositeElement) {
        this.attachContainerStateObserver(compositeElement);
        Collection compositeFileUrls = this.getContainerFileURLs(compositeElement);
        return compositeFileUrls.toArray(new URL[0]);
    }

    protected void attachContainerStateObserver(Element element) {
        if (element instanceof Subject) {
            Subject compositeSubject = (Subject)((Object)element);
            compositeSubject.detach(this._compositeContainerObserver);
            compositeSubject.attach(this._compositeContainerObserver);
        }
        if (!this.isContainerStyleRecursive()) {
            return;
        }
        if (!element.mayHaveChildren()) {
            return;
        }
        if (element instanceof Subject && element instanceof LazyLoadable && !((LazyLoadable)((Object)element)).isOpen()) {
            Subject compositeSubject = (Subject)((Object)element);
            compositeSubject.detach(this._compositeOpenObserver);
            compositeSubject.attach(this._compositeOpenObserver);
            return;
        }
        Iterator<Element> itr = element.getChildren();
        while (itr != null && itr.hasNext()) {
            this.attachContainerStateObserver(itr.next());
        }
    }

    protected Collection getContainerFileURLs(Element compositeElement) {
        LinkedHashSet compositeFileUrls = new LinkedHashSet();
        this.addParentURL(compositeFileUrls, compositeElement);
        this.addChildURLs(compositeFileUrls, compositeElement);
        return compositeFileUrls;
    }

    protected boolean isContainerStyleRecursive() {
        return true;
    }

    protected void addParentURL(Collection compositeFileUrls, Element parent) {
        this.addLocatableURL(compositeFileUrls, parent);
    }

    protected void addChildURLs(Collection compositeFileUrls, Element parent) {
        if (!parent.mayHaveChildren()) {
            return;
        }
        Iterator<Element> itr = parent.getChildren();
        while (itr != null && itr.hasNext()) {
            this.addLocatableURL(compositeFileUrls, itr.next());
        }
        if (!this.isContainerStyleRecursive()) {
            return;
        }
        Iterator<Element> itr2 = parent.getChildren();
        while (itr2 != null && itr2.hasNext()) {
            this.addChildURLs(compositeFileUrls, itr2.next());
        }
    }

    protected void addLocatableURL(Collection compositeFileUrls, Object o) {
        if (!(o instanceof Locatable)) {
            return;
        }
        URL url = ((Locatable)o).getURL();
        if (url != null) {
            compositeFileUrls.add(url);
        }
    }

    final class 1
    implements Observer {
        public final void update(Object observed, UpdateMessage change) {
            if (!CompositeFileElementRegistry.isRegisteredCompositeProxy(DefaultCompositeFileElementProxy.this)) {
                ((Subject)observed).detach(this);
                return;
            }
            int messageId = change.getMessageID();
            if (messageId != UpdateMessage.CHILD_ADDED && messageId != UpdateMessage.CHILD_REMOVED) {
                return;
            }
            CompositeFileElementRegistry.fireCompositeStateChanged(DefaultCompositeFileElementProxy.this.getCompositeElementClass());
        }
    }

    final class 2
    implements Observer {
        public final void update(Object observed, UpdateMessage change) {
            if (!CompositeFileElementRegistry.isRegisteredCompositeProxy(DefaultCompositeFileElementProxy.this)) {
                ((Subject)observed).detach(this);
                return;
            }
            if (change.getMessageID() != UpdateMessage.OBJECT_OPENED) {
                return;
            }
            CompositeFileElementRegistry.fireCompositeStateChanged(DefaultCompositeFileElementProxy.this.getCompositeElementClass());
            ((Subject)observed).detach(this);
        }
    }
}

