/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import oracle.ide.Ide;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.net.URLFilter;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.HashStructure;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.Pair;

public class GlobalIgnoreList
extends ChangeEventSource
implements Copyable {
    public static final String KEY_SETTINGS = "global-ignore-list";
    private List _filterList;
    private static List _filterRegistry = new ArrayList();
    private static PatternFilters _patternFilters;

    private void $init$() {
        this._filterList = new ArrayList();
    }

    public GlobalIgnoreList() {
        this.$init$();
    }

    public static final boolean isGloballyIgnored(URL url) {
        PatternFilter filter = GlobalIgnoreList.getPatternFilters().findMatchingFilter(url.getPath());
        return filter == null || !filter.isInclude();
    }

    public static void registerExcludeFilter(String excludeString) {
        _filterRegistry.add(excludeString);
    }

    public static PatternFilters getPatternFilters() throws TransientMarker {
        return GlobalIgnoreList._getPatternFiltersImpl();
    }

    public static URLFilter getURLFilter() {
        return new 1();
    }

    public List getList() {
        this._ensureFilterListInitialized();
        return this._filterList;
    }

    public void setList(List list) {
        this._filterList = list;
        _patternFilters = null;
    }

    public Object copyTo(Object target) {
        GlobalIgnoreList copy = target != null ? (GlobalIgnoreList)((Object)target) : new GlobalIgnoreList();
        this._copyToImpl(copy);
        return copy;
    }

    static List createDefaults() {
        ArrayList<Pair> defaultList = new ArrayList<Pair>();
        String excludeFiltersString = Ide.isRunning() ? Ide.getProperty("Ide.GlobalIgnoreListFilters", "") : System.getProperty("Ide.GlobalIgnoreListFilters", "");
        Pattern seperate = Pattern.compile(";");
        String[] tokens = seperate.split(excludeFiltersString);
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].length() > 0) {
                defaultList.add(new Pair((Object)tokens[i], (Object)true));
            }
            ++i;
        }
        int registeredFilters = _filterRegistry.size();
        String newFilter = null;
        int i2 = 0;
        while (i2 < registeredFilters) {
            newFilter = (String)_filterRegistry.get(i2);
            if (!GlobalIgnoreList._containsFilter(newFilter, defaultList)) {
                defaultList.add(new Pair(_filterRegistry.get(i2), (Object)true));
            }
            ++i2;
        }
        return defaultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _ensureFilterListInitialized() {
        List list = this._filterList;
        synchronized (list) {
            int listLen = this._filterList.size();
            if (listLen == 0) {
                List defaultList = GlobalIgnoreList.createDefaults();
                this._filterList.addAll(defaultList);
            }
        }
    }

    private PatternFilters _createPatternFilters() {
        HashStructure hashStructure = HashStructure.newInstance();
        PatternFilters patternFilters = PatternFilters.getInstance(hashStructure);
        patternFilters.addInclude("**");
        int listLen = this._filterList.size();
        Pair pair = null;
        Boolean enabled = null;
        int i = 0;
        while (i < listLen) {
            pair = (Pair)this._filterList.get(i);
            enabled = (Boolean)pair.getSecond();
            if (enabled.booleanValue()) {
                patternFilters.addExclude((String)pair.getFirst());
            }
            ++i;
        }
        return patternFilters;
    }

    private static boolean _containsFilter(String filter, List listToCheck) {
        int listLen = listToCheck.size();
        Pair pair = null;
        String excludeString = null;
        int i = 0;
        while (i < listLen) {
            pair = (Pair)listToCheck.get(i);
            excludeString = (String)pair.getFirst();
            if (excludeString.equals(filter)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static synchronized PatternFilters _getPatternFiltersImpl() {
        if (_patternFilters == null) {
            GlobalIgnoreList ignoreList;
            GlobalIgnoreList globalIgnoreList = ignoreList = Ide.isRunning() && Ide.getSettings() != null ? (GlobalIgnoreList)((Object)Ide.getSettings().getData(KEY_SETTINGS)) : new GlobalIgnoreList();
            if (ignoreList == null) {
                ignoreList = new GlobalIgnoreList();
            }
            ignoreList._ensureFilterListInitialized();
            _patternFilters = ignoreList._createPatternFilters();
        }
        return _patternFilters;
    }

    private final void _copyToImpl(GlobalIgnoreList copy) {
        copy._filterList.clear();
        int listlen = this._filterList.size();
        Pair pair = null;
        int i = 0;
        while (i < listlen) {
            pair = (Pair)this._filterList.get(i);
            copy._filterList.add(new Pair(pair.getFirst(), pair.getSecond()));
            ++i;
        }
        _patternFilters = null;
        copy.fireChangeEvent();
    }

    static final class 1
    implements URLFilter {
        final PatternFilters _filters;

        private void $init$() {
            this._filters = GlobalIgnoreList.getPatternFilters();
        }

        public boolean accept(URL url) {
            return this._filters.isIncluded(url.getPath());
        }

        public boolean equals(Object o) {
            return o != null && o.getClass() == this.getClass();
        }

        public 1() {
            this.$init$();
        }
    }
}

