/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.util.HashMap;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.LabelUpdater;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.util.macro.StringMacroConverter;

public class ContextAwareLabelUpdater
implements LabelUpdater {
    private String _enabledFormat;
    private String _disabledFormat;
    private StringMacroConverter macroConverter;

    private void $init$() {
        this.macroConverter = StringMacroConverter.getConverter(3);
    }

    public String labelWhenEnabled(Context context, IdeAction action, String originalLabel) {
        Map macros = this.configureDefaultMacros(context, action, originalLabel);
        return this.macroConverter.expandString(this._enabledFormat, macros);
    }

    public String labelWhenDisabled(Context context, IdeAction action, String originalLabel) {
        Map macros = this.configureDefaultMacros(context, action, originalLabel);
        return this.macroConverter.expandString(this._disabledFormat, macros);
    }

    public void setEnabledFormat(String format) {
        this._enabledFormat = format;
    }

    public void setDisabledFormat(String format) {
        this._disabledFormat = format;
    }

    private Map configureDefaultMacros(Context context, IdeAction action, String originalLabel) {
        HashMap macros = (HashMap)context.getProperty("oracle.ide.label_updater_macros");
        if (macros == null) {
            macros = new HashMap();
            context.setProperty("oracle.ide.label_updater_macros", macros);
        }
        this.configureActionMacros(context, action, originalLabel, macros);
        this.configureWorkspaceMacros(context, action, originalLabel, macros);
        this.configureProjectMacros(context, action, originalLabel, macros);
        this.configureElementMacros(context, action, originalLabel, macros);
        this.configureNodeMacros(context, action, originalLabel, macros);
        this.configureExtraMacros(context, action, originalLabel, macros);
        return macros;
    }

    protected void configureActionMacros(Context context, IdeAction action, String originalLabel, Map macros) {
        macros.put("action.name", originalLabel);
    }

    protected void configureProjectMacros(Context context, IdeAction action, String originalLabel, Map macros) {
        Project project = context.getProject();
        if (project != null) {
            macros.put("project.name", project.getShortLabel());
        }
    }

    protected void configureWorkspaceMacros(Context context, IdeAction action, String originalLabel, Map macros) {
        Workspace workspace = context.getWorkspace();
        if (workspace != null) {
            macros.put("workspace.name", workspace.getShortLabel());
        }
    }

    protected void configureElementMacros(Context context, IdeAction action, String originalLabel, Map macros) {
        Element element = context.getElement();
        if (element != null) {
            macros.put("element.name", element.getShortLabel());
        }
    }

    protected void configureNodeMacros(Context context, IdeAction action, String originalLabel, Map macros) {
        Node node = context.getNode();
        if (node != null) {
            macros.put("node.name", node.getShortLabel());
        }
    }

    protected void configureExtraMacros(Context context, IdeAction action, String originalLabel, Map macros) {
    }

    public ContextAwareLabelUpdater() {
        this.$init$();
    }
}

