/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import oracle.ide.controller.MenuFilter;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.JDK;
import oracle.ide.view.View;
import oracle.javatools.ui.themes.ThemeEvent;
import oracle.javatools.ui.themes.ThemeListener;
import oracle.javatools.ui.themes.Themes;

public final class Menubar
extends MenuManager {
    private View view;
    private JMenuBar gui;
    private JMenuBar _savedGui;
    private JMenu _activeMenu;
    private Component _wasFocused;
    private boolean _bIsActive;
    private final L _listener;
    private static boolean _mustWorkAround4647105 = Menubar.mustWorkAround4647105();

    private void $init$() {
        this.view = null;
        this.gui = null;
        this._savedGui = null;
        this._bIsActive = true;
        this._listener = new L(null);
    }

    private static boolean mustWorkAround4647105() {
        Rectangle[] screenBounds;
        if (JDK.HAS_BUG_4647105 && (screenBounds = GraphicsUtils.getScreenBounds()).length > 1) {
            System.setProperty("javax.swing.adjustPopupLocationToFit", Boolean.toString(false));
            return true;
        }
        return false;
    }

    private JMenuBar createThemedMenuBar() {
        JMenuBar bar = new JMenuBar();
        if (Themes.isThemed()) {
            bar.setOpaque(false);
            bar.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }
        return bar;
    }

    protected void applyGlobalFilterImpl(MenuFilter filter) {
        JMenuBar newMenuBar = this.createThemedMenuBar();
        int i = 0;
        while (i < this.gui.getMenuCount()) {
            JMenu menu = this.gui.getMenu(i);
            if (filter.accept(menu)) {
                JMenu newMenu = this.createMenuClone(menu);
                this.applyFilterToMenu(menu, filter, newMenu);
                if (newMenu.getMenuComponentCount() > 0) {
                    newMenuBar.add(newMenu);
                }
            }
            ++i;
        }
        JFrame frame = (JFrame)this.view.getGUI();
        this._savedGui = frame.getJMenuBar();
        frame.setJMenuBar(newMenuBar);
        this.gui = newMenuBar;
    }

    private void applyFilterToMenu(JMenu menu, MenuFilter filter, JMenu newMenu) {
        int i = 0;
        while (i < menu.getMenuComponentCount()) {
            Component menuComponent = menu.getMenuComponent(i);
            if (!(menuComponent instanceof JSeparator)) {
                JMenuItem childMenuItem;
                if (menuComponent instanceof JMenu) {
                    JMenu childMenu = (JMenu)menuComponent;
                    if (filter.accept(childMenu)) {
                        JMenu childMenuClone = this.createMenuClone(childMenu);
                        this.applyFilterToMenu(childMenu, filter, childMenuClone);
                        if (childMenuClone.getMenuComponentCount() > 0) {
                            newMenu.add(childMenuClone);
                        }
                    }
                } else if (menuComponent instanceof JMenuItem && filter.accept(childMenuItem = (JMenuItem)menuComponent)) {
                    newMenu.add(this.createMenuItemClone(childMenuItem));
                }
            }
            ++i;
        }
    }

    private JMenuItem createMenuItemClone(JMenuItem source) {
        JMenuItem newMenuItem = source.getAction() instanceof ToggleAction ? this.createMenuItem((ToggleAction)source.getAction()) : new JMenuItem(source.getAction());
        this.transferClientProperties(source, newMenuItem);
        return newMenuItem;
    }

    private JMenu createMenuClone(JMenu source) {
        JMenu newMenu = this.createMenu(source.getText(), source.getMnemonic());
        this.transferClientProperties(source, newMenu);
        return newMenu;
    }

    protected void clearGlobalFilterImpl() {
        if (this._savedGui != null) {
            this.gui = this._savedGui;
            ((JFrame)this.view.getGUI()).setJMenuBar(this.gui);
        }
    }

    private void transferClientProperties(JComponent source, JComponent target) {
        this.transferClientProperty(source, target, "menu-weight");
        this.transferClientProperty(source, target, "menu-section-id");
        this.transferClientProperty(source, target, "menu-addin-section-id");
    }

    private void transferClientProperty(JComponent source, JComponent target, String id) {
        Object value = source.getClientProperty(id);
        if (value != null) {
            target.putClientProperty(id, value);
        }
    }

    public Menubar(View view) {
        this.$init$();
        this.view = view;
    }

    public synchronized Container getGUI(boolean create) {
        if (this.gui == null && create) {
            Component component;
            Component component2 = component = this.view != null ? this.view.getGUI() : null;
            if (component != null && component instanceof JFrame) {
                JFrame frame = (JFrame)component;
                this.gui = frame.getJMenuBar();
                if (this.gui == null) {
                    this.gui = JDK.SEARCH_ACCELERATORS_IN_MENUS ? this.createThemedMenuBar() : new 1();
                    if (Themes.isThemed()) {
                        this.gui.setOpaque(false);
                        this.gui.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                    } else {
                        Themes.addThemeListener((ThemeListener)new 2());
                    }
                    frame.setJMenuBar(this.gui);
                }
                if (JDK.HAS_BUG_4336775 || JDK.HAS_BUG_4776532) {
                    frame.addWindowListener(this._listener);
                }
                this.gui.addContainerListener(this._containerListener);
            }
        }
        return this.gui;
    }

    public JMenu createMenu(String caption, Integer mnemonic) {
        if (JDK.HAS_BUG_4336775 || JDK.HAS_BUG_4647105) {
            JTopMenu menu = new JTopMenu(caption);
            if (mnemonic != null) {
                menu.setMnemonic(mnemonic);
            }
            return menu;
        }
        return super.createMenu(caption, mnemonic);
    }

    static Component ra$_wasFocused(Menubar menubar) {
        return menubar._wasFocused;
    }

    static boolean ra$_bIsActive(Menubar menubar) {
        return menubar._bIsActive;
    }

    static void wa$_wasFocused(Menubar menubar, Component component) {
        menubar._wasFocused = component;
    }

    static boolean ra$_mustWorkAround4647105() {
        return _mustWorkAround4647105;
    }

    static JMenu ra$_activeMenu(Menubar menubar) {
        return menubar._activeMenu;
    }

    static void wa$_activeMenu(Menubar menubar, JMenu jMenu) {
        menubar._activeMenu = jMenu;
    }

    static void wa$_bIsActive(Menubar menubar, boolean bl) {
        menubar._bIsActive = bl;
    }

    static JMenuBar ra$gui(Menubar menubar) {
        return menubar.gui;
    }

    private class TryLater
    implements Runnable {
        private Window _w;

        TryLater(Window w) {
            this._w = w;
        }

        public void run() {
            if (Menubar.ra$_wasFocused(Menubar.this) != null && Menubar.ra$_bIsActive(Menubar.this)) {
                Component c;
                Container parent = Menubar.this.getGUI(false);
                if (parent != null && parent.isAncestorOf(c = this._w.getFocusOwner())) {
                    Menubar.ra$_wasFocused(Menubar.this).requestFocus();
                }
                Menubar.wa$_wasFocused(Menubar.this, null);
            }
        }
    }

    final class 1
    extends JMenuBar {
        private final MenuElement[] NOMENUS;
        private boolean _returnNoMenus;

        private void $init$() {
            this.NOMENUS = new MenuElement[0];
            this._returnNoMenus = false;
        }

        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            this._returnNoMenus = true;
            try {
                boolean bl = super.processKeyBinding(ks, e, condition, pressed);
                return bl;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this._returnNoMenus = false;
            }
        }

        public MenuElement[] getSubElements() {
            if (this._returnNoMenus) {
                return this.NOMENUS;
            }
            return super.getSubElements();
        }

        public 1() {
            this.$init$();
        }
    }

    final class 2
    implements ThemeListener {
        public void themeChanged(ThemeEvent e) {
            Menubar.ra$gui(Menubar.this).setOpaque(false);
            Menubar.ra$gui(Menubar.this).setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }
    }

    class JTopMenu
    extends JMenu {
        JTopMenu(String caption) {
            super(caption);
        }

        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            Window w;
            if (!JDK.HAS_BUG_4336775) {
                return super.processKeyBinding(ks, e, condition, pressed);
            }
            JMenu wasActiveMenu = Menubar.ra$_activeMenu(Menubar.this);
            boolean bRet = super.processKeyBinding(ks, e, condition, pressed);
            if (bRet && wasActiveMenu != null && Menubar.ra$_activeMenu(Menubar.this) == null && Menubar.ra$_wasFocused(Menubar.this) != null && Menubar.ra$_bIsActive(Menubar.this) && (w = (Window)SwingUtilities.getAncestorOfClass(Window.class, this)) != null) {
                SwingUtilities.invokeLater(new TryLater(w));
            }
            return bRet;
        }

        public void setSelected(boolean b) {
            if (JDK.HAS_BUG_4336775) {
                if (b) {
                    JComponent jcWasFocused;
                    Component wasFocused;
                    Window w;
                    if (Menubar.ra$_activeMenu(Menubar.this) == null && Menubar.ra$_wasFocused(Menubar.this) == null && (w = (Window)SwingUtilities.getAncestorOfClass(Window.class, this)) != null && (wasFocused = w.getFocusOwner()) instanceof JComponent && (jcWasFocused = (JComponent)wasFocused).getRootPane() != this.getRootPane()) {
                        Menubar.wa$_wasFocused(Menubar.this, wasFocused);
                    }
                    Menubar.wa$_activeMenu(Menubar.this, this);
                } else {
                    Menubar.wa$_activeMenu(Menubar.this, null);
                }
            }
            super.setSelected(b);
        }

        protected Point getPopupMenuOrigin() {
            if (Menubar.ra$_mustWorkAround4647105() && !(this.getParent() instanceof JPopupMenu)) {
                Rectangle[] screenBounds = GraphicsUtils.getScreenBounds();
                Point position = this.getLocationOnScreen();
                int i = 0;
                while (i < screenBounds.length) {
                    Rectangle screenBound = screenBounds[i];
                    if (screenBound.contains(position)) {
                        int x = 0;
                        int y = 0;
                        JPopupMenu pm = this.getPopupMenu();
                        Dimension s = this.getSize();
                        Dimension pmSize = pm.getSize();
                        if (pmSize.width == 0) {
                            pmSize = pm.getPreferredSize();
                        }
                        x = this.getComponentOrientation().isLeftToRight() ? (position.x + pmSize.width < screenBound.x + screenBound.width ? 0 : s.width - pmSize.width) : (position.x + s.width < pmSize.width ? 0 : s.width - pmSize.width);
                        y = position.y + s.height + pmSize.height < screenBound.y + screenBound.height ? s.height : 0 - pmSize.height;
                        return new Point(x, y);
                    }
                    ++i;
                }
            }
            return super.getPopupMenuOrigin();
        }
    }

    private class L
    implements WindowListener {
        public void windowOpened(WindowEvent p0) {
        }

        public void windowClosing(WindowEvent p0) {
        }

        public void windowClosed(WindowEvent p0) {
        }

        public void windowIconified(WindowEvent p0) {
        }

        public void windowDeiconified(WindowEvent p0) {
        }

        public void windowActivated(WindowEvent e) {
            Menubar.wa$_bIsActive(Menubar.this, true);
            if (Menubar.ra$_wasFocused(Menubar.this) != null) {
                SwingUtilities.invokeLater(new TryLater(e.getWindow()));
            }
        }

        public void windowDeactivated(WindowEvent p0) {
            Menubar.wa$_bIsActive(Menubar.this, false);
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.clearSelectedPath();
        }

        private L() {
        }

        L(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

