/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.event.PopupMenuListener;
import oracle.ide.controls.BaseToggleToolButton;
import oracle.ide.controls.MenuItem;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.MenuToolButtonUtils;
import oracle.ide.controls.RadioMenuItem;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleMenuItem;
import oracle.ide.controls.ToolButton;

public class ActionMenuToolButton
extends BaseToggleToolButton {
    protected static final Action[] NULL_ACTIONS = new Action[0];
    protected static final PopupMenuListener POPUP_MENU_LISTENER = MenuToolButton.POPUP_MENU_LISTENER;
    protected static final Icon POPUP_ICON = MenuToolButton.POPUP_ICON;
    protected static final int POPUP_WIDTH = Math.max(3 + POPUP_ICON.getIconWidth() + 3, 13);
    protected static final String ACTION_SHOW_POPUP_MENU = "ShowPopupMenu";
    protected JPopupMenu _popup;
    private Image _capturedImage;

    public ActionMenuToolButton(Action action) {
        super(action);
        this.setHorizontalAlignment(2);
        ButtonCaptureAdapter adapter = new ButtonCaptureAdapter(null);
        this.addComponentListener(adapter);
        this.addMouseListener(adapter);
        this.addMouseMotionListener(adapter);
        this.addPropertyChangeListener(adapter);
        this.createKeyBindings(adapter);
    }

    private void createKeyBindings(ButtonCaptureAdapter adapter) {
        1 showPopupMenuAction = new 1(this, ACTION_SHOW_POPUP_MENU, adapter);
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 0), ACTION_SHOW_POPUP_MENU);
        showPopupMenuAction.putValue("ActionCommandKey", ACTION_SHOW_POPUP_MENU);
        this.getActionMap().put(ACTION_SHOW_POPUP_MENU, showPopupMenuAction);
    }

    public void setMenuActions(Action[] actions) {
        if (actions == null) {
            this.releasePopupMenu();
        } else {
            if (this._popup == null) {
                this.createPopupMenu();
            } else {
                this._popup.removeAll();
            }
            int i = 0;
            while (i < actions.length) {
                Action action = actions[i];
                if (action instanceof ToggleAction) {
                    ToggleAction toggleAction = (ToggleAction)action;
                    JMenuItem menuItem = toggleAction.isRadio() ? new RadioMenuItem(toggleAction) : (toggleAction.isToggle() ? new ToggleMenuItem(toggleAction) : new MenuItem(toggleAction));
                    this._popup.add(menuItem);
                } else if (action != null) {
                    this._popup.add(action);
                } else {
                    this._popup.addSeparator();
                }
                ++i;
            }
        }
    }

    protected ButtonModel createModel() {
        return new 2();
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width += POPUP_WIDTH + 1;
        return size;
    }

    public void updateUI() {
        super.updateUI();
        if (this._popup != null) {
            SwingUtilities.updateComponentTreeUI(this._popup);
        }
    }

    public void paint(Graphics g) {
        if (this._capturedImage != null && (this.isPopupVisible() || this.getModel().isPressed())) {
            g.drawImage(this._capturedImage, 0, 0, this);
            return;
        }
        this._capturedImage = null;
        super.paint(g);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.isEnabled() && (this.getModel().isRollover() || this.getModel().isSelected())) {
            int x = w - POPUP_WIDTH - 1;
            boolean inset = true;
            Color oldColor = g.getColor();
            g.setColor(SystemColor.controlShadow);
            g.drawLine(x, 1, x, h - 1 - 1);
            g.setColor(SystemColor.controlLtHighlight);
            g.drawLine(x + 1, 1, x + 1, h - 1 - 1);
            g.setColor(oldColor);
        }
        int xoff = -1;
        int x = w - 1 - (POPUP_WIDTH + POPUP_ICON.getIconWidth()) / 2 + -1;
        int y = (h - 1 - POPUP_ICON.getIconHeight()) / 2;
        POPUP_ICON.paintIcon(this, g, x, y);
    }

    protected void configurePropertiesFromAction(Action a) {
        super.configurePropertiesFromAction(a);
        this.setMenuActions(a != null ? (Action[])a.getValue("ActionMenuActions") : NULL_ACTIONS);
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        return new 3(this, a);
    }

    protected ActionListener createActionListener() {
        return new FilterActionEvents(this);
    }

    protected JPopupMenu createPopupMenu() {
        if (this._popup != null) {
            this.releasePopupMenu();
        }
        this._popup = new JPopupMenu();
        this._popup.addPopupMenuListener(POPUP_MENU_LISTENER);
        this.invalidate();
        return this._popup;
    }

    protected void releasePopupMenu() {
        if (this._popup != null) {
            this._popup.removePopupMenuListener(POPUP_MENU_LISTENER);
            this._popup = null;
            this.invalidate();
        }
    }

    protected boolean hasPopup() {
        return this._popup != null;
    }

    protected boolean isPopupVisible() {
        return this._popup != null && this._popup.isVisible();
    }

    static Image ra$_capturedImage(ActionMenuToolButton actionMenuToolButton) {
        return actionMenuToolButton._capturedImage;
    }

    static void mav$fireActionPerformed(ActionMenuToolButton actionMenuToolButton, ActionEvent actionEvent) {
        actionMenuToolButton.fireActionPerformed(actionEvent);
    }

    static void wa$_capturedImage(ActionMenuToolButton actionMenuToolButton, Image image) {
        actionMenuToolButton._capturedImage = image;
    }

    final class 1
    extends AbstractAction {
        private final /* synthetic */ ButtonCaptureAdapter v$adapter;
        final /* synthetic */ ActionMenuToolButton this$0;

        public void actionPerformed(ActionEvent e) {
            if (this.this$0.hasPopup()) {
                ButtonCaptureAdapter.mav$showPopupMenu(this.v$adapter, e);
            }
        }

        public 1(ActionMenuToolButton actionMenuToolButton, String string, ButtonCaptureAdapter buttonCaptureAdapter) {
            this.v$adapter = buttonCaptureAdapter;
            this.this$0 = actionMenuToolButton;
            super(string);
        }
    }

    final class 2
    extends JToggleButton.ToggleButtonModel {
        public boolean isSelected() {
            return ActionMenuToolButton.this.isPopupVisible();
        }

        public void setPressed(boolean b) {
            super.setPressed(b);
            if (!b && !ActionMenuToolButton.this.isPopupVisible()) {
                ActionMenuToolButton.wa$_capturedImage(ActionMenuToolButton.this, null);
            }
        }
    }

    final class 3
    extends ToolButton.DefaultActionPropertyChangeListener {
        protected void _propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("ActionMenuActions")) {
                this.menuActionsChanged(e);
            } else {
                super._propertyChange(e);
            }
        }

        protected void menuActionsChanged(PropertyChangeEvent e) {
            Action[] actions = (Action[])e.getNewValue();
            ActionMenuToolButton button = (ActionMenuToolButton)this.getAdaptee();
            button.setMenuActions(actions != null ? actions : NULL_ACTIONS);
        }

        public 3(AbstractButton abstractButton, Action action) {
            super(abstractButton, action);
        }
    }

    protected static class FilterActionEvents
    implements ActionListener,
    Serializable {
        private ActionMenuToolButton _button;

        public FilterActionEvents(ActionMenuToolButton button) {
            this._button = button;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.canPerformAction()) {
                ActionMenuToolButton.mav$fireActionPerformed(this._button, e);
            }
        }

        protected boolean canPerformAction() {
            return !this._button.isPopupVisible() && ActionMenuToolButton.ra$_capturedImage(this._button) == null;
        }
    }

    private static final class ButtonCaptureAdapter
    implements MouseInputListener,
    ComponentListener,
    PropertyChangeListener {
        private BufferedImage _buttonImage;
        private boolean _captured;

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            if (!this._captured) {
                this.captureButtonImage(e);
            }
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            this.mouseEntered(e);
        }

        public void mousePressed(MouseEvent e) {
            ActionMenuToolButton b = (ActionMenuToolButton)e.getComponent();
            if (b._popup.getComponentCount() > 0 && this.isInPopup(e)) {
                this.showPopupMenu(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void componentHidden(ComponentEvent e) {
            this.uncaptureImage(e);
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            this.uncaptureImage(e);
        }

        public void componentShown(ComponentEvent e) {
            this.uncaptureImage(e);
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("icon") || propertyName.equals("foreground") || propertyName.equals("background") || propertyName.equals("border") || propertyName.equals("opaque") || propertyName.equals("contentAreaFilled") || propertyName.equals("borderPainted") || propertyName.equals("rolloverEnabled") || propertyName.equals("rolloverIcon") || propertyName.equals("UI")) {
                this.uncaptureImage(e);
            }
        }

        private void showPopupMenu(EventObject e) {
            ActionMenuToolButton b = (ActionMenuToolButton)e.getSource();
            if (!this._captured) {
                this.capturePopupImage(e);
            }
            ActionMenuToolButton.wa$_capturedImage(b, this._captured ? this._buttonImage : null);
            MenuToolButtonUtils.showComponentPopupMenu(b, b._popup);
        }

        private void captureButtonImage(EventObject e) {
            AbstractButton b = (AbstractButton)e.getSource();
            if (b.isEnabled() && b.isRolloverEnabled()) {
                BufferedImage image = this.getBufferedImage(b);
                if (!b.getModel().isRollover()) {
                    b.getModel().setRollover(true);
                }
                Graphics2D g2 = image.createGraphics();
                g2.setClip(0, 0, b.getWidth() - POPUP_WIDTH, b.getHeight());
                b.paintAll(g2);
                g2.dispose();
            }
        }

        private void capturePopupImage(EventObject e) {
            AbstractButton b = (AbstractButton)e.getSource();
            if (b.isEnabled() && b.isRolloverEnabled()) {
                BufferedImage image = this.getBufferedImage(b);
                Graphics2D g2 = image.createGraphics();
                g2.setClip(b.getWidth() - POPUP_WIDTH, 0, POPUP_WIDTH, b.getHeight());
                b.paintAll(g2);
                g2.dispose();
                this._captured = true;
            }
        }

        private void uncaptureImage(EventObject e) {
            ActionMenuToolButton b = (ActionMenuToolButton)e.getSource();
            ActionMenuToolButton.wa$_capturedImage(b, null);
            this._captured = false;
        }

        private BufferedImage getBufferedImage(AbstractButton b) {
            if (this._buttonImage == null) {
                this._buttonImage = new BufferedImage(b.getWidth(), b.getHeight(), 2);
            }
            return this._buttonImage;
        }

        private boolean isInPopup(MouseEvent e) {
            ActionMenuToolButton b = (ActionMenuToolButton)e.getComponent();
            return SwingUtilities.isLeftMouseButton(e) && b.isEnabled() && b.hasPopup() && b.contains(e.getX(), e.getY()) && e.getX() >= b.getWidth() - POPUP_WIDTH;
        }

        private ButtonCaptureAdapter() {
        }

        ButtonCaptureAdapter(1 var1_1) {
            this();
        }

        static void mav$showPopupMenu(ButtonCaptureAdapter buttonCaptureAdapter, EventObject eventObject) {
            buttonCaptureAdapter.showPopupMenu(eventObject);
        }

        public final class 1 {
        }
    }
}

