/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Polygon;
import javax.swing.Icon;
import javax.swing.UIManager;

public final class ArrowIcon
implements Icon {
    private final int _height;
    private final int _width;
    private final Polygon _polygon;

    public ArrowIcon(int scale, int dir) {
        int[] ypoints;
        int[] xpoints;
        if (scale <= 0) {
            throw new IllegalArgumentException("scale must be greater than zero.");
        }
        if (dir == 7 || dir == 3) {
            int[] nArray;
            if (dir == 7) {
                int[] nArray2 = new int[4];
                nArray2[0] = 0;
                nArray2[1] = scale - 1;
                nArray2[2] = scale - 1;
                nArray = nArray2;
                nArray2[3] = 0;
            } else {
                int[] nArray3 = new int[4];
                nArray3[0] = scale - 1;
                nArray3[1] = 0;
                nArray3[2] = 0;
                nArray = nArray3;
                nArray3[3] = scale - 1;
            }
            xpoints = nArray;
            ypoints = new int[]{scale - 1, 0, scale * 2 - 1, scale};
            this._height = scale * 2;
            this._width = scale;
        } else if (dir == 1 || dir == 5) {
            int[] nArray;
            xpoints = new int[]{scale - 1, 0, scale * 2 - 1, scale};
            if (dir == 1) {
                int[] nArray4 = new int[4];
                nArray4[0] = 0;
                nArray4[1] = scale - 1;
                nArray4[2] = scale - 1;
                nArray = nArray4;
                nArray4[3] = 0;
            } else {
                int[] nArray5 = new int[4];
                nArray5[0] = scale - 1;
                nArray5[1] = 0;
                nArray5[2] = 0;
                nArray = nArray5;
                nArray5[3] = scale - 1;
            }
            ypoints = nArray;
            this._height = scale;
            this._width = scale * 2;
        } else {
            throw new IllegalArgumentException("Invalid arrow direction");
        }
        this._polygon = new Polygon(xpoints, ypoints, 4);
    }

    public int getIconHeight() {
        return this._height;
    }

    public int getIconWidth() {
        return this._width;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Color oldColor = g.getColor();
        if (c != null) {
            g.setColor(UIManager.getColor(c.isEnabled() ? "controlText" : "textInactiveText"));
        }
        g.translate(x, y);
        g.fillPolygon(this._polygon);
        g.drawPolygon(this._polygon);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }
}

