/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.swing.AbstractButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.config.ChangeEventSource;

public abstract class ChangeAdaptor
implements ChangeListener {
    private static ReferenceQueue _queue = new ReferenceQueue();
    private WeakAbstractButton _adapteeReference;

    public ChangeAdaptor(AbstractButton adaptee, ChangeEventSource action) {
        ChangeAdaptor.clearQueue();
        this._adapteeReference = new WeakAbstractButton(adaptee, action, this, _queue);
    }

    private static void clearQueue() {
        Reference ref;
        while ((ref = _queue.poll()) != null) {
            WeakAbstractButton weakAbstractButton = (WeakAbstractButton)ref;
            weakAbstractButton.clearReference();
        }
    }

    protected AbstractButton getAdaptee() {
        ChangeAdaptor.clearQueue();
        return (AbstractButton)this._adapteeReference.get();
    }

    public final void stateChanged(ChangeEvent e) {
        ChangeAdaptor.clearQueue();
        if (!this.isDead()) {
            this._stateChanged(e);
        }
    }

    private boolean isDead() {
        return this._adapteeReference.get() == null;
    }

    protected abstract void _stateChanged(ChangeEvent var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WeakAbstractButton
    extends WeakReference {
        protected ChangeListener _listener;
        protected ChangeEventSource _changeEventSource;

        public WeakAbstractButton(AbstractButton abstractButton, ChangeEventSource eventSource, ChangeListener listener, ReferenceQueue q) {
            super(abstractButton, q);
            this._changeEventSource = eventSource;
            this._listener = listener;
        }

        protected void clearReference() {
            this._changeEventSource.removeChangeListener(this._listener);
        }
    }
}

