/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class DropDownMenuButton
extends JToggleButton {
    private static final PopupMenuListener POPUP_CLOSE_LISTENER = new 1();

    public DropDownMenuButton() {
        this.setModel(new DropDownButtonModel());
        this.getPopupMenu().addPopupMenuListener(POPUP_CLOSE_LISTENER);
    }

    public JMenuItem addPopupItem(JMenuItem menuItem) {
        this.getPopupMenu().add(menuItem);
        return menuItem;
    }

    public JMenuItem addPopupItem(Action action) {
        JMenuItem menuItem = new JMenuItem(action);
        return this.addPopupItem(menuItem);
    }

    public JMenuItem addPopupItem(String s) {
        JMenuItem menuItem = new JMenuItem(s);
        return this.addPopupItem(menuItem);
    }

    public void addPopupSeparator() {
        this.getPopupMenu().addSeparator();
    }

    public void removePopupItem(JMenuItem menuItem) {
        this.getPopupMenu().remove(menuItem);
    }

    public void removeAllPopupItems() {
        this.getPopupMenu().removeAll();
    }

    public JPopupMenu getPopupMenu() {
        DropDownButtonModel model = (DropDownButtonModel)this.getModel();
        return model.getPopupMenu();
    }

    public void showPopupMenu() {
        JPopupMenu popup = this.getPopupMenu();
        if (popup.getComponentCount() <= 0) {
            return;
        }
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        Dimension sizeScreen = new Dimension(gc.getBounds().width, gc.getBounds().height);
        Dimension sizeButton = this.getSize();
        Dimension sizeMenu = popup.getPreferredSize();
        Point ptButton = this.getLocationOnScreen();
        int x = ptButton.x + sizeMenu.width < sizeScreen.width ? 0 : -sizeMenu.width + sizeButton.width;
        int y = ptButton.y + sizeButton.height + sizeMenu.height < sizeScreen.height ? sizeButton.height : Math.max(-ptButton.y, -sizeMenu.height);
        popup.show(this, x, y);
    }

    protected ItemListener createItemListener() {
        return new ForwardItemEventsAndShowMenu(null);
    }

    static void mav$fireItemStateChanged(DropDownMenuButton dropDownMenuButton, ItemEvent itemEvent) {
        dropDownMenuButton.fireItemStateChanged(itemEvent);
    }

    static final class 1
    implements PopupMenuListener {
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            Component invoker;
            Object source = e.getSource();
            if (source instanceof JPopupMenu && (invoker = ((JPopupMenu)source).getInvoker()) instanceof DropDownMenuButton) {
                DropDownMenuButton button = (DropDownMenuButton)invoker;
                button.getModel().setArmed(false);
                button.setSelected(false);
            }
        }
    }

    private static class DropDownButtonModel
    extends JToggleButton.ToggleButtonModel {
        private final JPopupMenu _popup;

        private void $init$() {
            this._popup = new JPopupMenu();
        }

        public DropDownButtonModel() {
            this.$init$();
        }

        public JPopupMenu getPopupMenu() {
            return this._popup;
        }
    }

    private final class ForwardItemEventsAndShowMenu
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            DropDownMenuButton.mav$fireItemStateChanged(DropDownMenuButton.this, e);
            if (e.getStateChange() == 1) {
                DropDownMenuButton.this.showPopupMenu();
            }
        }

        private ForwardItemEventsAndShowMenu() {
        }

        ForwardItemEventsAndShowMenu(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

