/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class KeyboardRedirector
implements AWTEventListener {
    private static KeyboardRedirector INSTANCE;
    private ArrayList _queue;
    private boolean _frozen;
    private int _enqueued;

    private void $init$() {
        this._queue = new ArrayList();
    }

    private void initialize() {
    }

    public static KeyboardRedirector getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new KeyboardRedirector();
            INSTANCE.initialize();
        }
        return INSTANCE;
    }

    public void freeze() {
        this._frozen = true;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.addAWTEventListener(this, 12);
    }

    public void thaw() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.removeAWTEventListener(this);
        this._frozen = false;
        int i = 0;
        while (i < this._queue.size()) {
            KeyEvent keyEvent = (KeyEvent)this._queue.get(i);
            Component component = keyEvent.getComponent();
            if (component != null) {
                component.dispatchEvent(keyEvent);
            }
            ++i;
        }
        this._queue.clear();
    }

    private void deliver(Component focusedComponent) {
        this._frozen = false;
        if (focusedComponent != null) {
            boolean waitForPressed = true;
            int i = 0;
            while (i < this._queue.size()) {
                KeyEvent event = (KeyEvent)this._queue.get(i);
                if (waitForPressed && event.getID() == 401) {
                    waitForPressed = false;
                }
                if (!waitForPressed) {
                    event.setSource(focusedComponent);
                    focusedComponent.dispatchEvent(event);
                }
                ++i;
            }
        }
        this._queue.clear();
    }

    public void eventDispatched(AWTEvent event) {
        if (this._frozen) {
            switch (event.getID()) {
                case 400: 
                case 401: 
                case 402: {
                    this.enqueue((KeyEvent)event);
                    break;
                }
                case 1004: {
                    ++this._enqueued;
                    SwingUtilities.invokeLater(new 1());
                    break;
                }
            }
        }
    }

    private void enqueue(KeyEvent keyEvent) {
        KeyEvent newEvent = new KeyEvent(keyEvent.getComponent(), keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiersEx(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
        this._queue.add(newEvent);
        keyEvent.consume();
    }

    public KeyboardRedirector() {
        this.$init$();
    }

    static int ra$_enqueued(KeyboardRedirector keyboardRedirector) {
        return keyboardRedirector._enqueued;
    }

    static void wa$_enqueued(KeyboardRedirector keyboardRedirector, int n) {
        keyboardRedirector._enqueued = n;
    }

    static boolean ra$_frozen(KeyboardRedirector keyboardRedirector) {
        return keyboardRedirector._frozen;
    }

    static void mav$deliver(KeyboardRedirector keyboardRedirector, Component component) {
        keyboardRedirector.deliver(component);
    }

    final class 1
    implements Runnable {
        public void run() {
            KeyboardRedirector keyboardRedirector = KeyboardRedirector.this;
            int n = KeyboardRedirector.ra$_enqueued(keyboardRedirector) - 1;
            KeyboardRedirector.wa$_enqueued(keyboardRedirector, n);
            if (n == 0 && KeyboardRedirector.ra$_frozen(KeyboardRedirector.this)) {
                KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                Component focusOwner = focusManager.getFocusOwner();
                KeyboardRedirector.mav$deliver(KeyboardRedirector.this, focusOwner);
            }
        }
    }
}

