/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.ide.controls.Animator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutAnimator {
    private HashMap<Component, Entry> _before;
    private Container _container;

    public LayoutAnimator(Container container) {
        container.getParent().validate();
        this._container = container;
        this._before = new HashMap();
        this.record(container, this._before);
    }

    private void record(Component component, HashMap<Component, Entry> snapshot) {
        Entry entry = new Entry(component);
        snapshot.put(component, entry);
        if (component instanceof Container) {
            Container container = (Container)component;
            int size = container.getComponentCount();
            int i = 0;
            while (i < size) {
                Component child = container.getComponent(i);
                this.record(child, snapshot);
                ++i;
            }
        }
    }

    public void animate(int stepTime, long maxTime, int steps, double center, double sigma, PropertyChangeListener propertyChangeListener) {
        this._container.getParent().validate();
        HashMap<Component, Entry> after = new HashMap<Component, Entry>(this._before.size());
        this.record(this._container, after);
        ArrayList<Component> components = new ArrayList<Component>();
        Set<Map.Entry<Component, Entry>> entrySetBefore = this._before.entrySet();
        for (Map.Entry<Component, Entry> mapEntryBefore : entrySetBefore) {
            Component component = mapEntryBefore.getKey();
            Entry valueAfter = after.get(component);
            if (valueAfter == null) continue;
            Entry valueBefore = mapEntryBefore.getValue();
            if (Entry.ra$_visible(valueBefore) && !Entry.ra$_visible(valueAfter)) {
                Entry.ra$_bounds(valueAfter).setBounds(Entry.ra$_bounds(valueBefore));
                Container parent = component.getParent();
                parent.setComponentZOrder(component, parent.getComponentCount() - 1);
                component.setVisible(true);
            }
            if (!Entry.ra$_visible(valueBefore) && Entry.ra$_visible(valueAfter)) {
                Entry.ra$_bounds(valueBefore).setBounds(Entry.ra$_bounds(valueAfter));
            }
            components.add(component);
        }
        Animator.animate(stepTime, 100000L, steps, center, sigma, new 1(this, components, after, propertyChangeListener));
        Set<Map.Entry<Component, Entry>> entrySetAfter = after.entrySet();
        for (Map.Entry<Component, Entry> mapEntryAfter : entrySetAfter) {
            Component component = mapEntryAfter.getKey();
            Entry value = mapEntryAfter.getValue();
            component.setVisible(Entry.ra$_visible(value));
        }
    }

    private static void animate(ArrayList<Component> components, HashMap<Component, Entry> before, HashMap<Component, Entry> after, double r) {
        int i = 0;
        while (i < components.size()) {
            Component component = components.get(i);
            Entry entryBefore = before.get(component);
            Entry entryAfter = after.get(component);
            Rectangle boundsBefore = Entry.ra$_bounds(entryBefore);
            Rectangle boundsAfter = Entry.ra$_bounds(entryAfter);
            component.setBounds((int)((double)boundsBefore.x + (double)(boundsAfter.x - boundsBefore.x) * r), (int)((double)boundsBefore.y + (double)(boundsAfter.y - boundsBefore.y) * r), (int)((double)boundsBefore.width + (double)(boundsAfter.width - boundsBefore.width) * r), (int)((double)boundsBefore.height + (double)(boundsAfter.height - boundsBefore.height) * r));
            ++i;
        }
    }

    static HashMap ra$_before(LayoutAnimator layoutAnimator) {
        return layoutAnimator._before;
    }

    static void maS$animate(ArrayList arrayList, HashMap hashMap, HashMap hashMap2, double d) {
        LayoutAnimator.animate(arrayList, hashMap, hashMap2, d);
    }

    static Container ra$_container(LayoutAnimator layoutAnimator) {
        return layoutAnimator._container;
    }

    private static class Entry {
        private Rectangle _bounds;
        private boolean _visible;

        public Entry(Component component) {
            this._visible = component.isVisible();
            this._bounds = this._visible ? component.getBounds() : new Rectangle();
        }

        static Rectangle ra$_bounds(Entry entry) {
            return entry._bounds;
        }

        static boolean ra$_visible(Entry entry) {
            return entry._visible;
        }
    }

    final class 1
    implements PropertyChangeListener {
        private final /* synthetic */ ArrayList v$components;
        private final /* synthetic */ HashMap v$after;
        private final /* synthetic */ PropertyChangeListener v$propertyChangeListener;
        final /* synthetic */ LayoutAnimator this$0;

        public void propertyChange(PropertyChangeEvent evt) {
            Double newValue = (Double)evt.getNewValue();
            double r = newValue;
            LayoutAnimator.maS$animate(this.v$components, LayoutAnimator.ra$_before(this.this$0), this.v$after, r);
            if (this.v$propertyChangeListener != null) {
                this.v$propertyChangeListener.propertyChange(evt);
            }
            Graphics graphics = LayoutAnimator.ra$_container(this.this$0).getGraphics();
            LayoutAnimator.ra$_container(this.this$0).paint(graphics);
            graphics.dispose();
        }

        public 1(LayoutAnimator layoutAnimator, ArrayList arrayList, HashMap hashMap, PropertyChangeListener propertyChangeListener) {
            this.v$propertyChangeListener = propertyChangeListener;
            this.v$after = hashMap;
            this.v$components = arrayList;
            this.this$0 = layoutAnimator;
        }
    }
}

