/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ProgressTrackedTask;
import oracle.ide.controls.ProgressTracker;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.resource.ProgressTrackerArb;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.jndi.Names;

final class ProgressTrackerControl
implements ProgressTracker,
ActionListener,
ContextMenuListener {
    private List _taskList;
    private boolean _containsIndeterminateTask;
    private JProgressBar _progressBar;
    private Timer _timer;
    private ProgressTableDataModel _dataModel;
    private boolean _detailsDisplayed;
    private ContextMenu _contextMenu;
    private IdeAction _detailAction;
    private JMenuItem _detailMenuItem;
    private static final String PROGRESS_TRACKER_NAME = "ide/progressTracker";
    private static final int DETAIL_CMD_ID = Ide.createCmdID("oracle.ide.controls.ProgressTrackerControl.Details");

    private void $init$() {
        this._progressBar = new JProgressBar();
    }

    public ProgressTrackerControl() {
        this.$init$();
        this._taskList = new ArrayList();
        Names.bind((javax.naming.Context)Names.newInitialContext(), (String)PROGRESS_TRACKER_NAME, (Object)this);
        this._contextMenu = new ContextMenu();
        this._contextMenu.addContextMenuListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _detailItemActionPerformed(ActionEvent e) {
        if (!this._detailsDisplayed) {
            this._detailsDisplayed = true;
            List list = this._taskList;
            synchronized (list) {
                int listLen = this._taskList.size();
                if (listLen > 1) {
                    String[] data = new String[listLen];
                    ProgressTrackedTask task = null;
                    int i = 0;
                    while (i < listLen) {
                        task = ((TaskData)this._taskList.get(i)).getTask();
                        data[i] = task.getTaskDescription();
                        ++i;
                    }
                    this._dataModel = new ProgressTableDataModel(this._taskList);
                    NiceTable niceTable = new NiceTable((TableModel)this._dataModel);
                    JScrollPane scrollPane = niceTable.getScrollPaneForTable();
                    JEWTDialog dlg = JEWTDialog.createDialog((Component)((Object)Ide.getMainWindow()), (String)ProgressTrackerArb.getString(3), (int)16);
                    dlg.setContent((Component)scrollPane);
                    dlg.setInitialFocus((Component)niceTable);
                    dlg.setLocationRelativeTo((Component)this._progressBar);
                    dlg.setPreferredSize(350, 250);
                    dlg.setResizable(true);
                    WizardLauncher.runDialog((JDialog)dlg);
                    scrollPane.remove((Component)niceTable);
                    this._dataModel.removeTableModelListener((TableModelListener)niceTable);
                    niceTable = null;
                    this._dataModel = null;
                    this._detailsDisplayed = false;
                }
            }
        }
    }

    public void addTask(ProgressTrackedTask task) {
        this.addTask(task, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(ProgressTrackedTask task, String threadName) {
        List list = this._taskList;
        synchronized (list) {
            TaskData taskData = new TaskData(task, threadName);
            this._taskList.add(taskData);
            if (task.isIndeterminate()) {
                this._containsIndeterminateTask = true;
            }
            if (this._timer == null) {
                this._createUI();
                this._timer = new Timer(200, this);
                this._timer.start();
            }
            taskData.getThread().start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread(ProgressTrackedTask task) {
        TaskData taskData = null;
        Thread thread = null;
        List list = this._taskList;
        synchronized (list) {
            int listLen = this._taskList.size();
            int i = 0;
            while (i < listLen) {
                taskData = (TaskData)this._taskList.get(i);
                if (taskData.getTask() == task) {
                    thread = taskData.getThread();
                    break;
                }
                ++i;
            }
        }
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void menuWillShow(ContextMenu popup) {
        if (this._detailMenuItem == null) {
            this._detailAction = IdeAction.get(DETAIL_CMD_ID, ProgressTrackerArb.getString(1), ProgressTrackerArb.getInteger(0));
            this._detailMenuItem = this._contextMenu.createMenuItem(this._detailAction);
            this._detailMenuItem.addActionListener(new 1());
        }
        this._contextMenu.add(this._detailMenuItem);
        List list = this._taskList;
        synchronized (list) {
            int listLen = this._taskList.size();
            this._detailMenuItem.setEnabled(listLen > 1);
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        this._updateUI();
    }

    public static ProgressTracker getProgressTracker() {
        return (ProgressTracker)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)PROGRESS_TRACKER_NAME);
    }

    static float calculatePctComplete(ProgressTrackedTask task) {
        return (float)task.getCurrentValue() / (float)task.getMaximum() * 100.0f;
    }

    private void _createUI() {
        2 runnable = new 2();
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void _destroyUI() {
        this._progressBar.setVisible(false);
        Ide.getStatusBar().getGUI().repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateUI() {
        List list = this._taskList;
        synchronized (list) {
            this._removeCompletedTasks();
            if (this._taskList.size() == 1) {
                TaskData taskData = (TaskData)this._taskList.get(0);
                ProgressTrackedTask task = taskData.getTask();
                if (task.isIndeterminate()) {
                    this._progressBar.setIndeterminate(true);
                } else {
                    this._progressBar.setMinimum(task.getMinimum());
                    this._progressBar.setMaximum(task.getMaximum());
                    this._progressBar.setValue(task.getCurrentValue());
                }
                if (task.getCurrentText() == null) {
                    this._progressBar.setString("");
                } else {
                    this._progressBar.setString(task.getCurrentText());
                }
                this._progressBar.setToolTipText(task.getTaskDescription());
            } else {
                this._progressBar.setString("");
                if (this._containsIndeterminateTask) {
                    this._progressBar.setIndeterminate(true);
                } else {
                    int listLen = this._taskList.size();
                    TaskData taskData = null;
                    ProgressTrackedTask task = null;
                    float pctComplete = 0.0f;
                    int i = 0;
                    while (i < listLen) {
                        taskData = (TaskData)this._taskList.get(i);
                        task = taskData.getTask();
                        pctComplete += ProgressTrackerControl.calculatePctComplete(task);
                        ++i;
                    }
                    this._progressBar.setMinimum(0);
                    this._progressBar.setMaximum(100);
                    this._progressBar.setValue(Math.round(pctComplete / (float)listLen));
                }
                this._progressBar.setToolTipText(ProgressTrackerArb.format(4, Integer.toString(this._taskList.size())));
                if (this._dataModel != null) {
                    this._dataModel.updateData();
                }
            }
        }
    }

    private void _removeCompletedTasks() {
        int listLen = this._taskList.size();
        TaskData taskData = null;
        Thread taskThread = null;
        ArrayList<TaskData> tasksToRemove = new ArrayList<TaskData>();
        int i = 0;
        while (i < listLen) {
            taskData = (TaskData)this._taskList.get(i);
            taskThread = taskData.getThread();
            if (!taskThread.isAlive()) {
                tasksToRemove.add(taskData);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < tasksToRemove.size()) {
            this._removeTask((TaskData)tasksToRemove.get(i2));
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _removeTask(TaskData taskData) {
        List list = this._taskList;
        synchronized (list) {
            if (this._taskList.contains(taskData)) {
                this._taskList.remove(taskData);
            }
            boolean hasIndeterminateTask = false;
            int listLen = this._taskList.size();
            if (listLen == 0) {
                hasIndeterminateTask = false;
                this._timer.stop();
                this._timer = null;
                this._destroyUI();
            } else {
                ProgressTrackedTask currTask = null;
                int i = 0;
                while (i < listLen) {
                    currTask = ((TaskData)this._taskList.get(i)).getTask();
                    if (currTask.isIndeterminate()) {
                        hasIndeterminateTask = true;
                        break;
                    }
                    ++i;
                }
            }
            this._containsIndeterminateTask = hasIndeterminateTask;
            this._progressBar.setIndeterminate(this._containsIndeterminateTask);
        }
    }

    static JProgressBar ra$_progressBar(ProgressTrackerControl progressTrackerControl) {
        return progressTrackerControl._progressBar;
    }

    static void mav$_detailItemActionPerformed(ProgressTrackerControl progressTrackerControl, ActionEvent actionEvent) {
        progressTrackerControl._detailItemActionPerformed(actionEvent);
    }

    static ContextMenu ra$_contextMenu(ProgressTrackerControl progressTrackerControl) {
        return progressTrackerControl._contextMenu;
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ProgressTrackerControl.mav$_detailItemActionPerformed(ProgressTrackerControl.this, e);
        }
    }

    final class 2
    implements Runnable {
        public void run() {
            Toolbar toolbar = Ide.getStatusBar().getToolbar();
            toolbar.add((Component)ProgressTrackerControl.ra$_progressBar(ProgressTrackerControl.this), 0);
            Dimension minDim = ProgressTrackerControl.ra$_progressBar(ProgressTrackerControl.this).getMinimumSize();
            ProgressTrackerControl.ra$_progressBar(ProgressTrackerControl.this).setMinimumSize(new Dimension(100, minDim.height));
            ProgressTrackerControl.ra$_progressBar(ProgressTrackerControl.this).setVisible(false);
            ProgressTrackerControl.ra$_progressBar(ProgressTrackerControl.this).addMouseListener(new 1());
            ProgressTrackerControl.ra$_progressBar(ProgressTrackerControl.this).setStringPainted(true);
            ProgressTrackerControl.ra$_progressBar(ProgressTrackerControl.this).setString("");
            ProgressTrackerControl.ra$_progressBar(ProgressTrackerControl.this).setVisible(true);
        }

        final class 1
        extends MouseAdapter {
            public void mousePressed(MouseEvent e) {
                this.triggerPopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.triggerPopup(e);
            }

            protected void triggerPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ProgressTrackerControl.ra$_contextMenu(ProgressTrackerControl.this).show(Ide.getMainWindow().getIdeMainWindowView().getContext(e));
                }
            }
        }
    }

    private class ProgressTableDataModel
    extends AbstractTableModel {
        private List _taskList;
        private static final int NUM_COLUMNS = 2;
        private static final int TASK_DESCR = 0;
        private static final int PCT_COMPLETE = 1;

        public ProgressTableDataModel(List taskList) {
            this._taskList = taskList;
        }

        public int getRowCount() {
            return this._taskList.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public Class getColumnClass(int modelIndex) {
            switch (modelIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return null;
        }

        void updateData() {
            this.fireTableDataChanged();
        }

        public Object getValueAt(int row, int column) {
            ProgressTrackedTask task = ((TaskData)this._taskList.get(row)).getTask();
            switch (column) {
                case 0: {
                    return task.getTaskDescription();
                }
                case 1: {
                    if (task.isIndeterminate()) {
                        return ProgressTrackerArb.getString(5);
                    }
                    int pctComplete = Math.round(ProgressTrackerControl.calculatePctComplete(task));
                    return String.valueOf(pctComplete);
                }
            }
            return null;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return ProgressTrackerArb.getString(2);
                }
                case 1: {
                    return ProgressTrackerArb.getString(6);
                }
            }
            return null;
        }
    }

    private static class TaskData {
        private ProgressTrackedTask _task;
        private Thread _thread;

        public TaskData(ProgressTrackedTask progressTrackedTask, String threadName) {
            this._task = progressTrackedTask;
            this._thread = new Thread(this._task);
            if (threadName == null) {
                this._thread.setName(this._task.getTaskDescription());
            } else {
                this._thread.setName(threadName);
            }
        }

        public ProgressTrackedTask getTask() {
            return this._task;
        }

        public Thread getThread() {
            return this._thread;
        }
    }
}

