/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.accessibility.Accessible;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import oracle.bali.ewt.util.MenuUtils;
import oracle.ide.controls.SingleRowTabbedPane;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleMenuItem;
import oracle.ide.resource.ControlsArb;
import oracle.ide.resource.IdeIcons;

public class SingleRowTabbedPaneUI
extends BasicTabbedPaneUI {
    private static final Insets _tabAreaInsets = new Insets(0, 0, 0, 0);
    private static final Insets _contentBorderInsets = new Insets(2, 0, 0, 0);
    private static final Insets _selectedTabPadInsets = new Insets(0, 0, 0, 0);
    protected static final Comparator scrollMenuItemComparator = new ScrollMenuItemComparator();
    protected static final Icon blankIcon = IdeIcons.getIcon((int)23);
    protected static final Icon scrollBothIcon = ControlsArb.getIcon(8);
    protected static final Icon scrollLeftIcon = ControlsArb.getIcon(6);
    protected static final Icon scrollRightIcon = ControlsArb.getIcon(0);
    protected static final int scrollButtonWidth = Math.max(scrollBothIcon.getIconWidth(), Math.max(scrollLeftIcon.getIconWidth(), scrollRightIcon.getIconWidth()));
    protected static final int scrollButtonHeight = Math.max(scrollBothIcon.getIconHeight(), Math.max(scrollLeftIcon.getIconHeight(), scrollRightIcon.getIconHeight()));
    protected Color tabAreaBackground;
    protected Color selectColor;
    protected EventHandler eventHandler;
    protected JPopupMenu scrollMenu;
    protected Font scrollMenuBoldFont;
    protected ToggleAction scrollMenuSortAction;
    protected ToggleAction scrollMenuShowVisibleAction;
    protected int mouseOverIndex;
    protected int firstVisibleIndex;
    protected int lastVisibleIndex;
    protected boolean lockFirstVisible;

    private SingleRowTabbedPaneUI() {
    }

    public void showScrollMenu() {
        if (this.isScrollButtonVisible() && !this.isScrollMenuVisible()) {
            this.setScrollMenuVisible(true);
        }
    }

    public int tabForCoordinate(JTabbedPane pane, int x, int y) {
        return super.tabForCoordinate(pane, x, y);
    }

    public Rectangle getTabBounds(JTabbedPane pane, int index) {
        return super.getTabBounds(pane, index);
    }

    public int getTabRunCount() {
        return 1;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.runCount = 1;
        this.scrollMenu = new JPopupMenu();
        this.scrollMenu.addPopupMenuListener(this.eventHandler);
        this.scrollMenuBoldFont = this.getScrollMenuBoldFont(this.scrollMenu);
        this.scrollMenuSortAction = new ScrollMenuSortAction();
        this.scrollMenuShowVisibleAction = new ScrollMenuShowVisibleAction();
        this.mouseOverIndex = -1;
        this.firstVisibleIndex = -1;
        this.lastVisibleIndex = -1;
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.runCount = 0;
        this.scrollMenu = null;
        this.scrollMenu.removePopupMenuListener(this.eventHandler);
        this.scrollMenuSortAction = null;
        this.scrollMenuShowVisibleAction = null;
        this.mouseOverIndex = -1;
        this.firstVisibleIndex = -1;
        this.lastVisibleIndex = -1;
    }

    public void paint(Graphics g, JComponent c) {
        this.ensureCurrentLayout();
        int tabPlacement = this.tabPane.getTabPlacement();
        int tabCount = this.tabPane.getTabCount();
        int selectedIndex = this.tabPane.getSelectedIndex();
        Rectangle clipRect = g.getClipBounds();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        int i = 0;
        while (i < tabCount) {
            if (this.rects[i].intersects(clipRect)) {
                this.paintTab(g, tabPlacement, this.rects, i, iconRect, textRect);
            }
            ++i;
        }
        if (this.isScrollButtonVisible() && this.rects[tabCount].intersects(clipRect)) {
            this.paintScrollButton(g, tabPlacement, this.rects[tabCount]);
        }
        this.paintContentBorder(g, tabPlacement, selectedIndex);
    }

    public void update(Graphics g, JComponent c) {
        if (this.tabAreaBackground != null) {
            if (c.isOpaque()) {
                g.setColor(this.tabAreaBackground);
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
            this.paint(g, c);
        } else {
            super.update(g, c);
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        return super.getPreferredSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        return super.getMinimumSize(c);
    }

    public Dimension getMaximumSize(JComponent c) {
        return super.getMaximumSize(c);
    }

    public boolean contains(JComponent c, int x, int y) {
        return super.contains(c, x, y);
    }

    public static ComponentUI createUI(JComponent c) {
        return new SingleRowTabbedPaneUI();
    }

    public int getAccessibleChildrenCount(JComponent c) {
        return super.getAccessibleChildrenCount(c);
    }

    public Accessible getAccessibleChild(JComponent c, int i) {
        return super.getAccessibleChild(c, i);
    }

    protected void installListeners() {
        super.installListeners();
        this.eventHandler = this.createEventHandler();
        if (this.eventHandler != null) {
            this.tabPane.addMouseListener(this.eventHandler);
            this.tabPane.addMouseMotionListener(this.eventHandler);
            this.tabPane.addChangeListener(this.eventHandler);
            this.tabPane.addFocusListener(this.eventHandler);
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.eventHandler != null) {
            this.tabPane.removeMouseListener(this.eventHandler);
            this.tabPane.removeMouseMotionListener(this.eventHandler);
            this.tabPane.removeChangeListener(this.eventHandler);
            this.tabPane.removeFocusListener(this.eventHandler);
            this.eventHandler = null;
        }
    }

    protected void installDefaults() {
        super.installDefaults();
        this.tabAreaBackground = UIManager.getColor("TabbedPane.tabAreaBackground");
        this.selectColor = UIManager.getColor("TabbedPane.selected");
        this.tabAreaInsets = _tabAreaInsets;
        this.contentBorderInsets = _contentBorderInsets;
        this.selectedTabPadInsets = _selectedTabPadInsets;
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.tabAreaBackground = null;
        this.selectColor = null;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return null;
    }

    protected ChangeListener createChangeListener() {
        return null;
    }

    protected FocusListener createFocusListener() {
        return null;
    }

    protected LayoutManager createLayoutManager() {
        return new SingleRowTabbedPaneLayout();
    }

    protected Icon getIconForTab(int tabIndex) {
        Icon disabledIcon;
        if ((!this.isTabEnabled(tabIndex) || tabIndex != this.tabPane.getSelectedIndex() && tabIndex != this.mouseOverIndex) && (disabledIcon = this.tabPane.getDisabledIconAt(tabIndex)) != null) {
            return disabledIcon;
        }
        return this.tabPane.getIconAt(tabIndex);
    }

    protected Icon getIconForMenu(int tabIndex) {
        Icon icon = this.tabPane.getIconAt(tabIndex);
        return icon != null ? icon : blankIcon;
    }

    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        if (!this.isTabVisible(tabIndex)) {
            return;
        }
        Rectangle tabRect = rects[tabIndex];
        int selectedIndex = this.tabPane.getSelectedIndex();
        boolean isSelected = selectedIndex == tabIndex;
        this.paintTabBackground(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        this.paintTabBorder(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        Font font = this.tabPane.getFont();
        FontMetrics metrics = g.getFontMetrics(font);
        Icon icon = this.getIconForTab(tabIndex);
        String title = this.tabPane.getTitleAt(tabIndex);
        title = this.layoutCompoundLabel(tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
        this.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
        this.paintIcon(g, tabPlacement, font, metrics, tabIndex, icon, iconRect, isSelected);
        this.paintFocusIndicator(g, tabPlacement, rects, tabIndex, iconRect, textRect, isSelected);
    }

    protected void paintIcon(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, Icon icon, Rectangle iconRect, boolean isSelected) {
        int hotkey;
        super.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
        if (icon != null && (hotkey = this.getHotkeyAt(tabIndex)) != -1) {
            Rectangle iconIcon = new Rectangle();
            Rectangle iconText = new Rectangle();
            String num = Integer.toString(hotkey);
            this.layoutCompoundLabel(tabPlacement, metrics, tabIndex, num, null, iconRect, iconIcon, iconText, false);
            Color bg = this.selectColor != null ? this.selectColor : this.tabPane.getBackgroundAt(tabIndex);
            g.setColor(bg);
            if (isSelected || tabIndex == this.mouseOverIndex) {
                Graphics2D g2 = (Graphics2D)g;
                RenderingHints oldHints = g2.getRenderingHints();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                TextLayout textLayout = new TextLayout(num, g.getFont(), g2.getFontRenderContext());
                AffineTransform transform = new AffineTransform();
                Rectangle2D bounds = textLayout.getBounds();
                transform.setToTranslation((double)iconText.x - bounds.getX() + (iconText.getWidth() - bounds.getWidth()) / 2.0, (double)iconText.y - bounds.getY() + (iconText.getHeight() - bounds.getHeight()) / 2.0);
                g2.draw(textLayout.getOutline(transform));
                g.setColor(this.tabPane.getForegroundAt(tabIndex));
                this.paintText(g, tabPlacement, font, metrics, tabIndex, num, iconText, isSelected);
                g2.setRenderingHints(oldHints);
            } else {
                this.paintText(g, tabPlacement, font, metrics, tabIndex, num, iconText, isSelected);
            }
        }
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (this.selectColor != null) {
            g.setColor(this.selectColor);
        } else {
            g.setColor(this.tabPane.getBackgroundAt(tabIndex));
        }
        switch (tabPlacement) {
            case 2: {
                g.fillRect(x, y, w, h - 1);
                break;
            }
            case 4: {
                g.fillRect(x, y, w, h - 1);
                break;
            }
            case 3: {
                g.fillRect(x, y, w - 1, h);
                break;
            }
            default: {
                g.fillRect(x, y, w - 1, h);
            }
        }
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Color rightBottomColor;
        boolean isOver = tabIndex == this.mouseOverIndex;
        Color leftTopColor = isSelected ? this.shadow : this.lightHighlight;
        Color color = rightBottomColor = isSelected ? this.lightHighlight : this.shadow;
        if (isSelected || isOver) {
            g.setColor(leftTopColor);
            g.drawLine(x, y + h - 1, x, y);
            g.drawLine(x, y, x + w - 1, y);
        }
        g.setColor(rightBottomColor);
        g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
        if (isOver && !isSelected) {
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        }
    }

    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        g.setColor(this.lightHighlight);
        g.drawLine(x, y + 1, x + w - 1, y + 1);
        g.setColor(this.shadow);
        g.drawLine(x, y, x + w - 1, y);
        if (selectedIndex != -1) {
            Rectangle tabRect = this.rects[selectedIndex];
            if (this.selectColor != null) {
                g.setColor(this.selectColor);
            } else {
                g.setColor(this.tabPane.getBackgroundAt(selectedIndex));
            }
            g.drawLine(tabRect.x + 1, y, tabRect.x + tabRect.width - 2, y);
        }
    }

    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    protected String layoutCompoundLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        title = SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, 0, 0, 11, tabRect, iconRect, textRect, this.textIconGap);
        int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        iconRect.x += xNudge;
        iconRect.y += yNudge;
        textRect.x += xNudge;
        textRect.y += yNudge;
        return title;
    }

    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.rects[tabIndex];
        switch (tabPlacement) {
            case 1: 
            case 2: {
                return isSelected ? 1 : 0;
            }
            case 3: 
            case 4: {
                return isSelected ? 0 : -1;
            }
        }
        return 0;
    }

    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.rects[tabIndex];
        switch (tabPlacement) {
            case 1: 
            case 2: {
                return isSelected ? 1 : 0;
            }
            case 3: 
            case 4: {
                return isSelected ? 0 : -1;
            }
        }
        return 0;
    }

    protected int calculateMaxTabHeight(int tabPlacement) {
        int height = super.calculateMaxTabHeight(tabPlacement);
        return Math.max(height, scrollButtonHeight);
    }

    protected EventHandler createEventHandler() {
        return new EventHandler();
    }

    protected int getHotkeyAt(int tabIndex) {
        return ((SingleRowTabbedPane)this.tabPane).getHotkeyAt(tabIndex);
    }

    protected void paintScrollButton(Graphics g, int tabPlacement, Rectangle rect) {
        Icon icon;
        int tabCount = this.tabPane.getTabCount();
        if (this.firstVisibleIndex > 0 && this.lastVisibleIndex < tabCount - 1) {
            icon = scrollBothIcon;
        } else if (this.firstVisibleIndex > 0) {
            icon = scrollLeftIcon;
        } else if (this.lastVisibleIndex < tabCount - 1) {
            icon = scrollRightIcon;
        } else {
            return;
        }
        boolean isSelected = this.isScrollMenuVisible();
        boolean isOver = this.mouseOverIndex == tabCount;
        int x = rect.x + (rect.width - icon.getIconWidth()) / 2 + this.getTabLabelShiftX(tabPlacement, tabCount, isSelected);
        int y = rect.y + (rect.height - icon.getIconHeight()) / 2 + this.getTabLabelShiftY(tabPlacement, tabCount, isSelected);
        if (isSelected || isOver) {
            this.paintTabBorder(g, tabPlacement, tabCount, rect.x, rect.y, rect.width, rect.height, isSelected);
        }
        icon.paintIcon(this.tabPane, g, x, y);
    }

    protected void setMouseOver(int tabIndex) {
        if (this.mouseOverIndex != tabIndex) {
            int tabPlacement = this.tabPane.getTabPlacement();
            if (this.mouseOverIndex != -1) {
                this.repaintTab(this.mouseOverIndex);
            }
            this.mouseOverIndex = tabIndex;
            if (tabIndex != -1) {
                this.repaintTab(tabIndex);
            }
        }
    }

    protected void repaintTab(int tabIndex) {
        if (tabIndex >= 0 && tabIndex < this.rects.length) {
            this.tabPane.repaint(this.rects[tabIndex]);
        }
    }

    protected boolean isTabEnabled(int tabIndex) {
        return this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex);
    }

    protected boolean isTabVisible(int tabIndex) {
        return tabIndex >= 0 && tabIndex < this.tabPane.getTabCount() && this.rects[tabIndex].width != 0;
    }

    protected boolean isInScrollButton(int x, int y) {
        if (!this.isScrollButtonVisible()) {
            return false;
        }
        int tabCount = this.tabPane.getTabCount();
        return this.rects[tabCount].contains(x, y);
    }

    protected boolean isScrollButtonVisible() {
        if (this.firstVisibleIndex > 0) {
            return true;
        }
        int tabCount = this.tabPane.getTabCount();
        return this.lastVisibleIndex < tabCount - 1;
    }

    protected boolean isScrollMenuSorted() {
        return this.scrollMenuSortAction.getState();
    }

    protected void setScrollMenuSorted(boolean sorted) {
        this.scrollMenuSortAction.setState(sorted);
    }

    protected boolean isScrollMenuShowVisible() {
        return this.scrollMenuShowVisibleAction.getState();
    }

    protected void setScrollMenuShowVisible(boolean showVisible) {
        this.scrollMenuShowVisibleAction.setState(showVisible);
    }

    protected boolean isScrollMenuVisible() {
        return this.scrollMenu.isVisible();
    }

    protected void setScrollMenuVisible(boolean visible) {
        if (visible == this.isScrollMenuVisible()) {
            return;
        }
        int tabCount = this.tabPane.getTabCount();
        this.repaintTab(tabCount);
        if (visible) {
            int y;
            int x;
            this.scrollMenu.removeAll();
            boolean showVisible = this.isScrollMenuShowVisible();
            boolean sortMenu = this.isScrollMenuSorted();
            ArrayList<JComponent> menuItems = new ArrayList<JComponent>(tabCount);
            int i = 0;
            while (i < tabCount) {
                if (showVisible || !this.isTabVisible(i)) {
                    menuItems.add(this.createScrollMenuItem(i));
                }
                if (!sortMenu && !showVisible && i == this.firstVisibleIndex && this.firstVisibleIndex > 0 && this.lastVisibleIndex < tabCount - 1) {
                    menuItems.add(new JSeparator());
                }
                ++i;
            }
            if (sortMenu) {
                Collections.sort(menuItems, scrollMenuItemComparator);
            }
            for (Object e : menuItems) {
                if (e instanceof JMenuItem) {
                    this.scrollMenu.add((JMenuItem)e);
                    continue;
                }
                this.scrollMenu.addSeparator();
            }
            this.scrollMenu.addSeparator();
            this.scrollMenu.add(new ToggleMenuItem(this.scrollMenuSortAction));
            Rectangle buttonBounds = this.rects[tabCount];
            Dimension size = this.scrollMenu.getPreferredSize();
            int buttonRight = buttonBounds.x + buttonBounds.width - 1;
            int buttonBottom = buttonBounds.y + buttonBounds.height - 1;
            switch (this.tabPane.getTabPlacement()) {
                case 2: {
                    x = buttonRight;
                    y = buttonBottom - size.height;
                    break;
                }
                case 4: {
                    x = buttonBounds.x - size.width;
                    y = buttonBottom - size.height;
                    break;
                }
                case 3: {
                    x = buttonRight - size.width;
                    y = buttonBounds.y - size.height;
                    break;
                }
                default: {
                    x = buttonRight - size.width;
                    y = buttonBottom;
                    break;
                }
            }
            MenuUtils.showPopupMenu((JPopupMenu)this.scrollMenu, (Component)this.tabPane, (int)x, (int)y);
        } else {
            this.scrollMenu.setVisible(false);
        }
    }

    protected JMenuItem createScrollMenuItem(int tabIndex) {
        String title = this.tabPane.getTitleAt(tabIndex);
        Icon icon = this.getIconForMenu(tabIndex);
        JMenuItem item = new JMenuItem(title, icon);
        if (this.isTabVisible(tabIndex)) {
            item.setFont(this.scrollMenuBoldFont);
        }
        item.setActionCommand(Integer.toString(tabIndex));
        item.addActionListener(this.eventHandler);
        return item;
    }

    protected Font getScrollMenuBoldFont(Component component) {
        Font font = component.getFont();
        component.setFont(font.deriveFont(0));
        return font.deriveFont(1);
    }

    protected void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            BasicTabbedPaneUI.TabbedPaneLayout layout = (BasicTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
    }

    static FontMetrics mav$getFontMetrics(SingleRowTabbedPaneUI singleRowTabbedPaneUI) {
        return singleRowTabbedPaneUI.getFontMetrics();
    }

    static JTabbedPane ra$tabPane(SingleRowTabbedPaneUI singleRowTabbedPaneUI) {
        return singleRowTabbedPaneUI.tabPane;
    }

    static Insets mav$getTabAreaInsets(SingleRowTabbedPaneUI singleRowTabbedPaneUI, int n) {
        return singleRowTabbedPaneUI.getTabAreaInsets(n);
    }

    static void wa$maxTabHeight(SingleRowTabbedPaneUI singleRowTabbedPaneUI, int n) {
        singleRowTabbedPaneUI.maxTabHeight = n;
    }

    static void wa$maxTabWidth(SingleRowTabbedPaneUI singleRowTabbedPaneUI, int n) {
        singleRowTabbedPaneUI.maxTabWidth = n;
    }

    static int mav$calculateTabWidth(SingleRowTabbedPaneUI singleRowTabbedPaneUI, int n, int n2, FontMetrics fontMetrics) {
        return singleRowTabbedPaneUI.calculateTabWidth(n, n2, fontMetrics);
    }

    static Rectangle[] ra$rects(SingleRowTabbedPaneUI singleRowTabbedPaneUI) {
        return singleRowTabbedPaneUI.rects;
    }

    static int mav$calculateTabHeight(SingleRowTabbedPaneUI singleRowTabbedPaneUI, int n, int n2, int n3) {
        return singleRowTabbedPaneUI.calculateTabHeight(n, n2, n3);
    }

    static int ra$maxTabHeight(SingleRowTabbedPaneUI singleRowTabbedPaneUI) {
        return singleRowTabbedPaneUI.maxTabHeight;
    }

    static int ra$maxTabWidth(SingleRowTabbedPaneUI singleRowTabbedPaneUI) {
        return singleRowTabbedPaneUI.maxTabWidth;
    }

    static void mav$assureRectsCreated(SingleRowTabbedPaneUI singleRowTabbedPaneUI, int n) {
        singleRowTabbedPaneUI.assureRectsCreated(n);
    }

    static void mav$setVisibleComponent(SingleRowTabbedPaneUI singleRowTabbedPaneUI, Component component) {
        singleRowTabbedPaneUI.setVisibleComponent(component);
    }

    protected class SingleRowTabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        public void calculateLayoutInfo() {
            int tabCount = SingleRowTabbedPaneUI.ra$tabPane(SingleRowTabbedPaneUI.this).getTabCount();
            SingleRowTabbedPaneUI.mav$assureRectsCreated(SingleRowTabbedPaneUI.this, tabCount + 1);
            this.calculateTabRects(SingleRowTabbedPaneUI.ra$tabPane(SingleRowTabbedPaneUI.this).getTabPlacement(), tabCount);
        }

        protected void calculateTabRects(int tabPlacement, int tabCount) {
            FontMetrics metrics = SingleRowTabbedPaneUI.mav$getFontMetrics(SingleRowTabbedPaneUI.this);
            int fontHeight = metrics.getHeight();
            Insets insets = SingleRowTabbedPaneUI.ra$tabPane(SingleRowTabbedPaneUI.this).getInsets();
            Insets tabAreaInsets = SingleRowTabbedPaneUI.mav$getTabAreaInsets(SingleRowTabbedPaneUI.this, tabPlacement);
            Dimension size = SingleRowTabbedPaneUI.ra$tabPane(SingleRowTabbedPaneUI.this).getSize();
            int selectedIndex = SingleRowTabbedPaneUI.ra$tabPane(SingleRowTabbedPaneUI.this).getSelectedIndex();
            SingleRowTabbedPaneUI.wa$maxTabHeight(SingleRowTabbedPaneUI.this, SingleRowTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement));
            SingleRowTabbedPaneUI.wa$maxTabWidth(SingleRowTabbedPaneUI.this, 0);
            int x = insets.left + tabAreaInsets.left;
            int y = insets.top + tabAreaInsets.top;
            int returnAt = size.width - (insets.right + tabAreaInsets.right);
            if (SingleRowTabbedPaneUI.this.lockFirstVisible) {
                SingleRowTabbedPaneUI.this.lastVisibleIndex = SingleRowTabbedPaneUI.this.firstVisibleIndex;
            } else {
                SingleRowTabbedPaneUI.this.lockFirstVisible = true;
                SingleRowTabbedPaneUI.this.lastVisibleIndex = 0;
                SingleRowTabbedPaneUI.this.firstVisibleIndex = 0;
            }
            int i = SingleRowTabbedPaneUI.this.firstVisibleIndex;
            while (i < tabCount) {
                int xMax;
                int w = SingleRowTabbedPaneUI.mav$calculateTabWidth(SingleRowTabbedPaneUI.this, tabPlacement, i, metrics);
                if (x + w > (xMax = returnAt - (SingleRowTabbedPaneUI.this.firstVisibleIndex > 0 || i < tabCount - 1 ? scrollButtonWidth : 0))) {
                    if (i > selectedIndex) {
                        int j = i;
                        while (j < tabCount) {
                            SingleRowTabbedPaneUI.ra$rects((SingleRowTabbedPaneUI)SingleRowTabbedPaneUI.this)[j].width = 0;
                            ++j;
                        }
                        break;
                    }
                    int overshoot = x + w - xMax;
                    int shift = 0;
                    int j = 0;
                    while (j < i) {
                        SingleRowTabbedPaneUI.ra$rects((SingleRowTabbedPaneUI)SingleRowTabbedPaneUI.this)[j].width = 0;
                        if ((shift += SingleRowTabbedPaneUI.ra$rects((SingleRowTabbedPaneUI)SingleRowTabbedPaneUI.this)[j].width) >= overshoot) break;
                        ++j;
                    }
                    if (shift != 0) {
                        SingleRowTabbedPaneUI.this.firstVisibleIndex = ++j;
                        while (j < i) {
                            SingleRowTabbedPaneUI.ra$rects((SingleRowTabbedPaneUI)SingleRowTabbedPaneUI.this)[j++].x -= shift;
                        }
                        x -= shift;
                    }
                }
                Rectangle r = SingleRowTabbedPaneUI.ra$rects(SingleRowTabbedPaneUI.this)[i];
                r.width = Math.min(w, xMax - x - insets.left - tabAreaInsets.left);
                r.height = SingleRowTabbedPaneUI.mav$calculateTabHeight(SingleRowTabbedPaneUI.this, tabPlacement, i, fontHeight);
                r.x = x;
                r.y = y - (r.height - SingleRowTabbedPaneUI.ra$maxTabHeight(SingleRowTabbedPaneUI.this));
                SingleRowTabbedPaneUI.wa$maxTabWidth(SingleRowTabbedPaneUI.this, Math.max(SingleRowTabbedPaneUI.ra$maxTabWidth(SingleRowTabbedPaneUI.this), w));
                x += r.width;
                SingleRowTabbedPaneUI.this.lastVisibleIndex = i++;
            }
            if (SingleRowTabbedPaneUI.this.firstVisibleIndex > 0 || SingleRowTabbedPaneUI.this.lastVisibleIndex < tabCount - 1) {
                Rectangle r = SingleRowTabbedPaneUI.ra$rects(SingleRowTabbedPaneUI.this)[tabCount];
                r.x = returnAt - scrollButtonWidth;
                r.y = y;
                r.width = scrollButtonWidth;
                r.height = SingleRowTabbedPaneUI.ra$maxTabHeight(SingleRowTabbedPaneUI.this);
                SingleRowTabbedPaneUI.this.repaintTab(tabCount);
            } else {
                SingleRowTabbedPaneUI.ra$rects((SingleRowTabbedPaneUI)SingleRowTabbedPaneUI.this)[tabCount].width = 0;
            }
            this.padSelectedTab(tabPlacement, selectedIndex);
        }

        protected SingleRowTabbedPaneLayout() {
            super(SingleRowTabbedPaneUI.this);
        }
    }

    protected class EventHandler
    implements MouseListener,
    MouseMotionListener,
    ChangeListener,
    FocusListener,
    PopupMenuListener,
    ActionListener {
        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            if (!tabPane.isEnabled()) {
                SingleRowTabbedPaneUI.this.setMouseOver(-1);
                return;
            }
            int tabIndex = SingleRowTabbedPaneUI.this.tabForCoordinate(tabPane, e.getX(), e.getY());
            if (tabIndex >= 0 && tabPane.isEnabledAt(tabIndex)) {
                SingleRowTabbedPaneUI.this.setMouseOver(tabIndex);
            } else if (SingleRowTabbedPaneUI.this.isInScrollButton(e.getX(), e.getY())) {
                SingleRowTabbedPaneUI.this.setMouseOver(tabPane.getTabCount());
            } else {
                SingleRowTabbedPaneUI.this.setMouseOver(-1);
            }
        }

        public void mouseExited(MouseEvent e) {
            SingleRowTabbedPaneUI.this.setMouseOver(-1);
        }

        public void mousePressed(MouseEvent e) {
            if (SingleRowTabbedPaneUI.this.isInScrollButton(e.getX(), e.getY())) {
                SingleRowTabbedPaneUI.this.setScrollMenuVisible(SingleRowTabbedPaneUI.this.isScrollMenuVisible() ^ true);
            } else {
                SingleRowTabbedPaneUI.this.setScrollMenuVisible(false);
            }
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            this.mouseEntered(e);
        }

        public void stateChanged(ChangeEvent e) {
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            int selectedIndex = tabPane.getSelectedIndex();
            if (selectedIndex < SingleRowTabbedPaneUI.this.firstVisibleIndex || selectedIndex > SingleRowTabbedPaneUI.this.lastVisibleIndex) {
                SingleRowTabbedPaneUI.this.lockFirstVisible = false;
                tabPane.revalidate();
            } else {
                SingleRowTabbedPaneUI.this.lockFirstVisible = true;
                SingleRowTabbedPaneUI.mav$setVisibleComponent(SingleRowTabbedPaneUI.this, tabPane.getComponentAt(selectedIndex));
            }
            tabPane.repaint();
        }

        public void focusGained(FocusEvent e) {
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            SingleRowTabbedPaneUI.this.repaintTab(tabPane.getSelectedIndex());
        }

        public void focusLost(FocusEvent e) {
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            SingleRowTabbedPaneUI.this.repaintTab(tabPane.getSelectedIndex());
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            SingleRowTabbedPaneUI.this.repaintTab(SingleRowTabbedPaneUI.ra$tabPane(SingleRowTabbedPaneUI.this).getTabCount());
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            int index = Integer.parseInt(command);
            SingleRowTabbedPaneUI.ra$tabPane(SingleRowTabbedPaneUI.this).setSelectedIndex(index);
        }

        protected EventHandler() {
        }
    }

    protected static class ScrollMenuSortAction
    extends ScrollMenuAction {
        public ScrollMenuSortAction() {
            super(ControlsArb.getString(11), "scrollMenuSorted");
        }
    }

    protected static class ScrollMenuShowVisibleAction
    extends ScrollMenuAction {
        public ScrollMenuShowVisibleAction() {
            super(ControlsArb.getString(1), "scrollMenuShowVisible");
        }
    }

    protected static class ScrollMenuAction
    extends ToggleAction {
        private String propertyName;

        public ScrollMenuAction(String name, String propertyName) {
            super(name, null);
            this.propertyName = propertyName;
        }

        public void actionPerformed(ActionEvent event) {
            this.setState(this.getState() ^ true);
            if (this.propertyName != null) {
                JMenuItem item = (JMenuItem)event.getSource();
                JPopupMenu scrollMenu = (JPopupMenu)item.getParent();
                JComponent tabPane = (JComponent)scrollMenu.getInvoker();
                boolean newValue = this.getState();
                boolean oldValue = newValue ^ true;
                tabPane.firePropertyChange(this.propertyName, oldValue, newValue);
            }
        }

        public Object getValue(String key) {
            Object o = super.getValue(key);
            if (o == null && key == "SmallIcon") {
                return blankIcon;
            }
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ScrollMenuItemComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            JMenuItem item1 = (JMenuItem)o1;
            JMenuItem item2 = (JMenuItem)o2;
            return item1.getText().compareToIgnoreCase(item2.getText());
        }

        protected ScrollMenuItemComparator() {
        }
    }
}

