/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.UIResource;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.controls.ProgressTracker;
import oracle.ide.controls.ProgressTrackerControl;
import oracle.ide.controls.StatusBar;
import oracle.ide.controls.Toolbar;
import oracle.javatools.border.JavatoolsBorderFactory;
import oracle.javatools.ui.themes.Theme;
import oracle.javatools.ui.themes.Themes;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.PlatformUtils;

public final class StatusBarControl
implements StatusBar {
    private JPanel _gui;
    private JLabel _label;
    private Toolbar _toolbar;
    private JDevStatusBar _statusBar;
    private ProgressTrackerControl _progressTrackerControl;
    private static final String THEME_PART = "statusbar";

    private void $init$() {
        this._statusBar = new JDevStatusBar();
    }

    public StatusBarControl() {
        this.$init$();
        int rightPadding = PlatformUtils.isMac() ? 15 : 0;
        CompoundBorder guiBorder = BorderFactory.createCompoundBorder(JavatoolsBorderFactory.createTopBorder((Color)IdeConstants.COLOR_IDE_LINES), BorderFactory.createEmptyBorder(1, 0, 0, rightPadding));
        this._progressTrackerControl = new ProgressTrackerControl();
        this._label = this._statusBar.add(" ");
        Ide.addIdeListener(new 1());
        this._statusBar.setExpandable(this._label, true);
        this._statusBar.setItemResizeAllowed(false);
        this._gui = new JPanel();
        this._gui.setBorder(guiBorder);
        this._gui.setLayout(new GridBagLayout());
        this._gui.setOpaque(false);
        this._gui.add((Component)((Object)this._statusBar), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void installThemeForeground(Component c) {
        if (Themes.isThemed()) {
            Theme t = Themes.getActiveTheme();
            if (c.getForeground() == null || c.getForeground() instanceof UIResource) {
                c.setForeground(t.getStateProperties(THEME_PART, "normal").getColor("foreground"));
            }
            if (c instanceof Container) {
                int i = 0;
                while (i < ((Container)c).getComponentCount()) {
                    this.installThemeForeground(((Container)c).getComponent(i));
                    ++i;
                }
            }
        }
    }

    public String getText() {
        String s = this._label.getText();
        return s.equals(" ") ? "" : s;
    }

    public void setText(String text) {
        String s = ModelUtil.hasLength((String)text) ? text : " ";
        this._label.setText(s);
    }

    public JComponent getGUI() {
        return this._gui;
    }

    public Toolbar getToolbar() {
        if (this._toolbar == null) {
            this._toolbar = new 2();
            this._toolbar.setBorder(null);
            this._toolbar.setOpaque(false);
            this.installThemeForeground(this._toolbar);
            this._gui.add((Component)this._toolbar, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 2, 0, 0), 0, 0));
        }
        return this._toolbar;
    }

    public ProgressTracker getProgressTracker() {
        return this._progressTrackerControl;
    }

    public void add(JComponent comp) {
        this.installThemeForeground(comp);
        this._statusBar.add(comp);
    }

    public void remove(JComponent comp) {
        this._statusBar.remove(comp);
    }

    public boolean isExpandable(JComponent comp) {
        return this._statusBar.isExpandable(comp);
    }

    public void setExpandable(JComponent comp, boolean expandable) {
        this._statusBar.setExpandable(comp, expandable);
    }

    public int getStatusCount() {
        return this._statusBar.getComponentCount() - 1;
    }

    public void resetStatus() {
        Component[] children = this._statusBar.getComponents();
        int i = 0;
        while (i < children.length) {
            if (children[i] != this._label) {
                this._statusBar.remove(children[i]);
            }
            ++i;
        }
    }

    public boolean containsStatusItem(JComponent status) {
        Component[] children = this._statusBar.getComponents();
        int i = 0;
        while (i < children.length) {
            if (status == children[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void dispose() {
        if (this._toolbar != null) {
            this._toolbar.dispose();
        }
    }

    static void mav$installThemeForeground(StatusBarControl statusBarControl, Component component) {
        statusBarControl.installThemeForeground(component);
    }

    static JLabel ra$_label(StatusBarControl statusBarControl) {
        return statusBarControl._label;
    }

    static JPanel ra$_gui(StatusBarControl statusBarControl) {
        return statusBarControl._gui;
    }

    static JDevStatusBar ra$_statusBar(StatusBarControl statusBarControl) {
        return statusBarControl._statusBar;
    }

    static Toolbar ra$_toolbar(StatusBarControl statusBarControl) {
        return statusBarControl._toolbar;
    }

    final class 1
    implements IdeListener {
        public void addinsLoaded(IdeEvent e) {
        }

        public void mainWindowOpened(IdeEvent e) {
            Ide.removeIdeListener(this);
            StatusBarControl.mav$installThemeForeground(StatusBarControl.this, StatusBarControl.ra$_label(StatusBarControl.this));
            if (Themes.isThemed()) {
                StatusBarControl.ra$_gui(StatusBarControl.this).setBorder(Themes.getActiveTheme().getStateProperties(StatusBarControl.THEME_PART, "normal").getBorder("border"));
                UIManager.put(StatusBarControl.ra$_statusBar(StatusBarControl.this).getUIClassID(), "oracle.ide.controls.ThemedStatusBarUI");
                StatusBarControl.ra$_statusBar(StatusBarControl.this).updateUI();
                int i = 0;
                while (i < StatusBarControl.ra$_toolbar(StatusBarControl.this).getComponentCount()) {
                    Component c = StatusBarControl.ra$_toolbar(StatusBarControl.this).getComponent(i);
                    StatusBarControl.mav$installThemeForeground(StatusBarControl.this, c);
                    ++i;
                }
            }
        }

        public void mainWindowClosing(IdeEvent e) {
        }
    }

    final class 2
    extends Toolbar {
        public Component addComponent(Component component, int index) {
            StatusBarControl.mav$installThemeForeground(StatusBarControl.this, component);
            return super.addComponent(component, index);
        }
    }

    private static final class JDevStatusBar
    extends oracle.bali.ewt.statusBar.StatusBar {
        public JDevStatusBar() {
            super(1);
            this.setBorder(null);
            this.setOpaque(false);
        }

        public String getUIClassID() {
            return "oracle.ide.controls.StatusBarControlUI";
        }
    }
}

