/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.controls.JTabbedPane2;
import oracle.ide.controls.TabbedWindowEvent;
import oracle.ide.controls.TabbedWindowListener;

public class TabbedWindow
extends JPanel {
    private JTabbedPane2 _tabbedPane;
    private List _pages;

    private void $init$() {
        this._pages = new ArrayList();
    }

    public TabbedWindow() {
        this.$init$();
        this.setLayout(new BorderLayout());
    }

    public void add(String name, Icon icon, Component gui, String tooltip, Object data) {
        int items = this._pages.size();
        switch (items) {
            case 0: {
                this.add(gui, "Center");
                break;
            }
            case 1: {
                this.installTabbedPane();
                PageInfo info = (PageInfo)this._pages.get(0);
                this._tabbedPane.addTab(info._name, info._icon, info._gui, info._tooltip);
                this._tabbedPane.addTab(name, icon, gui, tooltip);
                this._tabbedPane.revalidate();
                break;
            }
            default: {
                this._tabbedPane.addTab(name, icon, gui, tooltip);
                this._tabbedPane.revalidate();
            }
        }
        this._pages.add(new PageInfo(name, icon, gui, tooltip, data));
        this.setActive(gui);
    }

    public void removeComponent(Component component) {
        int items = this._pages.size();
        switch (items) {
            case 0: {
                break;
            }
            case 1: {
                PageInfo page = (PageInfo)this._pages.get(0);
                if (component != page._gui) break;
                this.remove(page._gui);
                this._pages.remove(0);
                break;
            }
            case 2: {
                int index = this._tabbedPane.indexOfComponent(component);
                if (index < 0) break;
                this._pages.remove(index);
                this.uninstallTabbedPane();
                this.add(((PageInfo)this._pages.get((int)0))._gui, "Center");
                break;
            }
            default: {
                this.removeTab(component);
            }
        }
    }

    public void setActive(Component component) {
        if (this._tabbedPane == null || this._tabbedPane.getTabCount() == 0) {
            return;
        }
        int index = this._tabbedPane.indexOfComponent(component);
        if (index >= 0) {
            this._tabbedPane.setSelectedIndex(index);
        }
    }

    public Object getActiveData() {
        int index = 0;
        if (this._tabbedPane != null && this._tabbedPane.getTabCount() > 0 && (index = this._tabbedPane.getSelectedIndex()) < 0) {
            index = 0;
        }
        if (this._pages.size() > 0) {
            PageInfo info = (PageInfo)this._pages.get(index);
            return info._data;
        }
        return null;
    }

    public int getCount() {
        return this._pages.size();
    }

    public PageInfo[] getPages() {
        PageInfo[] pages = new PageInfo[this.getCount()];
        return this._pages.toArray(pages);
    }

    public void addTabbedWindowListener(TabbedWindowListener l) {
        this.listenerList.add(TabbedWindowListener.class, l);
    }

    public void removeTabbedWindowListener(TabbedWindowListener l) {
        this.listenerList.remove(TabbedWindowListener.class, l);
    }

    public void addMouseListener(MouseListener listener) {
        this.getTabbedPane().addMouseListener(listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.getTabbedPane().removeMouseListener(listener);
    }

    private void fireTabbedWindowListener(Object data) {
        Object[] listeners = this.listenerList.getListenerList();
        TabbedWindowEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == TabbedWindowListener.class) {
                if (e == null) {
                    e = new TabbedWindowEvent(this, data);
                }
                ((TabbedWindowListener)listeners[i + 1]).activeChanged(e);
            }
            i -= 2;
        }
    }

    private JTabbedPane getTabbedPane() {
        if (this._tabbedPane == null) {
            this._tabbedPane = new JTabbedPane2(3);
            this._tabbedPane.setBorder(BorderFactory.createEmptyBorder());
            this._tabbedPane.setTabPlacement(1);
            this._tabbedPane.addChangeListener(new 1());
        }
        return this._tabbedPane;
    }

    private void uninstallTabbedPane() {
        this._tabbedPane.removeAll();
        this.remove(this._tabbedPane);
    }

    private void installTabbedPane() {
        this.add((Component)this.getTabbedPane(), "Center");
    }

    private void removeTab(Component component) {
        int index = this._tabbedPane.indexOfComponent(component);
        if (index >= 0) {
            this._tabbedPane.removeTabAt(index);
            this._pages.remove(index);
        }
        if (this._pages.size() == 1) {
            this.uninstallTabbedPane();
        }
    }

    static void mav$fireTabbedWindowListener(TabbedWindow tabbedWindow, Object object) {
        tabbedWindow.fireTabbedWindowListener(object);
    }

    final class 1
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            Object data = TabbedWindow.this.getActiveData();
            if (data != null) {
                TabbedWindow.mav$fireTabbedWindowListener(TabbedWindow.this, TabbedWindow.this.getActiveData());
            }
        }
    }

    public static final class PageInfo {
        public final Component _gui;
        public final String _name;
        public final Icon _icon;
        public final String _tooltip;
        public final Object _data;

        public PageInfo(String name, Icon icon, Component gui, String tooltip, Object data) {
            this._gui = gui;
            this._name = name;
            this._icon = icon;
            this._tooltip = tooltip;
            this._data = data;
        }
    }
}

