/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import oracle.ide.controls.MenuItem;
import oracle.ide.controls.ToggleAction;
import oracle.javatools.controls.PropertyChangeAdapter;

public class ToggleMenuItem
extends JCheckBoxMenuItem {
    private boolean checkedForIcon;
    private boolean checkedForDisabledIcon;

    public ToggleMenuItem(ToggleAction action) {
        super(action);
        this.setSelected(action.getState());
        action.listenForItemEvent(this);
    }

    protected void configurePropertiesFromAction(Action a) {
        Integer i;
        this.checkedForIcon = false;
        this.checkedForDisabledIcon = false;
        this.setText(a != null ? (String)a.getValue("Name") : null);
        this.setEnabled(a != null ? a.isEnabled() : true);
        if (a != null && (i = (Integer)a.getValue("MnemonicKey")) != null) {
            this.setMnemonic(i);
        }
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        return new InnerPropertyChangeAdaptor(this, a);
    }

    public Icon getIcon() {
        Action a;
        if (!this.checkedForIcon && (a = this.getAction()) != null) {
            this.checkedForIcon = true;
            this.setIcon((Icon)a.getValue("SmallIcon"));
        }
        return super.getIcon();
    }

    public void setIcon(Icon icon) {
        this.checkedForIcon = true;
        super.setIcon(icon);
    }

    public void setPressedIcon(Icon icon) {
        if (!this.checkedForIcon) {
            this.getIcon();
        }
        super.setPressedIcon(icon);
    }

    public Icon getDisabledIcon() {
        Action a;
        if (!this.checkedForIcon) {
            this.getIcon();
        }
        if (!this.checkedForDisabledIcon && (a = this.getAction()) != null) {
            this.checkedForDisabledIcon = true;
            this.setDisabledIcon((Icon)a.getValue("DisabledIcon"));
        }
        return super.getDisabledIcon();
    }

    public void setDisabledIcon(Icon icon) {
        this.checkedForDisabledIcon = true;
        super.setDisabledIcon(icon);
    }

    public static Icon getCheckBoxMenuItemIcon() {
        return UIManager.getIcon("CheckBoxMenuItem.checkIcon");
    }

    public MenuElement[] getSubElements() {
        return MenuItem.EMPTY_MENU_ELEMENTS;
    }

    private static class InnerPropertyChangeAdaptor
    extends PropertyChangeAdapter {
        public InnerPropertyChangeAdaptor(AbstractButton adaptee, Action action) {
            super(adaptee, action);
        }

        protected void stateChanged(PropertyChangeEvent e) {
            ToggleMenuItem adaptee = (ToggleMenuItem)this.getAdaptee();
            Boolean toggledState = (Boolean)e.getNewValue();
            if (adaptee.isSelected() != toggledState.booleanValue()) {
                adaptee.setState(toggledState);
            }
        }
    }
}

