/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.ewt.util.MenuUtils;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.util.AddinPolicyUtils;
import oracle.javatools.controls.PropertyChangeAdapter;
import oracle.javatools.icons.OracleIcons;

public class ToolButton
extends JButton {
    protected static final String uiClassID = "ToolButtonUI";
    protected JPopupMenu popup;
    private boolean iconVisible;
    private boolean menuStyle;
    private boolean checkedForIcon;
    private boolean checkedForDisabledIcon;
    private boolean painting;
    private PopupMenuListener popupMenuListener;

    private void $init$() {
        this.iconVisible = true;
    }

    public ToolButton(Action action) {
        super((Action)null);
        this.$init$();
        AddinPolicyUtils.creatingAbstractButtonLeakPolicyCheck((AbstractButton)this);
        this.putClientProperty("hideActionText", Boolean.TRUE);
        this.setHorizontalAlignment(0);
        this.setFocusable(false);
        this.setFocusPainted(false);
        this.setAction(action);
    }

    public static String buildToolTip(Action action) {
        if (action == null) {
            return null;
        }
        String tip = (String)action.getValue("ShortDescription");
        Object tipSuffixObj = action.getValue("last-tooltip-suffix");
        if (tip == null || tip.length() == 0 || tipSuffixObj != null) {
            tip = (String)action.getValue("Name");
        }
        if (tip != null && tip.length() > 0) {
            if (action instanceof IdeAction) {
                int nCmdID = ((IdeAction)action).getCommandId();
                String acceleratorTooltip = KeyUtil.getAcceleratorTooltip(nCmdID);
                if (acceleratorTooltip != null && acceleratorTooltip.length() != 0) {
                    tip = tip + " (" + acceleratorTooltip + ")";
                }
            } else {
                KeyStroke k = (KeyStroke)action.getValue("Accelerator");
                if (k != null) {
                    StringBuffer keyText = new StringBuffer(20);
                    keyText.append(" (");
                    String keyMods = KeyEvent.getKeyModifiersText(k.getModifiers());
                    if (keyMods != null && keyMods.length() > 0) {
                        keyText.append(keyMods);
                        keyText.append("+");
                    }
                    keyText.append(KeyEvent.getKeyText(k.getKeyCode()));
                    keyText.append(")");
                    tip = tip + keyText;
                }
            }
        }
        if (tipSuffixObj != null) {
            tip = tip != null ? tip + tipSuffixObj : tipSuffixObj.toString();
        }
        return tip;
    }

    public JMenuItem addPopupItem(String label) {
        JMenuItem item;
        if (this.popup == null) {
            this.createPopupMenu();
        }
        if ((item = this._findPopupItem(label)) == null) {
            item = this.popup.add(label);
            this.layoutToolbar();
        }
        return item;
    }

    public void removePopupItem(String label) {
        JMenuItem item = this._findPopupItem(label);
        if (item != null) {
            this.popup.remove(item);
            this.layoutToolbar();
        }
    }

    public JMenuItem findPopupItem(String label) {
        return this._findPopupItem(label);
    }

    public final void setLabelVisible(boolean visible) {
        this.putClientProperty("hideActionText", visible);
        this.repaint();
    }

    public final boolean getLabelVisible() {
        return ToolButton.isLabelVisible(this);
    }

    public final void setIconVisible(boolean visible) {
        if (visible == this.iconVisible) {
            return;
        }
        this.iconVisible = visible;
        Icon icon = this.getIcon();
        if (icon != null) {
            this.setIcon(icon);
            this.setPressedIcon(icon);
            this.setSelectedIcon(icon);
        }
    }

    public final boolean getIconVisible() {
        return this.iconVisible;
    }

    public void setMenuStyle(boolean menuStyle) {
        this.menuStyle = menuStyle;
    }

    public boolean isMenuStyle() {
        return this.menuStyle;
    }

    protected void init() {
    }

    protected JPopupMenu createPopupMenu() {
        if (this.popup != null) {
            this.releasePopupMenu();
        }
        this.popup = new JPopupMenu();
        this.popupMenuListener = new ButtonPopupMenuListener(this);
        this.popup.addPopupMenuListener(this.popupMenuListener);
        this.invalidate();
        return this.popup;
    }

    protected void releasePopupMenu() {
        if (this.popup != null && this.popupMenuListener != null) {
            this.popup.removePopupMenuListener(this.popupMenuListener);
        }
        this.popup = null;
        this.invalidate();
    }

    protected static boolean isLabelVisible(AbstractButton button) {
        Boolean hide = (Boolean)button.getClientProperty("hideActionText");
        return hide == null || hide == false;
    }

    Toolbar getToolbar() {
        Container parent = this.getParent();
        return parent instanceof Toolbar ? (Toolbar)parent : null;
    }

    boolean hasPopup() {
        return this.popup != null;
    }

    boolean isPopupVisible() {
        return this.popup != null && this.popup.isVisible();
    }

    void togglePopup() {
        if (this.popup == null) {
            return;
        }
        if (!this.popup.isVisible()) {
            MenuUtils.showPopupMenu((JPopupMenu)this.popup, (Component)this, (int)0, (int)this.getHeight());
        } else {
            this.popup.setVisible(false);
        }
    }

    private JMenuItem _findPopupItem(String label) {
        if (this.popup != null) {
            MenuElement[] elements = this.popup.getSubElements();
            int i = 0;
            while (i < elements.length) {
                JMenuItem item;
                Component c = elements[i].getComponent();
                if (c instanceof JMenuItem && (item = (JMenuItem)c).getText().equals(label)) {
                    return item;
                }
                ++i;
            }
        }
        return null;
    }

    protected final void layoutToolbar() {
        Toolbar toolbar = this.getToolbar();
        if (toolbar != null) {
            toolbar.validate();
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.popup != null) {
            SwingUtilities.updateComponentTreeUI(this.popup);
        }
    }

    protected void configurePropertiesFromAction(Action a) {
        this.checkedForIcon = false;
        this.checkedForDisabledIcon = false;
        this.setText(a != null && ToolButton.isLabelVisible(this) ? (String)a.getValue("Name") : null);
        this.setToolTipText(a != null ? ToolButton.buildToolTip(a) : null);
        this.setEnabled(a != null ? a.isEnabled() : true);
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        return new DefaultActionPropertyChangeListener(this, a);
    }

    public Icon getIcon() {
        if (!this.checkedForIcon) {
            Action a = this.getAction();
            this.checkedForIcon = true;
            Icon icon = null;
            if (a != null && (icon = (Icon)a.getValue("SmallIcon")) == null) {
                icon = OracleIcons.getIcon((String)"warning.png");
            }
            this.setIcon(icon);
        }
        return super.getIcon();
    }

    public void setIcon(Icon icon) {
        this.checkedForIcon = true;
        super.setIcon(icon);
    }

    public void setPressedIcon(Icon icon) {
        if (!this.checkedForIcon) {
            this.getIcon();
        }
        super.setPressedIcon(icon);
    }

    public Icon getDisabledIcon() {
        if (!this.checkedForIcon) {
            this.getIcon();
        }
        if (!this.checkedForDisabledIcon) {
            Action a = this.getAction();
            this.checkedForDisabledIcon = true;
            this.setDisabledIcon((Icon)a.getValue("DisabledIcon"));
        }
        return super.getDisabledIcon();
    }

    public void setDisabledIcon(Icon icon) {
        this.checkedForDisabledIcon = true;
        super.setDisabledIcon(icon);
    }

    public void repaint() {
        if (this.painting) {
            return;
        }
        super.repaint();
    }

    protected void paintComponent(Graphics g) {
        this.painting = true;
        super.paintComponent(g);
        this.painting = false;
    }

    protected static class DefaultActionPropertyChangeListener
    extends PropertyChangeAdapter {
        public DefaultActionPropertyChangeListener(AbstractButton adaptee, Action action) {
            super(adaptee, action);
        }

        protected void nameChanged(PropertyChangeEvent e) {
            AbstractButton button = this.getAdaptee();
            if (ToolButton.isLabelVisible(button)) {
                button.setText((String)e.getNewValue());
            }
            this.tooltipChanged(e);
        }

        protected void tooltipChanged(PropertyChangeEvent e) {
            AbstractButton button = this.getAdaptee();
            button.setToolTipText(ToolButton.buildToolTip(button.getAction()));
        }
    }

    private static final class ButtonPopupMenuListener
    implements PopupMenuListener {
        ToolButton button;

        ButtonPopupMenuListener(ToolButton b) {
            this.button = b;
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.updateForPopup(true);
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.updateForPopup(false);
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        private void updateForPopup(boolean visible) {
            1 runnable = new 1(this, visible);
            SwingUtilities.invokeLater(runnable);
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ boolean v$visible;
            final /* synthetic */ ButtonPopupMenuListener this$0;

            public void run() {
                ButtonModel m = this.this$0.button.getModel();
                if (this.this$0.button.isMenuStyle()) {
                    m.setPressed(this.v$visible);
                }
                m.setRollover(false);
                Toolbar toolbar = this.this$0.button.getToolbar();
                if (toolbar != null) {
                    toolbar.setOver(null);
                }
                this.this$0.button.repaint();
            }

            public 1(ButtonPopupMenuListener buttonPopupMenuListener, boolean bl) {
                this.v$visible = bl;
                this.this$0 = buttonPopupMenuListener;
            }
        }
    }
}

