/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Ide;
import oracle.ide.controls.ActionMenuToolButton;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.RadioToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.ToolbarGroup;
import oracle.ide.controls.ToolbarItem;
import oracle.ide.editor.Editor;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.view.View;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.Themes;

public class Toolbar
extends JToolBar {
    private ToolButton _trackButton;
    private ToolButton _overButton;
    private Action[] _actions;
    private ChangeListener _changeListener;
    private boolean _isPrimaryViewToolbar;
    private Boolean _isPrimaryViewToolbarOverride;

    private void $init$() {
        this._isPrimaryViewToolbar = false;
        this._isPrimaryViewToolbarOverride = null;
    }

    public Toolbar() {
        this.$init$();
        this.setFloatable(false);
        this.setRollover(true);
        if (Themes.isThemed()) {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }
    }

    public void forcePrimaryViewToolbar(boolean primaryViewToolbar) {
        if (this._isPrimaryViewToolbarOverride == null || this._isPrimaryViewToolbarOverride != primaryViewToolbar) {
            this._isPrimaryViewToolbarOverride = primaryViewToolbar;
            this.repaint();
        }
    }

    public void setPrimaryViewToolbar(boolean primaryViewToolbar) {
        if (this._isPrimaryViewToolbar != primaryViewToolbar) {
            this._isPrimaryViewToolbar = primaryViewToolbar;
            this.repaint();
        }
    }

    public final ToolButton add(ToggleAction action) {
        ToolButton btn = new ToolButton(action);
        this.add(btn);
        return btn;
    }

    public final ToggleToolButton addToggleButton(ToggleAction action) {
        ToggleToolButton btn = new ToggleToolButton(action);
        this.add(btn);
        return btn;
    }

    public final RadioToolButton addRadioButton(ToggleAction action, ButtonGroup bgroup) {
        RadioToolButton btn = new RadioToolButton(action);
        this.add(btn);
        bgroup.add(btn);
        return btn;
    }

    public final MenuToolButton addMenuButton(ToggleAction[] actions) {
        MenuToolButton btn = new MenuToolButton(actions);
        this.add(btn);
        return btn;
    }

    public final ActionMenuToolButton addActionMenuButton(Action action) {
        ActionMenuToolButton btn = new ActionMenuToolButton(action);
        this.add(btn);
        return btn;
    }

    public final JToolBar.Separator newSeparator() {
        JToolBar.Separator s = new JToolBar.Separator();
        s.setOrientation(this.getOrientation() == 1 ? 0 : 1);
        s.setMinimumSize(s.getPreferredSize());
        return s;
    }

    public final void addSeparator() {
        this.add(this.newSeparator());
    }

    public final void addFiller() {
        Component filler = this.getOrientation() == 0 ? Box.createHorizontalStrut(6) : Box.createVerticalStrut(6);
        this.add(filler);
    }

    public Component addComponent(Component component, int index) {
        return this.add(component, index);
    }

    public void setLabelVisible(boolean labelVisible) {
        int i = this.getComponentCount();
        while (i-- > 0) {
            Component child = this.getComponent(i);
            if (!(child instanceof ToolButton)) continue;
            ToolButton b = (ToolButton)child;
            b.putClientProperty("hideActionText", labelVisible);
            b.repaint();
        }
        this.validate();
    }

    public boolean isLabelVisible() {
        return false;
    }

    public Action[] getActions() {
        if (this._actions != null) {
            return this._actions;
        }
        int count = this.getComponentCount();
        ArrayList<Action> actions = new ArrayList<Action>(count);
        int i = count;
        while (i-- > 0) {
            Component child = this.getComponent(i);
            if (child instanceof ToolbarGroup) {
                Action[] childActions = ((ToolbarGroup)((Object)child)).getActions();
                int j = 0;
                while (j < childActions.length) {
                    actions.add(childActions[j]);
                    ++j;
                }
                continue;
            }
            if (child instanceof ToolbarItem) {
                actions.add(((ToolbarItem)((Object)child)).getAction());
                continue;
            }
            if (!(child instanceof AbstractButton)) continue;
            actions.add(((AbstractButton)child).getAction());
        }
        this._actions = actions.toArray(new Action[actions.size()]);
        return this._actions;
    }

    public void dispose() {
        Toolbar.disposeImpl(this);
    }

    public void remove(Component comp) {
        this._actions = null;
        super.remove(comp);
    }

    public void remove(int index) {
        this._actions = null;
        super.remove(index);
    }

    public void removeAll() {
        this._actions = null;
        super.removeAll();
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        this._actions = null;
        super.addImpl(comp, constraints, index);
        if (comp instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)comp;
            button.setOpaque(false);
        }
    }

    void setTrack(ToolButton trackButton) {
        if (trackButton == null) {
            if (this._trackButton != null) {
                this._trackButton.repaint();
            }
            if (this._overButton != null && this._trackButton != this._overButton) {
                this._overButton.getModel().setRollover(true);
            }
        }
        this._trackButton = trackButton;
    }

    ToolButton getTrack() {
        return this._trackButton;
    }

    void setOver(ToolButton overButton) {
        this._overButton = overButton;
    }

    ToolButton getOver() {
        return this._overButton;
    }

    private static void disposeImpl(Component component) {
        AbstractButton abstractButton;
        Action action;
        if (component instanceof AbstractButton && (action = (abstractButton = (AbstractButton)component).getAction()) != null) {
            abstractButton.setAction(null);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int i = container.getComponentCount();
            while (i-- > 0) {
                Toolbar.disposeImpl(container.getComponent(i));
            }
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        FocusTraversalPolicy focusTraversalPolicy;
        Component component;
        Container rootAncestor;
        super.processMouseEvent(e);
        if (e.getID() == 501 && (rootAncestor = this.getFocusCycleRootAncestor()) != null && !GraphicsUtils.isAncestorOfFocusedComponent((Component)rootAncestor) && (component = (focusTraversalPolicy = rootAncestor.getFocusTraversalPolicy()).getComponentAfter(rootAncestor, this)) != null) {
            component.requestFocus();
        }
    }

    protected void paintComponent(Graphics g) {
        if (Themes.isThemed() && this.isPrimaryViewToolbar()) {
            String state = this.isActiveViewToolbar() ? "active" : "inactive";
            Painter p = Themes.getActiveTheme().getStateProperties("toolbar", state).getPainter("bg");
            p.paint(g, 0, 0, this.getWidth(), this.getHeight());
        }
        super.paintComponent(g);
    }

    private boolean isPrimaryViewToolbar() {
        if (this._isPrimaryViewToolbarOverride != null) {
            return this._isPrimaryViewToolbarOverride;
        }
        return this._isPrimaryViewToolbar;
    }

    protected boolean isActiveViewToolbar() {
        View view = Ide.getMainWindow().getLastActiveView();
        if (view.getToolbar() == this) {
            return true;
        }
        if (view instanceof Editor) {
            Editor editor = (Editor)view;
            return editor.getScrollableTopMargin() == this;
        }
        return false;
    }

    public void addNotify() {
        super.addNotify();
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        this._changeListener = new 1();
        keyStrokeOptions.addChangeListener(this._changeListener);
    }

    public void removeNotify() {
        super.removeNotify();
        if (this._changeListener != null) {
            KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
            keyStrokeOptions.removeChangeListener(this._changeListener);
            this._changeListener = null;
        }
    }

    final class 1
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            int i = Toolbar.this.getComponentCount();
            while (i-- > 0) {
                Component child = Toolbar.this.getComponent(i);
                if (!(child instanceof AbstractButton)) continue;
                AbstractButton button = (AbstractButton)child;
                button.setToolTipText(ToolButton.buildToolTip(button.getAction()));
            }
        }
    }
}

