/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.elementtree;

import java.util.HashMap;
import java.util.List;
import oracle.ide.controls.elementtree.DefaultFilter;
import oracle.ide.controls.elementtree.Filter;
import oracle.ide.controls.elementtree.Handler;
import oracle.ide.model.Element;
import oracle.ide.util.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementRegistry {
    private HashMap<Class, Handler> _handlerRegistry = new HashMap();
    private MultiMap<Class, Filter> _filterRegistry;
    private int _filterChangeNumber;

    public ElementRegistry() {
        this.register(Element.class, new Handler());
        this._filterRegistry = new MultiMap();
        this.register(Element.class, new DefaultFilter());
    }

    public void register(Class<? extends Element> cls, Handler handler) {
        this._handlerRegistry.put(cls, handler);
    }

    public void register(Class<? extends Element> cls, Filter filter) {
        this._filterRegistry.add(cls, (Object)filter);
        ++this._filterChangeNumber;
    }

    public void unregister(Class<? extends Element> cls, Handler handler) {
        Handler removedValue = this._handlerRegistry.remove(cls);
        if (removedValue != null && removedValue != handler) {
            this._handlerRegistry.put(cls, removedValue);
        }
    }

    public void unregister(Class<? extends Element> cls, Filter filter) {
        if (this._filterRegistry.remove(cls, (Object)filter)) {
            ++this._filterChangeNumber;
        }
    }

    List<Filter> getFilters(Element element) {
        Class<?> cls = element.getClass();
        List<Filter> filter = this.getFiltersForClass(cls);
        return filter;
    }

    Handler getHandler(Element element) {
        Class<?> cls = element.getClass();
        Handler ret = this.getHandlerForClass(cls);
        return ret;
    }

    public int getFilterChangeNumber() {
        return this._filterChangeNumber;
    }

    private List<Filter> getFiltersForClass(Class<? extends Element> cls) {
        Class<? extends Element> superCls = cls;
        while (superCls != null) {
            Class<?>[] interfaces;
            List value = this._filterRegistry.get(cls);
            if (value != null) {
                return value;
            }
            Class<?>[] classArray = interfaces = superCls.getInterfaces();
            int n = 0;
            while (n < classArray.length) {
                List<Filter> ifaceValue;
                Class<?> interfaceClasses = classArray[n];
                if (Element.class.isAssignableFrom(interfaceClasses) && (ifaceValue = this.getFiltersForClass(interfaceClasses)) != null) {
                    return ifaceValue;
                }
                ++n;
            }
            superCls = superCls.getSuperclass();
        }
        return null;
    }

    private Handler getHandlerForClass(Class<? extends Element> cls) {
        Class<? extends Element> superCls = cls;
        while (superCls != null) {
            Class<?>[] interfaces;
            Handler value = this._handlerRegistry.get(cls);
            if (value != null) {
                return value;
            }
            Class<?>[] classArray = interfaces = superCls.getInterfaces();
            int n = 0;
            while (n < classArray.length) {
                Class<?> interfaceClasses = classArray[n];
                Handler ifaceValue = this.getHandlerForClass(interfaceClasses);
                if (ifaceValue != null) {
                    return ifaceValue;
                }
                ++n;
            }
            superCls = superCls.getSuperclass();
        }
        return null;
    }
}

