/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.elementtree;

import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controls.elementtree.ElementRegistry;
import oracle.ide.controls.elementtree.ElementTree;
import oracle.ide.controls.elementtree.ElementTreeNode;
import oracle.ide.controls.elementtree.ElementTreeRootNode;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.model.Element;
import oracle.ide.util.dnd.DragDropManager;
import oracle.ide.util.dnd.DragHelper;
import oracle.ide.view.View;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.TransferUtils;
import oracle.javatools.dnd.DndUtils;

public final class ElementTreeViewAdapter {
    private View _view;
    private Element _rootElement;
    private ElementTree _tree;
    private Listener _listener;
    private JScrollPane _component;
    private DragGestureRecognizer _dgr;

    private void $init$() {
        this._listener = new Listener(null);
        this._dgr = null;
    }

    public ElementTreeViewAdapter(View view, Element rootElement) {
        this.$init$();
        this._view = view;
        this._rootElement = rootElement;
    }

    public ElementTree getElementTree() {
        if (this._tree == null) {
            ElementRegistry filterRegistry = new ElementRegistry();
            ElementTreeRootNode elementTreeNode = new ElementTreeRootNode(filterRegistry, this._rootElement);
            this._tree = new ElementTree(elementTreeNode);
            this._tree.addTreeSelectionListener(this._listener);
            this._tree.addMouseListener(this._listener);
            DragSource dragSource = DragSource.getDefaultDragSource();
            this._dgr = dragSource.createDefaultDragGestureRecognizer(this._tree, 3, this._listener);
        }
        return this._tree;
    }

    public JComponent getComponent() {
        if (this._component == null) {
            ElementTree elementTree = this.getElementTree();
            this._component = new JScrollPane(elementTree);
            this._component.setBorder(BorderFactory.createEmptyBorder());
        }
        return this._component;
    }

    private void whenShowMenu(MouseEvent e) {
        int rowForLocation = this._tree.getRowForLocation(e.getX(), e.getY());
        if (rowForLocation >= 0) {
            boolean isAlreadySelected = false;
            int[] selectionRows = this._tree.getSelectionRows();
            if (selectionRows != null) {
                int i = 0;
                while (!isAlreadySelected && i < selectionRows.length) {
                    int selectionRow = selectionRows[i];
                    if (rowForLocation == selectionRow) {
                        isAlreadySelected = true;
                    }
                    ++i;
                }
            }
            if (!isAlreadySelected) {
                this._tree.setSelectionRow(rowForLocation);
            }
        }
        ContextMenu contextMenu = this._view.getContextMenu();
        Context context = this._view.getContext(e);
        contextMenu.show(context);
    }

    public Element[] getSelectionFromUI() {
        TreePath[] selectionPaths;
        Element[] ret = View.EMPTY_SELECTION;
        if (this._tree != null && (selectionPaths = this._tree.getSelectionPaths()) != null) {
            ret = new Element[selectionPaths.length];
            int i = 0;
            while (i < selectionPaths.length) {
                Element element;
                TreePath selectionPath = selectionPaths[i];
                ElementTreeNode elementTreeNode = (ElementTreeNode)selectionPath.getLastPathComponent();
                ret[i] = element = elementTreeNode.getElement();
                ++i;
            }
        }
        return ret;
    }

    private void updateCursor(DragSourceDragEvent dragSourceDragEvent) {
        Cursor cursor;
        int action = dragSourceDragEvent.getDropAction();
        switch (action) {
            default: {
                cursor = DragSource.DefaultCopyDrop;
                break;
            }
            case 2: {
                cursor = DragSource.DefaultMoveDrop;
                break;
            }
            case 0x40000000: {
                cursor = DragSource.DefaultLinkDrop;
                break;
            }
        }
        DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
        dragSourceContext.setCursor(cursor);
    }

    public void setDragAction(int action) {
        if (this._dgr != null) {
            this._dgr.setSourceActions(action);
        }
    }

    static void mav$updateCursor(ElementTreeViewAdapter elementTreeViewAdapter, DragSourceDragEvent dragSourceDragEvent) {
        elementTreeViewAdapter.updateCursor(dragSourceDragEvent);
    }

    static View ra$_view(ElementTreeViewAdapter elementTreeViewAdapter) {
        return elementTreeViewAdapter._view;
    }

    static void mav$whenShowMenu(ElementTreeViewAdapter elementTreeViewAdapter, MouseEvent mouseEvent) {
        elementTreeViewAdapter.whenShowMenu(mouseEvent);
    }

    private class Listener
    implements TreeSelectionListener,
    MouseListener,
    DragGestureListener,
    DragSourceListener {
        public void valueChanged(TreeSelectionEvent e) {
            ElementTreeViewAdapter.ra$_view(ElementTreeViewAdapter.this).updateSelection();
        }

        public void mouseClicked(MouseEvent e) {
            Context context;
            ContextMenu contextMenu;
            if (e.isPopupTrigger()) {
                ElementTreeViewAdapter.mav$whenShowMenu(ElementTreeViewAdapter.this, e);
            } else if (e.getClickCount() > 1 && (contextMenu = ElementTreeViewAdapter.ra$_view(ElementTreeViewAdapter.this).getContextMenu()) != null && contextMenu.fireDefaultAction(context = ElementTreeViewAdapter.ra$_view(ElementTreeViewAdapter.this).getContext(e))) {
                e.consume();
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                ElementTreeViewAdapter.mav$whenShowMenu(ElementTreeViewAdapter.this, e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                ElementTreeViewAdapter.mav$whenShowMenu(ElementTreeViewAdapter.this, e);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            Context context = ElementTreeViewAdapter.ra$_view(ElementTreeViewAdapter.this).getContext();
            TransferableContext transferableContext = new TransferableContext(context);
            DragSource dragSource = DragSource.getDefaultDragSource();
            Transferable trans = this.getTransferablesForSelection(transferableContext);
            AugmentableTransferable augTrans = TransferUtils.createTransferable((Transferable)trans);
            DndUtils.addTriggerEvent((AugmentableTransferable)augTrans, (InputEvent)dge.getTriggerEvent());
            dragSource.startDrag(dge, DragSource.DefaultMoveNoDrop, (Transferable)augTrans, this);
        }

        private Transferable getTransferablesForSelection(Transferable existingTransferable) {
            Context context = ElementTreeViewAdapter.ra$_view(ElementTreeViewAdapter.this).getContext();
            Element[] selection = context.getSelection();
            if (selection.length == 1) {
                DragDropManager dndMgr = DragDropManager.getInstance();
                ArrayList<Transferable> transferables = new ArrayList<Transferable>();
                Element elem = selection[0];
                Iterator helperIterator = dndMgr.getDragHelpers(elem.getClass());
                while (helperIterator.hasNext()) {
                    DragHelper helper = (DragHelper)helperIterator.next();
                    Transferable t = helper.getTransferable(elem);
                    if (t == null) continue;
                    transferables.add(t);
                }
                transferables.add(existingTransferable);
                return this.augmentTransferable(existingTransferable, transferables);
            }
            return existingTransferable;
        }

        private Transferable augmentTransferable(Transferable trans, ArrayList transferables) {
            AugmentableTransferable augTrans = TransferUtils.createTransferable((Transferable)trans);
            for (Transferable t : transferables) {
                DataFlavor[] flavors = t.getTransferDataFlavors();
                if (flavors.length <= 0) continue;
                int i = 0;
                while (i < flavors.length) {
                    if (!augTrans.isDataFlavorSupported(flavors[i])) {
                        try {
                            Object data = t.getTransferData(flavors[i]);
                            augTrans.augment(flavors[i], data, 1.0f, null);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
            return augTrans;
        }

        public void dragEnter(DragSourceDragEvent dsde) {
            ElementTreeViewAdapter.mav$updateCursor(ElementTreeViewAdapter.this, dsde);
        }

        public void dragOver(DragSourceDragEvent dsde) {
            ElementTreeViewAdapter.mav$updateCursor(ElementTreeViewAdapter.this, dsde);
        }

        public void dropActionChanged(DragSourceDragEvent dsde) {
            ElementTreeViewAdapter.mav$updateCursor(ElementTreeViewAdapter.this, dsde);
        }

        public void dragExit(DragSourceEvent dse) {
            DragSourceContext dragSourceContext = dse.getDragSourceContext();
            dragSourceContext.setCursor(DragSource.DefaultMoveNoDrop);
        }

        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        private Listener() {
        }

        Listener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

