/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.javatools.datatransfer.TransferUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferableContext
extends ArrayList
implements Transferable {
    public static final DataFlavor contextFlavor = new DataFlavor("application/x-java-jvm-local-objectref; class=" + TransferableContext.class.getName(), "IDE Context");
    private static final DataFlavor[] flavors = new DataFlavor[]{contextFlavor, TransferUtils.FLAVOR_SAFE_TO_FETCH_CONTENTS_EARLY_MARKER};
    private Context context;

    public TransferableContext(Context context) {
        if (context == null) {
            return;
        }
        this.context = context;
        Element[] selection = context.getSelection();
        if (selection == null || selection.length < 1) {
            return;
        }
        this.ensureCapacity(selection.length);
        int i = 0;
        while (i < selection.length) {
            this.add(selection[i]);
            ++i;
        }
    }

    public Context getContext() {
        return this.context;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.equals(contextFlavor)) {
            return this;
        }
        if (TransferUtils.FLAVOR_SAFE_TO_FETCH_CONTENTS_EARLY_MARKER.equals(flavor)) {
            return null;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(contextFlavor) || TransferUtils.FLAVOR_SAFE_TO_FETCH_CONTENTS_EARLY_MARKER.equals(flavor);
    }
}

