/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import oracle.ide.Ide;

public class DialogSizeKeeper
implements ComponentListener {
    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public static void attachToComponent(Component co, String propName) {
        String swidth = Ide.getProperty(propName + ".width");
        String sheight = Ide.getProperty(propName + ".height");
        Dimension d = null;
        if (swidth != null && sheight != null) {
            d = new Dimension(Integer.parseInt(swidth), Integer.parseInt(sheight));
        }
        EventAdapter eventAdapter = new EventAdapter(propName, d, null);
        co.addComponentListener(eventAdapter);
        co.addHierarchyListener(eventAdapter);
    }

    private static final class EventAdapter
    implements ComponentListener,
    HierarchyListener {
        private String _sizePropertyName;
        private Dimension _dorg;

        private EventAdapter(String sizePropertyName, Dimension d) {
            this._sizePropertyName = sizePropertyName;
            this._dorg = d;
        }

        public void componentResized(ComponentEvent e) {
            if (this._sizePropertyName != null && this._dorg == null) {
                Dimension d = e.getComponent().getSize();
                Ide.setProperty(this._sizePropertyName + ".width", Integer.toString(d.width));
                Ide.setProperty(this._sizePropertyName + ".height", Integer.toString(d.height));
            }
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
        }

        public void hierarchyChanged(HierarchyEvent event) {
            Component component;
            if ((event.getChangeFlags() & (long)4) != 0L && (component = event.getComponent()).isShowing()) {
                if (this._dorg != null) {
                    component.setSize(this._dorg);
                    this._dorg = null;
                }
                component.removeHierarchyListener(this);
            }
        }

        EventAdapter(String string, Dimension dimension, 1 var3_3) {
            this(string, dimension);
        }

        public final class 1 {
        }
    }
}

