/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs;

import java.awt.Component;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.dialogs.ProgressException;

public abstract class ProgressRunnable
implements Runnable {
    private Exception _ex;
    private ProgressBar _progBar;
    private volatile boolean _canceled;
    private Thread _runnerThread;
    private boolean _canCancel;
    private boolean _useThread;
    private String _title;
    private String _msg;
    private Object _result;

    private void $init$() {
        this._canCancel = true;
        this._useThread = true;
    }

    public ProgressRunnable() {
        this.$init$();
    }

    public final void setTitle(String title) {
        this._title = title;
    }

    public final String getTitle() {
        return this._title;
    }

    public final void setMessage(String msg) {
        this._msg = msg;
    }

    public final String getMessage() {
        return this._msg;
    }

    public final void setCancelable(boolean canCancel) {
        this._canCancel = canCancel;
    }

    public final boolean isCancelable() {
        return this._canCancel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(boolean useThread) throws ProgressException {
        this._useThread = useThread;
        if (useThread) {
            this._progBar = new ProgressBar((Component)((Object)Ide.getMainWindow()), this._title, this, true);
            this._progBar.setCancelable(this._canCancel);
            this._progBar.start(this._msg, null, this.getProgressShowDelay());
            ProgressRunnable progressRunnable = this;
            synchronized (progressRunnable) {
                if (this._progBar.hasUserCancelled()) {
                    this._canceled = true;
                    this.doCancel();
                }
                this._progBar = null;
            }
        } else {
            this.run();
        }
        if (this._ex != null && !this._canceled) {
            throw new ProgressException(this._ex);
        }
        this.finish(this._result);
    }

    protected int getProgressShowDelay() {
        return 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        Object result = null;
        try {
            try {
                ProgressRunnable progressRunnable = this;
                synchronized (progressRunnable) {
                    if (this._progBar != null) {
                        this._progBar.sleepForUIToRepaint();
                        this._runnerThread = Thread.currentThread();
                    }
                }
                result = this.doWork();
            }
            catch (Exception ex) {
                this._ex = ex;
            }
        }
        catch (Throwable throwable) {
            ProgressRunnable progressRunnable = this;
            synchronized (progressRunnable) {
                if (this._useThread) {
                    if (this._progBar != null) {
                        this._runnerThread = null;
                        this._progBar.setDoneStatus();
                        this._result = result;
                    }
                } else {
                    this._result = result;
                }
            }
            throw throwable;
        }
        ProgressRunnable progressRunnable = this;
        synchronized (progressRunnable) {
            if (this._useThread) {
                if (this._progBar != null) {
                    this._runnerThread = null;
                    this._progBar.setDoneStatus();
                    this._result = result;
                }
            } else {
                this._result = result;
            }
        }
    }

    protected abstract Object doWork() throws Exception;

    protected void finish(Object result) {
    }

    protected void doCancel() {
        if (this._runnerThread != null) {
            this._runnerThread.interrupt();
            this._runnerThread = null;
        }
    }

    protected final Thread getRunnerThread() {
        return this._runnerThread;
    }
}

