/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.config.IdeSettings;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.filter.DirectoryExcludeFilter;
import oracle.ide.dialogs.filter.FileFilter;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.util.ModelUtil;
import oracle.javatools.util.Copyable;

public class FileTypeIncludeFilter
extends DirectoryExcludeFilter
implements FileFilter,
Copyable {
    private ArrayList _userAddedExtensions;
    private boolean _includeAllFiles;
    private ArrayList _selectedExtensions;
    private CheckBoxListModel _listModel;
    private ArrayList _allSelectedFilters;

    private void $init$() {
        this._userAddedExtensions = new ArrayList();
        this._includeAllFiles = true;
        this._selectedExtensions = new ArrayList();
        this._listModel = new CheckBoxListModel();
        this._allSelectedFilters = new ArrayList();
    }

    public FileTypeIncludeFilter() {
        this.$init$();
    }

    public void populateListModel() {
        if (this._listModel.getSize() > 0) {
            return;
        }
        IdeSettings ideSettings = Ide.getSettings();
        DocumentExtensions documentExts = (DocumentExtensions)ideSettings.getData("document-extensions-options");
        ArrayList<String> collected = new ArrayList<String>(25);
        Collection docs = documentExts.getDocuments();
        for (DocumentExtensions.DocRecord docRecord : docs) {
            List extList = docRecord.getExtensions();
            int numExts = extList.size();
            int i = 0;
            while (i < numExts) {
                DocumentExtensions.ExtInfo extInfo = (DocumentExtensions.ExtInfo)extList.get(i);
                String extension = extInfo.getExtension();
                if (!collected.contains(extension)) {
                    collected.add(extension);
                    TextPair textPair = new TextPair(extension);
                    this.parseFilterText(textPair);
                    FilterInfo filterInfo = new FilterInfo(textPair.getFilterText(), extInfo.isLocked());
                    this._listModel.addElement((Object)filterInfo, null, true, false, textPair.getDisplayText());
                }
                ++i;
            }
        }
        Iterator iterator = null;
        iterator = this._userAddedExtensions.iterator();
        while (iterator.hasNext()) {
            TextPair textPair = new TextPair((String)iterator.next());
            this.parseFilterText(textPair);
            if (this._listModel.findElementByText(textPair.getDisplayText()) != -1) {
                iterator.remove();
                continue;
            }
            FilterInfo filterInfo = new FilterInfo(textPair.getFilterText(), false);
            this._listModel.addElement((Object)filterInfo, null, true, false, textPair.getDisplayText());
        }
        for (String selExt : this._selectedExtensions) {
            int location = this._listModel.findElementByText(selExt);
            if (location == -1) continue;
            this._listModel.setElementSelected(location);
        }
        this._listModel.sort();
    }

    public ArrayList getUserAddedExtensions() {
        return this._userAddedExtensions;
    }

    public void setUserAddedExtensions(ArrayList list) {
        this._userAddedExtensions = list;
    }

    public CheckBoxListModel getListModel() {
        return this._listModel;
    }

    public void setListModel(CheckBoxListModel listModel) {
        this._listModel = listModel;
    }

    public boolean getIncludeAllFiles() {
        return this._includeAllFiles;
    }

    public void setIncludeAllFiles(boolean includeAllFiles) {
        this._includeAllFiles = includeAllFiles;
    }

    public List getList() {
        if (this._includeAllFiles) {
            return null;
        }
        return this._allSelectedFilters;
    }

    public static boolean equals(FileTypeIncludeFilter f1, FileTypeIncludeFilter f2) {
        if (!DirectoryExcludeFilter.equals(f1, f2)) {
            return false;
        }
        if (f1.getIncludeAllFiles() != f2.getIncludeAllFiles()) {
            return false;
        }
        if (!f1.getUserAddedExtensions().equals(f2.getUserAddedExtensions())) {
            return false;
        }
        if (!f1.getList().equals(f2.getList())) {
            return false;
        }
        return f1.getListModel().equals((Object)f2.getListModel());
    }

    public void clearAllSelectedFilters() {
        this._allSelectedFilters.clear();
    }

    public void setSelectedFilters() {
        List selectedFilterList = this._listModel.getSelectionList();
        if (selectedFilterList != null) {
            for (FilterInfo filterInfo : selectedFilterList) {
                this._allSelectedFilters.add(filterInfo.getURLFilter());
            }
        }
        this._selectedExtensions.clear();
        int len = this._listModel.getSize();
        int i = 0;
        while (i < len) {
            if (this._listModel.isElementSelected(i)) {
                this._selectedExtensions.add(this._listModel.findTextForElement(i));
            }
            ++i;
        }
        List userDefinedList = this.parseUserDefinedFilterString();
        this._allSelectedFilters.addAll(userDefinedList);
    }

    public void removeUserDefinedValueFromList(int index) {
        String text = this._listModel.findTextForElement(index);
        if (text.startsWith("*.") && !WildcardURLFilter.hasWildcard((String)text.substring(2))) {
            text = text.substring(1);
        }
        this._userAddedExtensions.remove(text);
        this._listModel.removeElementByIndex(index);
    }

    public boolean addUserDefinedValueToList(String value) {
        TextPair textPair = new TextPair(value);
        this.parseFilterText(textPair);
        if (this._userAddedExtensions.contains(textPair.getFilterText())) {
            return false;
        }
        this._userAddedExtensions.add(textPair.getFilterText());
        FilterInfo filterInfo = new FilterInfo(textPair.getFilterText(), false);
        this._listModel.addElement((Object)filterInfo, null, true, true, textPair.getDisplayText());
        this._listModel.sort();
        return true;
    }

    public ArrayList getSelectedExtensions() {
        return this._selectedExtensions;
    }

    public void setSelectedExtensions(ArrayList selectedExtensions) {
        this._selectedExtensions = selectedExtensions;
        int len = this._selectedExtensions.size();
        int i = 0;
        while (i < len) {
            TextPair textPair = new TextPair((String)this._selectedExtensions.get(i));
            this.parseFilterText(textPair);
            FilterInfo filterInfo = new FilterInfo(textPair.getFilterText(), false);
            this._allSelectedFilters.add(filterInfo.getURLFilter());
            ++i;
        }
    }

    private void parseFilterText(TextPair textPair) {
        if (textPair.getFilterText().startsWith("*.") && !WildcardURLFilter.hasWildcard((String)textPair.getFilterText().substring(2))) {
            textPair.setDisplayText(textPair.getFilterText());
            textPair.setFilterText(textPair.getFilterText().substring(1));
        } else if (textPair.getFilterText().startsWith(".") && !WildcardURLFilter.hasWildcard((String)textPair.getFilterText())) {
            textPair.setDisplayText("*" + textPair.getFilterText());
        } else {
            textPair.setDisplayText(textPair.getFilterText());
        }
    }

    public boolean isListElementLocked(int row) {
        FilterInfo filterInfo = (FilterInfo)this._listModel.getUserObjectAt(row);
        return filterInfo.isSystemDefined();
    }

    public Object copyTo(Object target) {
        FileTypeIncludeFilter copy = target != null ? (FileTypeIncludeFilter)target : new FileTypeIncludeFilter();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(FileTypeIncludeFilter copy) {
        copy.setIncludeAllFiles(this.getIncludeAllFiles());
        copy.setRecurseDirectories(this.getRecurseDirectories());
        copy.setApplyToDirectory(this.getApplyToDirectory());
        copy.setUserDefinedExclusions(this.getUserDefinedExclusions());
        ModelUtil.deepCopy((List)this._userAddedExtensions, (List)copy._userAddedExtensions);
        ModelUtil.deepCopy((List)this._allSelectedFilters, (List)copy._allSelectedFilters);
        ModelUtil.deepCopy((List)this._selectedExtensions, (List)copy._selectedExtensions);
        if (this._listModel != null) {
            this._listModel.copyTo((Object)copy._listModel);
        }
    }

    public static class FilterInfo {
        private URLFilter _urlFilter;
        private boolean _systemDefined;

        public FilterInfo(String filterText, boolean systemDefined) {
            this._urlFilter = DirectoryExcludeFilter.createURLFilter(filterText, 0);
            this._systemDefined = systemDefined;
        }

        public URLFilter getURLFilter() {
            return this._urlFilter;
        }

        public boolean isSystemDefined() {
            return this._systemDefined;
        }
    }

    private static class TextPair {
        String _filterText;
        String _displayText;

        public TextPair(String filterText) {
            this._filterText = filterText;
        }

        public String getFilterText() {
            return this._filterText;
        }

        public void setFilterText(String filterText) {
            this._filterText = filterText;
        }

        public String getDisplayText() {
            return this._displayText;
        }

        public void setDisplayText(String displayText) {
            this._displayText = displayText;
        }
    }
}

