/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.docking;

import java.awt.Container;
import javax.naming.Context;
import javax.swing.JComponent;
import javax.swing.JFrame;
import oracle.ide.Addin;
import oracle.ide.controller.Controller;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableDragContext;
import oracle.ide.docking.DockableDragSource;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableListener;
import oracle.ide.docking.DockingParam;
import oracle.ide.docking.DrawerDockableWindow;
import oracle.ide.docking.DrawerModel;
import oracle.ide.layout.ViewId;
import oracle.ide.util.PropertyAccess;
import oracle.javatools.jndi.Names;

public abstract class DockStation
implements Controller,
Addin {
    public static final int STATUS_PRESENT = 1;
    public static final int STATUS_PINNED = 2;
    public static final int STATUS_MINIMIZED = 4;
    public static final int STATUS_ACCESSIBLE = 8;
    public static final int STATUS_ACTIVE = 16;
    public static final int STATUS_VISIBLE = 32;
    private static final String DOCK_STATION_NAME = "ide/dock-station";

    public static DockStation getDockStation() {
        return (DockStation)Names.lookup((Context)Names.newInitialContext(), (String)DOCK_STATION_NAME);
    }

    public static void setDockStation(DockStation dockStation) {
        Names.bind((Context)Names.newInitialContext(), (String)DOCK_STATION_NAME, (Object)dockStation);
    }

    public abstract void registerDockableFactory(String var1, DockableFactory var2);

    public abstract void registerDockableFactory(String var1, DockableFactory var2, double var3);

    public abstract void unregisterDockableFactory(String var1);

    public abstract DockableFactory lookupFactory(ViewId var1);

    public abstract void addDockableListener(DockableListener var1, Dockable var2);

    public abstract void removeDockableListener(DockableListener var1, Dockable var2);

    public abstract void initialize();

    public abstract void install(JFrame var1, Container var2, JComponent var3);

    public abstract boolean isDockableVisible(String var1);

    public abstract boolean isDockableVisible(Dockable var1);

    public abstract int getDockableStatus(Dockable var1);

    public abstract void dock(Dockable var1, DockingParam var2);

    public abstract void undock(Dockable var1);

    protected abstract void undock(Dockable var1, int var2);

    public abstract void setDockableVisible(String var1, boolean var2);

    public abstract void setDockableVisible(Dockable var1, boolean var2);

    public abstract void close(Dockable var1);

    public abstract void saveLayout(PropertyAccess var1);

    public abstract boolean activateDockable(Dockable var1);

    public abstract boolean activateAnyDockable();

    public abstract Dockable getDockable(ViewId var1);

    public abstract Dockable findDockable(ViewId var1);

    public abstract DockableDragContext createDockableDragContext(DockableDragSource var1);

    protected abstract void addToCache(Dockable var1);

    protected abstract void removeFromCache(Dockable var1);

    protected abstract void removeFromCache(String var1);

    protected abstract DrawerModel createDrawerModel(DrawerDockableWindow var1);

    public abstract void fireDockableEvent(DockableEvent var1);
}

