/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.docking;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Animator;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableDragContext;
import oracle.ide.docking.DockableDragSource;
import oracle.ide.docking.DockableDropTarget;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.Drawer;
import oracle.ide.docking.DrawerConfig;
import oracle.ide.docking.DrawerUI;
import oracle.ide.docking.DrawerWindow;
import oracle.ide.docking.DrawerWindowLayout;
import oracle.ide.docking.DrawerWindowModel;
import oracle.ide.docking.DrawerWindowTray;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.BitField;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ide.view.View;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DrawerWindowUI
extends JPanel
implements DockableDropTarget {
    private static final int COLLAPSE_SMALL_DRAWERS_THRESHOLD = 20;
    private static boolean actionsCreated;
    private final List<Drawer> hidden;
    private static final int PREVIOUS_SIZE_NOT_SET = -1;
    private final DockableDragSource dragSource;
    private final DrawerWindow drawerWindow;
    private final BottomComponent bottomComponent;
    private List<Double> drawerRatios;
    private int dropFeedbackPos;
    private Point relativeStartPoint;
    private DockableDragContext dockableDragContext;
    private DrawerUI activeDrawer;
    private int previousHeight;
    private int previousWidth;
    private final DrawerWindowLayout layout;
    private DrawerWindowTray tray;
    private boolean expandOneDrawerAtATime;
    private boolean hideHandleIfOnlyOneDrawerShown;
    private boolean expandDrawerOnActivation;

    private void $init$() {
        this.hidden = new ArrayList<Drawer>();
        this.dragSource = new DockableDragSourceImpl(null);
        this.dropFeedbackPos = -1;
        this.previousHeight = -1;
        this.previousWidth = -1;
        this.layout = new DrawerWindowLayout(this);
    }

    private static void createActions() {
        if (actionsCreated) {
            return;
        }
        if (Themes.isThemed()) {
            DrawerWindowUI.createAction(DrawerWindow.DROP_DOWN_ACTION_ID, "Menu");
        } else {
            DrawerWindowUI.createAction(DrawerWindow.DROP_DOWN_ACTION_ID, "Menu", IdeIcons.getInstance(), 28);
        }
        DrawerWindowUI.createAction(DrawerWindow.MINIMIZE_ACTION_ID, "Minimize");
        DrawerWindowUI.createAction(DrawerWindow.CLOSE_ACTION_ID, "Close");
        actionsCreated = true;
    }

    public static IdeAction createAction(int cmdId, String name, ArrayResourceBundle bundle, int key) {
        return IdeAction.get(cmdId, null, name, null, null, bundle, key, null, true);
    }

    private static IdeAction createAction(int cmdId, String name) {
        return IdeAction.get(cmdId, null, name, null, null, null, null, true);
    }

    Component bottomComponent() {
        return this.bottomComponent;
    }

    int dropFeedbackPos() {
        return this.dropFeedbackPos;
    }

    public DrawerWindowUI(DrawerWindow drawerWindow) {
        this.$init$();
        DrawerWindowUI.createActions();
        this.drawerWindow = drawerWindow;
        this.bottomComponent = new BottomComponent();
        this.setUpAndAddBottomComponent();
        this.setUpMaps();
        this.setOpaque(false);
        this.registerListener();
        this.addComponentListener(new 1());
        this.addFocusListener(new 2());
        this.addPropertyChangeListener(new 3());
    }

    private void updatePreviousHeight(int previousHeight) {
        this.previousHeight = previousHeight;
    }

    private void updatePreviousWidth(int previousWidth) {
        this.previousWidth = previousWidth;
    }

    private void setUpAndAddBottomComponent() {
        this.bottomComponent.addActionListener(new 4());
        this.add(this.bottomComponent);
    }

    void expandOneDrawerAtATime() {
        this.expandOneDrawerAtATime = true;
    }

    void hideHandleIfOnlyOneDrawerShown() {
        this.hideHandleIfOnlyOneDrawerShown = true;
    }

    void expandDrawerOnActivation() {
        this.expandDrawerOnActivation = true;
    }

    void updateDrawerHandlesVisibility() {
        if (!this.hideHandleIfOnlyOneDrawerShown) {
            return;
        }
        List<DrawerUI> visibleDrawers = this.visibleDrawers();
        if (visibleDrawers.isEmpty()) {
            return;
        }
        if (visibleDrawers.size() == 1) {
            DrawerUI onlyDrawer = visibleDrawers.get(0);
            onlyDrawer.hideHandle();
            onlyDrawer.expanded(true);
            return;
        }
        for (DrawerUI drawer : visibleDrawers) {
            drawer.showHandle();
        }
    }

    private void trayClicked() {
        this.tray = new DrawerWindowTray(this);
        for (Drawer drawer : this.model().drawers()) {
            if (!drawer.minimizedButVisible()) continue;
            this.tray.addEntry(drawer);
        }
        if (!this.tray.isEmpty()) {
            this.tray.expand();
        }
    }

    private void setUpMaps() {
        5 previousPanelAction = new 5();
        6 nextPanelAction = new 6();
        7 closePanelAction = new 7();
        8 openPanelAction = new 8();
        this.setUpInputMap(previousPanelAction, nextPanelAction, openPanelAction, closePanelAction);
        this.setUpActionMap(previousPanelAction, nextPanelAction, openPanelAction, closePanelAction);
    }

    private void setUpInputMap(AbstractAction previousPanelAction, AbstractAction nextPanelAction, AbstractAction openPanelAction, AbstractAction closePanelAction) {
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(117, 1), previousPanelAction);
        inputMap.put(KeyStroke.getKeyStroke(117, 0), nextPanelAction);
        inputMap.put(KeyStroke.getKeyStroke(38, 1), previousPanelAction);
        inputMap.put(KeyStroke.getKeyStroke(40, 1), nextPanelAction);
        inputMap.put(KeyStroke.getKeyStroke(39, 1), openPanelAction);
        inputMap.put(KeyStroke.getKeyStroke(37, 1), closePanelAction);
    }

    private void setUpActionMap(AbstractAction previousPanelAction, AbstractAction nextPanelAction, AbstractAction openPanelAction, AbstractAction closePanelAction) {
        ActionMap actionMap = this.getActionMap();
        actionMap.put(previousPanelAction, previousPanelAction);
        actionMap.put(nextPanelAction, nextPanelAction);
        actionMap.put(openPanelAction, openPanelAction);
        actionMap.put(closePanelAction, closePanelAction);
    }

    private void registerListener() {
        DrawerWindowModel model = this.model();
        Listener listener = new Listener(null);
        model.addListener(listener);
        if (model.hasDrawers()) {
            listener.intervalAdded(new ListDataEvent(model, 1, 0, model.drawerCount() - 1));
        }
    }

    private void addDrawer(Drawer drawer) {
        DrawerUI drawerUI = drawer.drawerUI();
        DockableWindow view = drawer.view();
        drawerUI.updateDropDownButton(this.createDropDown(drawer, view));
        Ide.getMainWindow().registerView(view);
        if (!drawer.visible()) {
            return;
        }
        this.addDrawer(drawerUI);
        DockStation.getDockStation().addToCache(view);
    }

    private MenuToolButton createDropDown(Drawer drawer, View view) {
        MenuToolButton dropDown = new MenuToolButton(IdeAction.newLocalAction(DrawerWindow.DROP_DOWN_ACTION_ID, view));
        if (Themes.isThemed()) {
            dropDown.setPaintPopUpIndicator(false);
        }
        dropDown.addPopupItem(IdeAction.newLocalAction(DrawerWindow.MINIMIZE_ACTION_ID, view));
        if (drawer.canBeClosed()) {
            dropDown.addPopupItem(IdeAction.newLocalAction(DrawerWindow.CLOSE_ACTION_ID, view));
        }
        dropDown.setBorder(BorderFactory.createEmptyBorder());
        dropDown.setContentAreaFilled(false);
        dropDown.setOpaque(false);
        dropDown.setBorderPainted(false);
        return dropDown;
    }

    void addDrawer(DrawerUI drawerUI) {
        this.add(drawerUI);
        this.visibleDrawerCountChanged();
        List<DrawerUI> drawers = this.visibleDrawers();
        if (drawers.size() != 1) {
            return;
        }
        drawerUI.expanded(true);
    }

    private void removeDrawer(Drawer drawer) {
        DockStation.getDockStation().removeFromCache(drawer.uniqueName());
        Ide.getMainWindow().unregisterView(drawer.view());
        DrawerUI drawerUI = drawer.drawerUI();
        if (drawerUI != null) {
            this.removeDrawer(drawerUI);
        }
    }

    void removeDrawer(DrawerUI drawerUI) {
        this.remove(drawerUI);
        this.visibleDrawerCountChanged();
    }

    private void visibleDrawerCountChanged() {
        List<DrawerUI> drawers = this.visibleDrawers();
        boolean minimizable = drawers.size() > 1;
        for (DrawerUI drawer : drawers) {
            drawer.minimizable(minimizable);
        }
    }

    private void previousPanel() {
        this.previousOrNextPanel(-1);
    }

    private void nextPanel() {
        this.previousOrNextPanel(1);
    }

    private void previousOrNextPanel(int direction) {
        DrawerUI focusedDrawer = this.focusedDrawer();
        if (focusedDrawer == null) {
            return;
        }
        List<DrawerUI> drawers = this.visibleDrawers();
        int focusedDrawerIndex = drawers.indexOf(focusedDrawer);
        focusedDrawer.deactivate();
        int activateDrawerIndex = (focusedDrawerIndex + direction + drawers.size()) % drawers.size();
        DrawerUI activateDrawer = drawers.get(activateDrawerIndex);
        List<DrawerUI> expandedDrawers = this.expandedDrawers();
        expandedDrawers.remove(activateDrawer);
        this.toggleWithAnimation(this.drawerList(activateDrawer), expandedDrawers);
        activateDrawer.hostedComponent().requestFocus();
        this.ensureHighlightConsistency(activateDrawer);
    }

    private void ensureHighlightConsistency(DrawerUI selected) {
        for (DrawerUI d : this.visibleDrawers()) {
            if (selected == d) {
                d.activate();
                continue;
            }
            d.deactivate();
        }
    }

    private void closePanel() {
        DrawerUI focusedDrawer = this.focusedDrawer();
        if (focusedDrawer == null) {
            return;
        }
        List<DrawerUI> expandedDrawers = this.expandedDrawers();
        expandedDrawers.remove(focusedDrawer);
        this.toggleWithAnimation(expandedDrawers, this.drawerList(focusedDrawer));
        focusedDrawer.hostedComponent().requestFocus();
    }

    private void openPanel() {
        DrawerUI focusedDrawer = this.focusedDrawer();
        if (focusedDrawer == null) {
            return;
        }
        List<DrawerUI> collapsedDrawers = this.visibleDrawers();
        List<DrawerUI> expandedDrawers = this.expandedDrawers();
        expandedDrawers.add(focusedDrawer);
        collapsedDrawers.removeAll(expandedDrawers);
        this.toggleWithAnimation(expandedDrawers, collapsedDrawers);
        focusedDrawer.focusableFromHosted().requestFocus();
    }

    private DrawerUI focusedDrawer() {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        for (DrawerUI drawer : this.visibleDrawers()) {
            if (!SwingUtilities.isDescendingFrom(focusOwner, drawer)) continue;
            return drawer;
        }
        return null;
    }

    List<DrawerUI> visibleDrawers() {
        ArrayList<DrawerUI> drawers = new ArrayList<DrawerUI>();
        for (Drawer drawer : this.model().drawers()) {
            if (!drawer.visible()) continue;
            drawers.add(drawer.drawerUI());
        }
        return drawers;
    }

    private int minimizedButVisibleDrawerCount() {
        int count = 0;
        for (Drawer drawer : this.model().drawers()) {
            if (!drawer.minimizedButVisible()) continue;
            ++count;
        }
        return count;
    }

    List<DrawerUI> expandedDrawers() {
        ArrayList<DrawerUI> drawers = new ArrayList<DrawerUI>();
        for (DrawerUI drawer : this.visibleDrawers()) {
            if (!drawer.expanded()) continue;
            drawers.add(drawer);
        }
        return drawers;
    }

    private DrawerWindowModel model() {
        return this.drawerWindow.model();
    }

    void expand(DrawerUI drawer) {
        this.expand(this.drawerList(drawer));
    }

    void expand(List<DrawerUI> drawers) {
        this.toggleWithAnimation(drawers, null);
    }

    void toggleWithAnimation(List<DrawerUI> toExpand, List<DrawerUI> toCollapse) {
        this.toggle(toExpand, toCollapse, true);
    }

    void toggleWithoutAnimation(List<DrawerUI> toExpand, List<DrawerUI> toCollapse) {
        this.toggle(toExpand, toCollapse, false);
    }

    private void toggle(List<DrawerUI> toExpand, List<DrawerUI> toCollapse, boolean animate) {
        if (animate && !Themes.isThemed()) {
            this.animateToggle(toExpand, toCollapse);
        } else {
            this.setExpansionRatio(toExpand, 1.0);
            this.setExpansionRatio(toCollapse, 0.0);
            this.invalidateAndValidate();
        }
    }

    private void animateToggle(List<DrawerUI> toExpand, List<DrawerUI> toCollapse) {
        if (!this.isShowing()) {
            return;
        }
        Animator.animate(30, 400L, 10, 0.6, 0.14, this.toggleAnimationListener(toExpand, toCollapse));
    }

    private PropertyChangeListener toggleAnimationListener(List<DrawerUI> toExpand, List<DrawerUI> toCollapse) {
        List<DrawerUI> e = toExpand;
        List<DrawerUI> c = toCollapse;
        return new 9(this, e, c);
    }

    private void setExpansionRatio(List<DrawerUI> drawers, double expansionRatio) {
        if (drawers == null) {
            return;
        }
        for (DrawerUI drawer : drawers) {
            drawer.expansionRatio(expansionRatio);
        }
    }

    void toggleVisibility(DrawerUI drawer) {
        if (this.expandOneDrawerAtATime) {
            this.toggleVisibilityClosingOneAtATime(drawer);
            return;
        }
        this.toggleVisibilityTreeViewLike(drawer);
    }

    private void toggleVisibilityWhenMultipleOpen(DrawerUI drawer) {
        if (drawer.expanded()) {
            this.toggle(null, this.drawerList(drawer), true);
            return;
        }
        this.toggleWithAnimation(this.drawerList(drawer), null);
    }

    void activate(DrawerUI drawer) {
        this.deactivateActiveDrawer();
        drawer.activate();
        this.activeDrawer = drawer;
    }

    void expandIfNecessary(DrawerUI drawer) {
        if (drawer.expanded() || !this.expandDrawerOnActivation) {
            return;
        }
        this.toggleVisibility(drawer);
    }

    void deactivateActiveDrawer() {
        if (this.activeDrawer != null) {
            this.deactivate(this.activeDrawer);
        }
        this.activeDrawer = null;
    }

    void deactivate(DrawerUI drawer) {
        drawer.deactivate();
    }

    private void toggleVisibilityTreeViewLike(DrawerUI drawer) {
        ArrayList<DrawerUI> toExpand = new ArrayList<DrawerUI>(this.expandedDrawers());
        ArrayList<DrawerUI> toCollapse = new ArrayList<DrawerUI>();
        if (!drawer.expanded()) {
            for (DrawerUI d : toExpand) {
                d.shouldNotRotateIcon();
            }
            this.activate(drawer);
            toExpand.add(drawer);
        } else {
            toCollapse.add(drawer);
            this.deactivate(drawer);
            this.deactivateActiveDrawer();
            toExpand.remove(drawer);
            if (!toExpand.isEmpty()) {
                this.activate((DrawerUI)toExpand.get(0));
                for (DrawerUI d : toExpand) {
                    d.shouldNotRotateIcon();
                }
            }
        }
        this.toggleWithAnimation(toExpand, toCollapse);
        for (DrawerUI d : toExpand) {
            d.shouldRotateIcon();
        }
    }

    private void toggleVisibilityClosingOneAtATime(DrawerUI drawer) {
        if (!drawer.expanded()) {
            this.toggleWithAnimation(this.drawerList(drawer), this.expandedDrawers());
            return;
        }
        this.toggleWithAnimation(null, this.drawerList(drawer));
    }

    private DrawerUI firstCollapsedDrawer() {
        for (DrawerUI drawer : this.visibleDrawers()) {
            if (drawer.expanded()) continue;
            return drawer;
        }
        return null;
    }

    private boolean moreThanOneExpandedDrawer() {
        List<DrawerUI> drawers = this.visibleDrawers();
        int expandedCount = 0;
        for (DrawerUI drawer : drawers) {
            if (!drawer.expanded()) continue;
            if (expandedCount > 0) {
                return true;
            }
            ++expandedCount;
        }
        return false;
    }

    private void toggleVisibilityKeepingOne(DrawerUI drawer) {
        if (drawer.expanded()) {
            List<DrawerUI> expanded = this.expandedDrawers();
            expanded.remove(drawer);
            if (!expanded.isEmpty()) {
                this.toggleWithAnimation(null, expanded);
            }
            return;
        }
        this.toggleWithAnimation(this.drawerList(drawer), this.expandedDrawers());
    }

    void mousePressed(DrawerUI drawer, MouseEvent event) {
        List<DrawerUI> drawers = this.visibleDrawers();
        int drawerCount = drawers.size();
        this.drawerRatios = new ArrayList<Double>(drawerCount);
        int i = 0;
        while (i < drawerCount) {
            this.drawerRatios.add(drawers.get(i).ratio());
            ++i;
        }
        this.onMousePressed(drawer, event);
    }

    private void onMousePressed(DrawerUI drawer, MouseEvent event) {
        this.relativeStartPoint = SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), drawer);
    }

    void mouseReleased(DrawerUI drawer, MouseEvent event) {
        this.onMouseReleased(drawer, event);
        this.closeSmallDrawers();
        this.drawerRatios = null;
    }

    private void onMouseReleased(DrawerUI drawer, MouseEvent event) {
        if (this.dockableDragContext == null) {
            return;
        }
        Point ptScreen = event.getPoint();
        SwingUtilities.convertPointToScreen(ptScreen, event.getComponent());
        this.dockableDragContext.endDrag(ptScreen, this.mouseEventModifiersWithoutCtrlMask(event));
        this.dockableDragContext = null;
    }

    private void closeSmallDrawers() {
        ArrayList<DrawerUI> toCollapse = new ArrayList<DrawerUI>();
        for (DrawerUI drawer : this.expandedDrawers()) {
            if (this.heightOf(drawer) >= 20) continue;
            toCollapse.add(drawer);
        }
        if (toCollapse.isEmpty()) {
            return;
        }
        this.toggleWithAnimation(null, toCollapse);
    }

    private int heightOf(DrawerUI drawer) {
        return drawer.getHeight() - drawer.titlebarHeight();
    }

    void mouseDragged(DrawerUI drawer, MouseEvent event) {
        this.onMouseDragged(drawer, event);
    }

    private void onMouseDragged(DrawerUI drawer, MouseEvent event) {
        if (this.relativeStartPoint == null) {
            return;
        }
        Point ptScreen = event.getPoint();
        SwingUtilities.convertPointToScreen(ptScreen, event.getComponent());
        if (this.dockableDragContext == null) {
            this.initDockableDragContext(drawer, ptScreen);
        }
        if (!this.containsScreenPoint(ptScreen)) {
            return;
        }
        this.dockableDragContext.mouseMoved(ptScreen, this.mouseEventModifiersWithoutCtrlMask(event));
    }

    private int mouseEventModifiersWithoutCtrlMask(MouseEvent event) {
        if (!event.isControlDown()) {
            return event.getModifiers();
        }
        return BitField.unset(event.getModifiers(), 2);
    }

    private void initDockableDragContext(DrawerUI drawer, Point ptScreen) {
        this.dockableDragContext = DockStation.getDockStation().createDockableDragContext(this.dragSource);
        this.dockableDragContext.setDockables(new Dockable[]{this.view(drawer)});
        this.dockableDragContext.setStartPoint(ptScreen);
        Dimension drawerSize = drawer.getSize();
        this.dockableDragContext.setPreferredSizes(drawerSize, drawerSize);
    }

    private DockableWindow view(DrawerUI drawer) {
        return this.drawerWindow.view(drawer);
    }

    void minimizeWithAnimation(DrawerUI drawer) {
        this.minimize(drawer, true);
    }

    private void minimize(DrawerUI drawer, boolean animate) {
        if (animate && !Themes.isThemed()) {
            this.animateMinimization(drawer);
        }
        this.remove(drawer);
        List<DrawerUI> toExpand = this.toExpandWhenMiminizing(drawer);
        if (toExpand != null) {
            this.expand(toExpand);
            if (!toExpand.isEmpty()) {
                this.activate(toExpand.get(0));
            }
        }
        this.updateTrayIcon(false);
        this.visibleDrawerCountChanged();
        this.showMinimizedDrawerInVisibleTry();
        this.invalidateAndRevalidate();
        this.bottomComponent.requestFocus();
    }

    private void showMinimizedDrawerInVisibleTry() {
        if (this.tray == null || !this.tray.visible()) {
            return;
        }
        this.tray.clear();
        for (Drawer d : this.model().drawers()) {
            if (!d.minimizedButVisible()) continue;
            this.tray.addEntry(d);
        }
    }

    private List<DrawerUI> toExpandWhenMiminizing(DrawerUI toMinimize) {
        List<DrawerUI> expanded = this.expandedDrawers();
        if (expanded.size() > 1) {
            return null;
        }
        if (expanded.size() == 1 && !expanded.contains(toMinimize)) {
            return null;
        }
        return this.drawerList(this.firstCollapsedDrawer());
    }

    private void animateMinimization(DrawerUI drawer) {
        Animator.animate(30, 600L, 10, 0.6, 0.14, this.minimizeAnimationListener(drawer));
    }

    private PropertyChangeListener minimizeAnimationListener(DrawerUI drawer) {
        Rectangle sourceBounds = drawer.getBounds();
        Rectangle destBounds = this.bottomComponent.getBounds();
        return new 10(this, sourceBounds, destBounds, drawer);
    }

    void maximize(DrawerUI drawer) {
        List<DrawerUI> toCollapse = this.expandedDrawers();
        toCollapse.remove(drawer);
        List<DrawerUI> toExpand = drawer.expanded() ? null : this.drawerList(drawer);
        this.toggleWithAnimation(toExpand, toCollapse);
    }

    void addDropFeedback(int position) {
        this.dropFeedbackPos = position;
        this.invalidateAndValidate();
    }

    private void invalidateAndValidate() {
        this.invalidate();
        this.validate();
    }

    void removeDropFeedback() {
        this.addDropFeedback(-1);
    }

    void beStored(StructuredPropertyAccess p) {
        for (DrawerUI drawer : this.visibleDrawers()) {
            DefaultStructuredPropertyAccess propertyAccess = new DefaultStructuredPropertyAccess("Drawer");
            propertyAccess.setProperty("Ratio", Double.toString(drawer.ratio()));
            if (drawer.expanded()) {
                propertyAccess.setBooleanProperty("Expanded", true);
            }
            p.appendChild(propertyAccess);
        }
    }

    void loadLayout(StructuredPropertyAccess layout) {
        List<DrawerUI> drawers = this.visibleDrawers();
        Iterator childNodes = layout.getChildNodes("Drawer");
        int i = 0;
        while (i < drawers.size() && childNodes.hasNext()) {
            StructuredPropertyAccess propertyAccess = (StructuredPropertyAccess)childNodes.next();
            double ratio = Double.parseDouble(propertyAccess.getProperty("Ratio", "0"));
            boolean expanded = propertyAccess.getBooleanProperty("Expanded", false);
            DrawerUI drawer = drawers.get(i);
            drawer.ratio(ratio);
            drawer.expanded(expanded);
            ++i;
        }
        this.updateTrayIcon(this.hasMinimizedDrawers() ^ true);
    }

    private boolean hasMinimizedDrawers() {
        for (Drawer drawer : this.model().drawers()) {
            if (!drawer.minimized()) continue;
            return true;
        }
        return false;
    }

    void restoreWithoutAnimation(Drawer drawer) {
        this.restore(drawer, false);
    }

    void restoreFromMinimizedTray(Drawer drawer, boolean emptyTray) {
        this.restoreWithoutAnimation(drawer);
        this.updateTrayIcon(emptyTray);
        this.updateDrawerHandlesVisibility();
    }

    private Icon emptyTrayIcon() {
        return IdeIcons.getIcon((int)6);
    }

    private Icon notEmptyTrayIcon() {
        return IdeIcons.getIcon((int)25);
    }

    private void updateTrayIcon(boolean emptyTray) {
        String toolTip = emptyTray ? "" : "Click here to see minimized items";
        this.bottomComponent.setToolTipText(toolTip);
        this.bottomComponent.updateState(emptyTray);
        Icon icon = emptyTray ? this.emptyTrayIcon() : this.notEmptyTrayIcon();
        this.bottomComponent.setIcon(icon);
    }

    private void restore(Drawer drawer, boolean animate) {
        DrawerUI drawerUI = drawer.drawerUI();
        this.add(drawerUI);
        drawerUI.expanded(false);
        drawer.state(DrawerConfig.State.VISIBLE);
        this.validate();
        ArrayList<DrawerUI> allDrawersToExpand = new ArrayList<DrawerUI>();
        allDrawersToExpand.add(drawerUI);
        allDrawersToExpand.addAll(this.expandedDrawers());
        List<DrawerUI> allDrawersToCollapse = this.visibleDrawers();
        allDrawersToCollapse.removeAll(allDrawersToExpand);
        this.toggle(allDrawersToExpand, allDrawersToCollapse, animate);
        this.activate(drawerUI);
        this.visibleDrawerCountChanged();
    }

    void show(Drawer drawer) {
        this.hidden.remove(drawer);
        this.add(drawer.drawerUI());
        if (DrawerConfig.State.HIDDEN_AND_MINIMIZED.equals((Object)drawer.state())) {
            this.minimize(drawer.drawerUI(), false);
            drawer.state(DrawerConfig.State.MINIMIZED);
        } else {
            drawer.state(DrawerConfig.State.VISIBLE);
        }
        this.visibleDrawerCountChanged();
        this.invalidateAndRevalidate();
    }

    private void invalidateAndRevalidate() {
        this.invalidate();
        this.revalidate();
    }

    void hide(Drawer drawer) {
        this.visibleDrawerCountChanged();
        this.remove(drawer.drawerUI());
        this.invalidateAndRevalidate();
        this.hidden.add(drawer);
        if (drawer.minimized()) {
            this.hideMinimized(drawer);
            return;
        }
        drawer.state(DrawerConfig.State.HIDDEN);
    }

    private void hideMinimized(Drawer drawer) {
        drawer.state(DrawerConfig.State.HIDDEN_AND_MINIMIZED);
        this.updateTrayIcon(this.minimizedButVisibleDrawerCount() == 0);
    }

    private int heightDelta() {
        if (this.previousHeight == -1) {
            return 0;
        }
        return this.getHeight() - this.previousHeight;
    }

    private int widthDelta() {
        if (this.previousWidth == -1) {
            return 0;
        }
        return this.getWidth() - this.previousWidth;
    }

    @Override
    public void doLayout() {
        int heightDelta = this.heightDelta();
        if (heightDelta != 0) {
            this.updateBottomComponentBounds(this.getInsets());
            this.layout.normalLayout();
            this.resizeTray();
            this.updatePreviousHeight(this.getHeight());
            return;
        }
        this.updateBottomComponentBounds(this.getInsets());
        this.layout.normalLayout();
        this.resizeTray();
    }

    private void resizeTray() {
        if (this.tray != null && this.tray.visible()) {
            this.tray.updatePositionAndSize();
        }
    }

    private void updateBottomComponentBounds(Insets insets) {
        Dimension size = this.bottomComponent.getPreferredSize();
        int y = this.getHeight() - insets.bottom - size.height;
        this.bottomComponent.setBounds(0, y, this.getWidth(), size.height);
    }

    private void onDragCanceled() {
        this.relativeStartPoint = null;
        this.dockableDragContext = null;
    }

    private List<DrawerUI> drawerList(DrawerUI drawer) {
        if (drawer == null) {
            return null;
        }
        return Collections.singletonList(drawer);
    }

    private <T> boolean hasElements(List<T> list) {
        return list != null && !list.isEmpty();
    }

    @Override
    public boolean dragEnter(DockableDragContext context, Point point) {
        return this.dragOrAccept(context, point, false);
    }

    @Override
    public boolean dragOver(DockableDragContext context, Point point) {
        return this.dragOrAccept(context, point, false);
    }

    @Override
    public void dragExit(DockableDragContext context) {
        this.removeDropFeedback();
    }

    @Override
    public void acceptDrop(DockableDragContext context, Point point) {
    }

    private Drawer dragged(DockableDragContext context) {
        Dockable[] dockables = context.getDockables();
        if (dockables == null || dockables.length == 0 && !(dockables[0] instanceof DockableWindow)) {
            return null;
        }
        DockableWindow dragged = (DockableWindow)dockables[0];
        int index = this.model().indexOf(dragged);
        if (index == -1) {
            return null;
        }
        return this.model().drawerAt(index);
    }

    private boolean dragOrAccept(DockableDragContext context, Point point, boolean accept) {
        Drawer drawer = this.dragged(context);
        if (drawer == null) {
            return false;
        }
        DrawerUI draggedDrawer = drawer.drawerUI();
        if (this.isDropReorder(point, draggedDrawer)) {
            this.removeDropFeedback();
            Dimension drawerSize = draggedDrawer.getSize();
            this.dockableDragContext.setPreferredSizes(drawerSize, drawerSize);
            return true;
        }
        return true;
    }

    private boolean isDropReorder(Point point, DrawerUI drawer) {
        if (!this.containsScreenPoint(point)) {
            return false;
        }
        int delta = this.newPoint((Point)point, (Component)drawer).y - this.relativeStartPoint.y;
        DrawerUI previous = null;
        DrawerUI next = null;
        List<DrawerUI> drawers = this.visibleDrawers();
        int drawerIndex = drawers.indexOf(drawer);
        if (drawerIndex < 0) {
            return false;
        }
        if (delta < 0) {
            int i = drawerIndex - 1;
            while (previous == null && i >= 0) {
                if (drawers.get(i).expanded()) {
                    previous = drawers.get(i);
                }
                --i;
            }
            next = drawer;
        } else {
            if (drawerIndex > 0) {
                previous = drawers.get(drawerIndex - 1);
            }
            int i = drawerIndex;
            while (next == null && i < drawers.size()) {
                if (drawers.get(i).expanded()) {
                    next = drawers.get(i);
                }
                ++i;
            }
        }
        if (next == null && this.expandedDrawers().isEmpty()) {
            next = drawers.get(drawers.size() - 1);
            next.expansionRatio(1.0);
        }
        if (previous == null || next == null) {
            return false;
        }
        this.insideDrag(previous, next, delta);
        return true;
    }

    protected final void insideDrag(DrawerUI drawer1, DrawerUI drawer2, int delta) {
        List<DrawerUI> drawers = this.visibleDrawers();
        double allocatableHeight = this.allocatableHeight(drawers);
        double newRatio1 = this.newRatio(allocatableHeight, drawer1, delta);
        double newRatio2 = this.newRatio(allocatableHeight, drawer2, -delta);
        if (newRatio1 * allocatableHeight < 1.0) {
            newRatio2 += this.recalculateRatioAndCloseDrawer(drawer1);
        }
        if (newRatio2 * allocatableHeight < 1.0) {
            newRatio1 += this.recalculateRatioAndCloseDrawer(drawer2);
        }
        if (newRatio1 * allocatableHeight >= 1.0 && newRatio2 * allocatableHeight >= 1.0) {
            this.expandAndSetRatio(drawer1, newRatio1);
            this.expandAndSetRatio(drawer2, newRatio2);
        }
        this.invalidateAndValidate();
    }

    private double recalculateRatioAndCloseDrawer(DrawerUI drawer) {
        double r = drawer.ratio();
        drawer.expanded(false);
        double ratio = this.drawerRatios.get(this.indexOf(drawer));
        if (ratio > 0.0) {
            drawer.ratio(ratio);
        }
        return r;
    }

    private void expandAndSetRatio(DrawerUI drawer, double ratio) {
        drawer.expanded(true);
        drawer.ratio(ratio);
    }

    private double allocatableHeight(List<DrawerUI> drawers) {
        int height = this.getHeight();
        Insets insets = this.getInsets();
        int titlebarHeights = 0;
        for (DrawerUI drawer : drawers) {
            titlebarHeights += drawer.titlebarHeight();
        }
        return height - (insets.top + insets.bottom) - titlebarHeights;
    }

    private double newRatio(double allocatableHeight, DrawerUI drawer, int delta) {
        return drawer.ratio() + (double)delta / allocatableHeight;
    }

    private boolean containsScreenPoint(Point point) {
        return this.contains(this.newPoint(point));
    }

    private void dragAccept(Drawer drawer, int dropInsertPosition) {
        this.model().move(drawer, dropInsertPosition);
    }

    private int dropInsertPosition(Point point) {
        List<DrawerUI> drawers = this.visibleDrawers();
        Rectangle bounds = new Rectangle();
        Point pt = this.newPoint(point);
        int i = 0;
        while (i < drawers.size()) {
            DrawerUI drawer = drawers.get(i);
            drawer.getBounds(bounds);
            if (bounds.contains(pt)) {
                if (drawer.hostedComponent() == null) {
                    return i;
                }
                if (pt.y < bounds.y + bounds.height / 2) {
                    return i;
                }
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    private Point newPoint(Point src) {
        return this.newPoint(src, this);
    }

    private Point newPoint(Point src, Component c) {
        Point point = new Point(src);
        SwingUtilities.convertPointFromScreen(point, c);
        return point;
    }

    private int visibleDistance(int from, int to) {
        if (from > to) {
            return from - to;
        }
        return to - from - 1;
    }

    private int indexOf(DrawerUI visible) {
        return this.visibleDrawers().indexOf(visible);
    }

    private boolean draggedOverFeedback(int dropInsertPosition) {
        return dropInsertPosition == this.dropFeedbackPos;
    }

    static void mav$onDragCanceled(DrawerWindowUI drawerWindowUI) {
        drawerWindowUI.onDragCanceled();
    }

    static DrawerWindowModel mav$model(DrawerWindowUI drawerWindowUI) {
        return drawerWindowUI.model();
    }

    static void mav$removeDrawer(DrawerWindowUI drawerWindowUI, Drawer drawer) {
        drawerWindowUI.removeDrawer(drawer);
    }

    static void mav$addDrawer(DrawerWindowUI drawerWindowUI, Drawer drawer) {
        drawerWindowUI.addDrawer(drawer);
    }

    static void mav$setExpansionRatio(DrawerWindowUI drawerWindowUI, List list, double d) {
        drawerWindowUI.setExpansionRatio(list, d);
    }

    static void mav$invalidateAndValidate(DrawerWindowUI drawerWindowUI) {
        drawerWindowUI.invalidateAndValidate();
    }

    static void mav$previousPanel(DrawerWindowUI drawerWindowUI) {
        drawerWindowUI.previousPanel();
    }

    static void mav$nextPanel(DrawerWindowUI drawerWindowUI) {
        drawerWindowUI.nextPanel();
    }

    static void mav$closePanel(DrawerWindowUI drawerWindowUI) {
        drawerWindowUI.closePanel();
    }

    static void mav$openPanel(DrawerWindowUI drawerWindowUI) {
        drawerWindowUI.openPanel();
    }

    static void mav$trayClicked(DrawerWindowUI drawerWindowUI) {
        drawerWindowUI.trayClicked();
    }

    static void mav$updatePreviousHeight(DrawerWindowUI drawerWindowUI, int n) {
        drawerWindowUI.updatePreviousHeight(n);
    }

    static void mav$updatePreviousWidth(DrawerWindowUI drawerWindowUI, int n) {
        drawerWindowUI.updatePreviousWidth(n);
    }

    static DrawerUI ra$activeDrawer(DrawerWindowUI drawerWindowUI) {
        return drawerWindowUI.activeDrawer;
    }

    static DrawerWindowTray ra$tray(DrawerWindowUI drawerWindowUI) {
        return drawerWindowUI.tray;
    }

    private static class BottomComponent
    extends JButton {
        State state;

        private void $init$() {
            this.state = State.EMPTY;
        }

        BottomComponent() {
            this.$init$();
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder());
            if (Themes.isThemed()) {
                this.setPreferredSize(new Dimension(10, 14));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
                this.setHorizontalAlignment(4);
            }
            this.addMouseListener(new 1());
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (Themes.isThemed()) {
                String strState = this.state.toString();
                if (this.state == State.FULL_MOUSE_EXITED && this.hasFocus()) {
                    strState = State.FULL_MOUSE_ENTERED.toString();
                }
                ThemeProperties properties = Themes.getActiveTheme().getStateProperties("handler", strState.toLowerCase());
                Painter painter = properties.getPainter("bg");
                Insets insets = this.getInsets();
                painter.paint(g, insets.left, insets.top, this.getWidth(), this.getHeight());
            }
        }

        void updateState(boolean empty) {
            this.setFocusable(empty ^ true);
            this.state = empty ? State.EMPTY : State.FULL_MOUSE_EXITED;
        }

        public boolean isFocusable() {
            return this.state == State.EMPTY ? false : super.isFocusable();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class State
        extends Enum<State> {
            private static final /* synthetic */ State[] $v;
            public static final /* enum */ State EMPTY;
            public static final /* enum */ State FULL_MOUSE_ENTERED;
            public static final /* enum */ State FULL_MOUSE_EXITED;

            public static State valueOf(String string) {
                return Enum.valueOf(State.class, string);
            }

            public static final State[] values() {
                return (State[])$v.clone();
            }

            static {
                State[] stateArray = new State[3];
                stateArray[2] = FULL_MOUSE_EXITED = new State("FULL_MOUSE_EXITED", 2);
                stateArray[1] = FULL_MOUSE_ENTERED = new State("FULL_MOUSE_ENTERED", 1);
                stateArray[0] = EMPTY = new State("EMPTY", 0);
                $v = stateArray;
            }

            private State(String string2, int n2) {
            }
        }

        final class 1
        implements MouseListener {
            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                if (!BottomComponent.this.state.equals((Object)State.FULL_MOUSE_EXITED)) {
                    return;
                }
                BottomComponent.this.state = State.FULL_MOUSE_ENTERED;
                BottomComponent.this.repaint();
            }

            public void mouseExited(MouseEvent e) {
                if (!BottomComponent.this.state.equals((Object)State.FULL_MOUSE_ENTERED)) {
                    return;
                }
                BottomComponent.this.state = State.FULL_MOUSE_EXITED;
                BottomComponent.this.repaint();
            }
        }
    }

    private class DockableDragSourceImpl
    implements DockableDragSource {
        public void canceled() {
            DrawerWindowUI.mav$onDragCanceled(DrawerWindowUI.this);
        }

        private DockableDragSourceImpl() {
        }

        DockableDragSourceImpl(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class Listener
    implements ListDataListener {
        public void intervalAdded(ListDataEvent e) {
            int index0 = e.getIndex0();
            int index1 = e.getIndex1();
            int i = 0;
            while (i <= index1 - index0) {
                DrawerWindowUI.mav$addDrawer(DrawerWindowUI.this, DrawerWindowUI.mav$model(DrawerWindowUI.this).drawerAt(index0 + i));
                ++i;
            }
        }

        public void intervalRemoved(ListDataEvent e) {
            int index0 = e.getIndex0();
            int index1 = e.getIndex1();
            int i = 0;
            while (i <= index1 - index0) {
                DrawerWindowUI.mav$removeDrawer(DrawerWindowUI.this, DrawerWindowUI.mav$model(DrawerWindowUI.this).drawerAt(index0 + i));
                ++i;
            }
        }

        public void contentsChanged(ListDataEvent e) {
            throw new UnsupportedOperationException();
        }

        private Listener() {
        }

        Listener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    final class 1
    extends ComponentAdapter {
        public void componentResized(ComponentEvent e) {
            DrawerWindowUI.mav$updatePreviousHeight(DrawerWindowUI.this, e.getComponent().getHeight());
            DrawerWindowUI.mav$updatePreviousWidth(DrawerWindowUI.this, e.getComponent().getWidth());
        }
    }

    final class 2
    implements FocusListener {
        public void focusLost(FocusEvent e) {
        }

        public void focusGained(FocusEvent e) {
            if (DrawerWindowUI.ra$activeDrawer(DrawerWindowUI.this) != null) {
                DrawerWindowUI.this.expandIfNecessary(DrawerWindowUI.ra$activeDrawer(DrawerWindowUI.this));
                DrawerWindowUI.ra$activeDrawer(DrawerWindowUI.this).requestFocusInWindow();
            }
        }
    }

    final class 3
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            if (SwingUtilities.isEventDispatchThread() && "ancestor".equals(evt.getPropertyName()) && evt.getNewValue() == null && DrawerWindowUI.ra$tray(DrawerWindowUI.this) != null && DrawerWindowUI.ra$tray(DrawerWindowUI.this).visible()) {
                DrawerWindowUI.ra$tray(DrawerWindowUI.this).collapse();
            }
        }
    }

    final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            DrawerWindowUI.mav$trayClicked(DrawerWindowUI.this);
        }
    }

    final class 5
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            DrawerWindowUI.mav$previousPanel(DrawerWindowUI.this);
        }
    }

    final class 6
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            DrawerWindowUI.mav$nextPanel(DrawerWindowUI.this);
        }
    }

    final class 7
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            DrawerWindowUI.mav$closePanel(DrawerWindowUI.this);
        }
    }

    final class 8
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            DrawerWindowUI.mav$openPanel(DrawerWindowUI.this);
        }
    }

    final class 9
    implements PropertyChangeListener {
        private final /* synthetic */ List v$e;
        private final /* synthetic */ List v$c;
        final /* synthetic */ DrawerWindowUI this$0;

        public void propertyChange(PropertyChangeEvent evt) {
            double expansionRatio = (Double)evt.getNewValue();
            DrawerWindowUI.mav$setExpansionRatio(this.this$0, this.v$e, expansionRatio);
            DrawerWindowUI.mav$setExpansionRatio(this.this$0, this.v$c, 1.0 - expansionRatio);
            DrawerWindowUI.mav$invalidateAndValidate(this.this$0);
            Graphics g = this.this$0.getGraphics();
            this.this$0.paint(g);
            g.dispose();
        }

        public 9(DrawerWindowUI drawerWindowUI, List list, List list2) {
            this.v$c = list2;
            this.v$e = list;
            this.this$0 = drawerWindowUI;
        }
    }

    final class 10
    implements PropertyChangeListener {
        private final /* synthetic */ Rectangle v$sourceBounds;
        private final /* synthetic */ Rectangle v$destBounds;
        private final /* synthetic */ DrawerUI v$drawer;
        final /* synthetic */ DrawerWindowUI this$0;

        public void propertyChange(PropertyChangeEvent evt) {
            double r = (Double)evt.getNewValue();
            int x = (int)((double)this.v$sourceBounds.x + (double)(this.v$destBounds.x - this.v$sourceBounds.x) * r);
            int y = (int)((double)this.v$sourceBounds.y + (double)(this.v$destBounds.y - this.v$sourceBounds.y) * r);
            int width = (int)((double)this.v$sourceBounds.width + (double)(this.v$destBounds.width - this.v$sourceBounds.width) * r);
            int height = (int)((double)this.v$sourceBounds.height + (double)(this.v$destBounds.height - this.v$sourceBounds.height) * r);
            this.v$drawer.setBounds(x, y, width, height);
            Graphics g = this.this$0.getGraphics();
            this.this$0.paint(g);
            g.dispose();
        }

        public 10(DrawerWindowUI drawerWindowUI, Rectangle rectangle, Rectangle rectangle2, DrawerUI drawerUI) {
            this.v$drawer = drawerUI;
            this.v$destBounds = rectangle2;
            this.v$sourceBounds = rectangle;
            this.this$0 = drawerWindowUI;
        }
    }
}

