/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.feedback.shared;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public abstract class Feedback {
    private long _timestamp = System.currentTimeMillis();

    protected abstract void writeImpl(DataOutputStream var1) throws IOException;

    protected abstract void readImpl(DataInputStream var1) throws IOException;

    protected abstract void dumpImpl(PrintStream var1);

    protected Feedback() {
    }

    public final void write(DataOutputStream outputStream) throws IOException {
        Class<?> feedbackClass = this.getClass();
        String fqClassName = feedbackClass.getName();
        outputStream.writeUTF(fqClassName);
        outputStream.writeLong(this._timestamp);
        this.writeImpl(outputStream);
    }

    public static final Feedback read(ClassLoader classLoader, DataInputStream inputStream) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        String fqClassName = inputStream.readUTF();
        try {
            Class<?> feedbackClass = classLoader.loadClass(fqClassName);
            Feedback feedback = (Feedback)feedbackClass.newInstance();
            feedback._timestamp = inputStream.readLong();
            feedback.readImpl(inputStream);
            Feedback feedback2 = feedback;
            return feedback2;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public final void dump(PrintStream stream) {
        this.dumpImpl(stream);
    }
}

