/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyboardDockable;
import oracle.ide.layout.IdeProperties;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.Copyable;

public final class KeyStrokeOptions
extends ChangeEventSource
implements Copyable {
    static final boolean DEBUG = false;
    public static final String KEY_SETTINGS = KeyStrokeOptions.class.getName();
    private ArrayList _postponedContexts;
    private String _presetName;
    private boolean _bModifiedPreset;
    private KeyStrokeMap _ksmGlobal;
    private HashMap _mapKsmLocal;
    private final ArrayList _knownContexts;
    private ActionListener _keyboardPanelEventDispatcher;

    private void $init$() {
        this._knownContexts = new ArrayList(20);
    }

    public KeyStrokeOptions() {
        this.$init$();
    }

    public Object copyTo(Object target) {
        KeyStrokeOptions copy = target != null ? (KeyStrokeOptions)((Object)target) : new KeyStrokeOptions();
        this.copyToImpl(copy);
        return copy;
    }

    private final void copyToImpl(KeyStrokeOptions copy) {
        copy.assign(this, true);
    }

    public KeyStrokeOptions cloneObject(boolean bDeepCopy) {
        KeyStrokeOptions clone = new KeyStrokeOptions();
        clone.assign(this, bDeepCopy);
        return clone;
    }

    void assign(KeyStrokeOptions source, boolean bDeepCopy) {
        this._presetName = source._presetName;
        this._bModifiedPreset = source._bModifiedPreset;
        this._keyboardPanelEventDispatcher = source._keyboardPanelEventDispatcher;
        if (bDeepCopy) {
            this._ksmGlobal = source._ksmGlobal.cloneObject();
            if (source._mapKsmLocal != null) {
                this._mapKsmLocal = new HashMap(source._mapKsmLocal.size());
                for (Map.Entry entry : source._mapKsmLocal.entrySet()) {
                    KeyStrokeMap ksm = (KeyStrokeMap)entry.getValue();
                    this._mapKsmLocal.put(entry.getKey(), ksm.cloneObject());
                }
            }
        } else {
            this._ksmGlobal = source._ksmGlobal;
            this._mapKsmLocal = source._mapKsmLocal;
        }
        this.fireChangeEvent();
    }

    public String getPresetName() {
        if (this._presetName == null) {
            this._presetName = Ide.getProperty("DefaultKeyMapping", "Default");
        }
        return this._presetName;
    }

    public void setPresetName(String sName) {
        this._presetName = sName;
    }

    public boolean isModifiedPreset() {
        return this._bModifiedPreset;
    }

    public void setModifiedPreset(boolean bModified) {
        this._bModifiedPreset = bModified;
    }

    public KeyStrokeMap getLocalKeyMap(KeyStrokeContext ksc) {
        KeyStrokeMap ksm = null;
        if (this._mapKsmLocal != null) {
            ksm = (KeyStrokeMap)this._mapKsmLocal.get(ksc.getName());
        }
        return ksm;
    }

    void loadPreset(KeyStrokeContextRegistry kscr, String sPreset) {
        this._ksmGlobal.removeAll();
        Iterator i = kscr.getAllContexts();
        while (i.hasNext()) {
            KeyStrokeMap ksmNew;
            KeyStrokeContext ksc = (KeyStrokeContext)i.next();
            String sName = ksc.getName();
            Object kscPreset = KeyStrokeContextRegistry.searchPreset(ksc, sPreset);
            if (kscPreset == null) continue;
            KeyStrokeMap ksmNewGlobal = ksc.getPresetKeyStrokeMap(kscPreset, true);
            if (ksmNewGlobal != null) {
                this._ksmGlobal.putAll(ksmNewGlobal);
            }
            if ((ksmNew = ksc.getPresetKeyStrokeMap(kscPreset, false)) != null) {
                this._mapKsmLocal.put(sName, ksmNew);
                continue;
            }
            this._mapKsmLocal.remove(sName);
        }
        this.setPresetName(sPreset);
        this._bModifiedPreset = false;
        this.fireChangeEvent();
    }

    public void addContext(KeyStrokeContext ksc) {
        if (this._postponedContexts == null) {
            this._postponedContexts = new ArrayList(20);
        }
        this._postponedContexts.add(ksc);
    }

    public void solvePostponedMaps() {
        if (this._postponedContexts == null) {
            return;
        }
        this.checkShowKeyboardDockable();
        String sPreset = this.getPresetName();
        int n = this._postponedContexts.size();
        if (this._mapKsmLocal == null) {
            this._mapKsmLocal = new HashMap();
        }
        int i = 0;
        while (i < n) {
            KeyStrokeContext ksc = (KeyStrokeContext)this._postponedContexts.get(i);
            if (!this._knownContexts.contains(ksc.getName())) {
                this._knownContexts.add(ksc.getName());
                Object kscPreset = KeyStrokeContextRegistry.searchPreset(ksc, sPreset);
                KeyStrokeMap ksm = ksc.getPresetKeyStrokeMap(kscPreset, true);
                if (ksm != null) {
                    KeyStrokeMap ksmGlobal = this.getGlobalKeyMap();
                    ksmGlobal.putAll(ksm);
                }
                if ((ksm = ksc.getPresetKeyStrokeMap(kscPreset, false)) != null) {
                    this._mapKsmLocal.put(ksc.getName(), ksm);
                }
            }
            ++i;
        }
        this._postponedContexts.clear();
        if (this._ksmGlobal != null) {
            this._ksmGlobal.solvePostponedLoad();
        }
        for (KeyStrokeMap ksm : this._mapKsmLocal.values()) {
            ksm.solvePostponedLoad();
        }
        this.fireChangeEvent();
    }

    private void checkShowKeyboardDockable() {
        IdeProperties ideProperties = Ide.getIdeProperties();
        String property = ideProperties.getProperty("SHOW_KEYBOARD_DOCKABLE", "false");
        if (Boolean.valueOf(property).booleanValue()) {
            KeyboardDockable.initialize();
        }
    }

    public void removeContext(KeyStrokeContext ksc) {
        KeyStrokeMap ksm;
        if (this._mapKsmLocal != null) {
            this._mapKsmLocal.remove(ksc.getName());
        }
        if ((ksm = ksc.getPresetKeyStrokeMap(KeyStrokeContextRegistry.searchPreset(ksc, this.getPresetName()), true)) != null) {
            KeyStrokeMap ksmGlobal = this.getGlobalKeyMap();
            ksmGlobal.removeAll(ksm);
        }
        this._knownContexts.remove(ksc.getName());
        this.fireChangeEvent();
    }

    public void setKeyboardPanelEventDispatcher(ActionListener actionListener) throws TransientMarker {
        this._keyboardPanelEventDispatcher = actionListener;
    }

    public ActionListener getKeyboardPanelEventDispatcher() throws TransientMarker {
        return this._keyboardPanelEventDispatcher;
    }

    public KeyStrokeMap getGlobalKeyMap() {
        if (this._ksmGlobal == null) {
            this._ksmGlobal = new KeyStrokeMap();
        }
        return this._ksmGlobal;
    }

    public void setGlobalKeyMap(KeyStrokeMap ksm) {
        this._ksmGlobal = ksm;
    }

    public void setLocalKeyMaps(HashMap mapKsmLocal) {
        this._mapKsmLocal = mapKsmLocal;
    }

    public HashMap getLocalKeyMaps() {
        return this._mapKsmLocal;
    }

    public ArrayList getRegisteredContexts() {
        return this._knownContexts;
    }

    public void setRegisteredContexts(ArrayList list) {
        this._knownContexts.addAll(list);
    }
}

