/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeField;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.KeyStrokesConstraint;
import oracle.ide.keyboard.KeyStrokesConstraintFactory;
import oracle.ide.keyboard.PresetsPanel;
import oracle.ide.keyboard.XMLKeystrokeContextDefs;
import oracle.ide.nulls.NullIcon;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;

public final class KeyStrokePanel
extends DefaultTraversablePanel
implements KeyStrokesConstraint,
ListSelectionListener,
ActionListener {
    private static final int WIDTH_COL1 = 200;
    private static final int WIDTH_COL2 = 150;
    private final Icon NULL_ICON;
    private String _sOthersCategory;
    private String _sAllCategory;
    private KeyStrokeOptions _kso;
    private final DefaultComboBoxModel _catModel;
    private JComboBox _jcbCategory;
    private JList _jlActions;
    private JList _jlShortcuts;
    private KeyStrokeField _jksNewShortcut;
    private JTextField _jlblCurrentAssign;
    private JButton _jbRemove;
    private JButton _jbPresets;
    private JButton _jbAdd;

    private void $init$() {
        this.NULL_ICON = new NullIcon();
        this._catModel = new DefaultComboBoxModel();
    }

    public KeyStrokePanel() {
        this.$init$();
        this.setHelpID("f1_idedidesetshortcuts_html");
        this._sOthersCategory = IdeArb.getString(37);
        this._sAllCategory = IdeArb.getString(349);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._jksNewShortcut.setConstraint(this);
        this.fillCategories();
    }

    public void onEntry(TraversableContext tc) {
        if (this._kso == null) {
            KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
            keyStrokeContextRegistry.loadAcceleratorDefinitionFiles();
            IdeSettings ideSettings = (IdeSettings)tc.find("ide-options");
            this._kso = ideSettings.getKeyStrokeOptions();
            ActionEvent event = new ActionEvent(this, 1001, "showing");
            this._kso.getKeyboardPanelEventDispatcher().actionPerformed(event);
        }
    }

    public void onExit(TraversableContext tc) {
    }

    public boolean isAcceptableKey(KeyStrokes kss, KeyStroke ksNew) {
        KeyStrokesConstraint kscon = KeyStrokesConstraintFactory.getConstraint(0);
        return kscon == null ? true : kscon.isAcceptableKey(kss, ksNew);
    }

    private void jbInit() throws Exception {
        this._jcbCategory = new JComboBox(this._catModel);
        this._jlActions = new JList(new DefaultListModel());
        this._jlShortcuts = new JList(new DefaultListModel());
        this._jksNewShortcut = new KeyStrokeField();
        this._jlblCurrentAssign = new JTextField();
        this._jbRemove = new JButton();
        this._jbAdd = new JButton();
        this._jbPresets = new JButton();
        JLabel lblActions = new JLabel();
        JScrollPane jspActions = new JScrollPane(this._jlActions);
        this.setActionRenderer(this._jlActions);
        JLabel lblShortcut = new JLabel();
        JScrollPane jScrollPaneShortcuts = new JScrollPane(this._jlShortcuts);
        JLabel lblNewShortcut = new JLabel();
        JLabel lblCurrent = new JLabel();
        JPanel jpWeight1 = new JPanel();
        ResourceUtils.resLabel((JLabel)lblActions, (Component)this._jlActions, (String)IdeArb.getString(196));
        ResourceUtils.resLabel((JLabel)lblShortcut, (Component)this._jlShortcuts, (String)IdeArb.getString(65));
        ResourceUtils.resButton((AbstractButton)this._jbRemove, (String)IdeArb.getString(326));
        ResourceUtils.resLabel((JLabel)lblNewShortcut, (Component)this._jksNewShortcut, (String)IdeArb.getString(372));
        ResourceUtils.resButton((AbstractButton)this._jbAdd, (String)IdeArb.getString(66));
        ResourceUtils.resButton((AbstractButton)this._jbPresets, (String)IdeArb.getString(286));
        ResourceUtils.resLabel((JLabel)lblCurrent, (Component)this._jlblCurrentAssign, (String)IdeArb.getString(216));
        this._jbAdd.setEnabled(false);
        this._jlActions.setSelectionMode(0);
        this._jlShortcuts.setSelectionMode(2);
        this._jksNewShortcut.setMinimumSize(new Dimension(4, 21));
        this._jksNewShortcut.setEnabled(false);
        this._jbRemove.setEnabled(false);
        this._jbRemove.addActionListener(this);
        this._jbAdd.addActionListener(this);
        this._jbPresets.addActionListener(this);
        this._jlblCurrentAssign.setColumns(5);
        this._jlblCurrentAssign.setEditable(false);
        this.setLayout(new GridBagLayout());
        this._jcbCategory.addActionListener(this);
        this._jlActions.getSelectionModel().addListSelectionListener(this);
        this._jlShortcuts.getSelectionModel().addListSelectionListener(this);
        this._jksNewShortcut.getModel().addActionListener(this);
        int nTop = 0;
        if (this.hasCategories()) {
            JLabel lblCategory = new JLabel();
            ResourceUtils.resLabel((JLabel)lblCategory, (Component)this._jcbCategory, (String)IdeArb.getString(353));
            this.add(lblCategory, new GridBagConstraints(0, nTop++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 2, 1, 5), 0, 0));
            this.add(this._jcbCategory, new GridBagConstraints(0, nTop++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 5, 5), 0, 0));
        }
        this.add(lblActions, new GridBagConstraints(0, nTop++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 2, 1, 5), 0, 0));
        this.add(jspActions, new GridBagConstraints(0, nTop, 1, 10 - nTop, 1.0, 1.0, 10, 1, new Insets(0, 2, 1, 5), 0, 0));
        this.add(lblShortcut, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 1, 5), 0, 0));
        this.add(jScrollPaneShortcuts, new GridBagConstraints(1, 1, 1, 3, 0.0, 1.0, 10, 1, new Insets(0, 2, 5, 5), 0, 0));
        this.add(this._jbRemove, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 2, 1, 0), 0, 0));
        this.add(lblNewShortcut, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 1, 5), 0, 0));
        this.add(this._jksNewShortcut, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 2, 5, 5), 0, 0));
        this.add(this._jbAdd, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 2, 5, 0), 0, 0));
        this.add(lblCurrent, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 1, 5), 0, 0));
        this.add(this._jlblCurrentAssign, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 2, 1, 5), 0, 0));
        this.add(this._jbPresets, new GridBagConstraints(1, 8, 2, 2, 0.0, 0.0, 14, 0, new Insets(0, 2, 1, 0), 0, 0));
        this.add(jpWeight1, new GridBagConstraints(1, 9, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 2, 1));
        KeyStrokePanel.adjustPreferredWidth(this._jcbCategory, 200);
        jspActions.setPreferredSize(new Dimension(200, 300));
        jScrollPaneShortcuts.setPreferredSize(new Dimension(150, 100));
        KeyStrokePanel.adjustPreferredWidth(this._jksNewShortcut, 150);
        KeyStrokePanel.adjustPreferredWidth(this._jlblCurrentAssign, 150);
    }

    private static void adjustPreferredWidth(JComponent c, int nWidth) {
        Dimension d = c.getPreferredSize();
        d.width = nWidth;
        c.setPreferredSize(d);
    }

    private void setActionRenderer(JList list) {
        list.setCellRenderer(new 1());
    }

    private void fillCategories() {
        Set uniqueCat = this.getDistinctCategories();
        this._catModel.addElement(this._sAllCategory);
        boolean bHasOthers = false;
        for (String sCategory : uniqueCat) {
            if (sCategory != this._sOthersCategory) {
                this._catModel.addElement(sCategory);
                continue;
            }
            bHasOthers = true;
        }
        if (bHasOthers) {
            this._catModel.addElement(this._sOthersCategory);
        }
    }

    private void fillActions() {
        String sCategory = (String)this._jcbCategory.getSelectedItem();
        TreeSet acts = new TreeSet();
        Iterator iKsc = KeyStrokePanel.getAllContexts();
        while (iKsc.hasNext()) {
            KeyStrokeContext ksc = (KeyStrokeContext)iKsc.next();
            this.fillActions(acts, sCategory, ksc, true);
            this.fillActions(acts, sCategory, ksc, false);
        }
        this._jlActions.getSelectionModel().clearSelection();
        DefaultListModel model = (DefaultListModel)this._jlActions.getModel();
        model.removeAllElements();
        Iterator i = acts.iterator();
        while (i.hasNext()) {
            model.addElement(i.next());
        }
    }

    private void fillActions(Set acts, String sCategory, KeyStrokeContext ksc, boolean bGlobal) {
        Set setActions = KeyStrokePanel.getAllActions(ksc, bGlobal);
        if (setActions != null) {
            for (IdeAction act : setActions) {
                if (sCategory != this._sAllCategory && !sCategory.equalsIgnoreCase(this.getCategory(act))) continue;
                acts.add(new ActionElement(ksc, act, bGlobal));
            }
        }
    }

    private void fillShortcuts() {
        ListSelectionModel selectionModel = this._jlShortcuts.getSelectionModel();
        selectionModel.clearSelection();
        DefaultListModel model = (DefaultListModel)this._jlShortcuts.getModel();
        model.removeAllElements();
        ActionElement actE = (ActionElement)this._jlActions.getSelectedValue();
        if (actE != null) {
            IdeAction action = actE._act;
            KeyStrokeMap ksm = this._kso.getGlobalKeyMap();
            KeyStrokePanel.fillShortcuts(ksm, action, model);
            Iterator iKsc = KeyStrokePanel.getAllContexts();
            while (iKsc.hasNext()) {
                KeyStrokeContext ksc = (KeyStrokeContext)iKsc.next();
                ksm = this._kso.getLocalKeyMap(ksc);
                KeyStrokePanel.fillShortcuts(ksm, action, model);
            }
        }
        selectionModel.setSelectionInterval(0, model.getSize() - 1);
    }

    private static void fillShortcuts(KeyStrokeMap ksm, IdeAction action, DefaultListModel model) {
        if (ksm != null) {
            List oStrokes = ksm.getKeyStrokesFor((Integer)action.getCommandId());
            for (KeyStrokes kss : oStrokes) {
                model.addElement(new ShortcutElement(ksm, kss));
            }
        }
    }

    private int getCurrentAssign(KeyStrokeMap ksm, KeyStrokes kss, int nCount, StringBuffer sbText) {
        KeyStrokes kssAssigned;
        Integer binding;
        IdeAction action;
        List lAssigned;
        int n;
        if (ksm != null && (nCount += (n = (lAssigned = ksm.getKeyStrokesStartingWith(kss)).size())) == 1 && nCount == lAssigned.size() && (action = this.searchAction(binding = ksm.getBindingFor(kssAssigned = (KeyStrokes)lAssigned.get(0)))) != null) {
            String category = this.getCategory(action);
            if (category != null) {
                sbText.append(category).append(".");
            }
            sbText.append(KeyStrokePanel.getName(action));
        }
        return nCount;
    }

    private void fillCurrentAssign(KeyStrokes kss) {
        int nCount = 0;
        StringBuffer sbText = new StringBuffer();
        if (!kss.isEmpty()) {
            KeyStrokeMap ksm = this._kso.getGlobalKeyMap();
            nCount = this.getCurrentAssign(ksm, kss, nCount, sbText);
            Iterator iKsc = KeyStrokePanel.getAllContexts();
            while (iKsc.hasNext()) {
                KeyStrokeContext ksc = (KeyStrokeContext)iKsc.next();
                ksm = this._kso.getLocalKeyMap(ksc);
                nCount = this.getCurrentAssign(ksm, kss, nCount, sbText);
            }
        }
        switch (nCount) {
            case 0: {
                this._jlblCurrentAssign.setText("");
                break;
            }
            case 1: {
                this._jlblCurrentAssign.setText(sbText.toString());
                break;
            }
            default: {
                this._jlblCurrentAssign.setText(IdeArb.getString(135));
            }
        }
    }

    private IdeAction searchAction(int nID) {
        for (IdeAction act : KeyStrokePanel.getAllActions()) {
            if (act.getCommandId() != nID) continue;
            return act;
        }
        return null;
    }

    private void loadPreset(String sPreset) {
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        this._kso.loadPreset(kscr, sPreset);
        this.fillShortcuts();
        this._jksNewShortcut.clear();
    }

    private void whenPreset() {
        String sCurrentPreset = this._kso.getPresetName();
        Frame f = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)this));
        XMLKeystrokeContextDefs defs = XMLKeystrokeContextDefs.getInstance();
        String sNewPreset = PresetsPanel.run(f, sCurrentPreset);
        if (sNewPreset != null) {
            boolean bOk = true;
            if (this._kso.isModifiedPreset()) {
                String sLabel = IdeArb.getString(21);
                String sTitle = IdeArb.getString(472);
                JMultiLineLabel lbl = new JMultiLineLabel(sLabel);
                HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)lbl), "f1_idedloadpreset_html");
                bOk = OnePageWizardDialogFactory.runDialog((Component)((Object)lbl), null, sTitle);
            }
            if (bOk) {
                this.loadPreset(sNewPreset);
            }
        }
        defs.unload();
    }

    private void whenCategorySelectionChange() {
        this.fillActions();
    }

    private void actionSelectionChange() {
        this.fillShortcuts();
        Object actE = this._jlActions.getSelectedValue();
        this._jksNewShortcut.getModel().clear();
        this._jksNewShortcut.setEnabled(actE != null);
    }

    private void shortcutSelectionChange() {
        this._jbRemove.setEnabled(this._jlShortcuts.getSelectionModel().isSelectionEmpty() ^ true);
    }

    private void whenShortcutFieldChange() {
        KeyStrokes kss = this._jksNewShortcut.getModel().getKeyStrokes();
        this.fillCurrentAssign(kss);
        this._jbAdd.setEnabled(!kss.isEmpty());
    }

    private void whenRemove() {
        Object[] selectedValues = this._jlShortcuts.getSelectedValues();
        int i = 0;
        while (i < selectedValues.length) {
            ShortcutElement se = (ShortcutElement)selectedValues[i];
            se._map.remove(se._kss);
            this._kso.setModifiedPreset(true);
            ++i;
        }
        this.fillShortcuts();
    }

    private void whenAdd() {
        ActionElement actElm;
        KeyStrokes kss = this._jksNewShortcut.getModel().getKeyStrokes();
        if (kss != null && (actElm = (ActionElement)this._jlActions.getSelectedValue()) != null) {
            boolean bGlobal = actElm._bGlobal;
            KeyStrokeContext ksc = actElm._ksc;
            Iterator i = KeyStrokePanel.getAllContexts();
            while (i.hasNext()) {
                KeyStrokeContext kscI = (KeyStrokeContext)i.next();
                this.removeShortcutsStartingWith(kscI, kss, true);
                if (!bGlobal && kscI != ksc) continue;
                this.removeShortcutsStartingWith(kscI, kss, false);
            }
            KeyStrokeMap ksm = bGlobal ? this._kso.getGlobalKeyMap() : this._kso.getLocalKeyMap(ksc);
            IdeAction action = actElm._act;
            ksm.put(kss, action.getCommandId());
            this._jksNewShortcut.clear();
            this._kso.setModifiedPreset(true);
            this.fillShortcuts();
        }
    }

    private void removeShortcutsStartingWith(KeyStrokeContext ksc, KeyStrokes kss, boolean bGlobal) {
        KeyStrokeMap ksm = bGlobal ? this._kso.getGlobalKeyMap() : this._kso.getLocalKeyMap(ksc);
        KeyStrokePanel.removeShortcutsStartingWith(ksm, kss);
    }

    private static void removeShortcutsStartingWith(KeyStrokeMap ksm, KeyStrokes kss) {
        if (ksm != null) {
            List lKeys = ksm.getKeyStrokesStartingWith(kss);
            for (KeyStrokes key : lKeys) {
                ksm.remove(key);
            }
        }
    }

    private static String getName(IdeAction act) {
        return (String)act.getValue("Name");
    }

    private String getCategory(IdeAction act) {
        String sCategory = (String)act.getValue("Category");
        if (sCategory == null) {
            sCategory = this._sOthersCategory;
        }
        return sCategory;
    }

    private static Iterator getAllContexts() {
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        return kscr.getAllContexts();
    }

    private static Set getAllActions() {
        HashSet set = new HashSet();
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        Iterator iter = kscr.getAllContexts();
        while (iter.hasNext()) {
            KeyStrokeContext ksc = (KeyStrokeContext)iter.next();
            int i = 0;
            while (i < 2) {
                Set setAllActions = KeyStrokePanel.getAllActions(ksc, i == 0);
                if (setAllActions != null) {
                    set.addAll(setAllActions);
                }
                ++i;
            }
        }
        return set;
    }

    private static Set getAllActions(KeyStrokeContext ksc, boolean global) {
        Set allActions = ksc.getAllActions(global);
        if (allActions != null && allActions.remove(null)) {
            Assert.println((String)(ksc.getClass().getName() + " returned a null Action from getAllActions(boolean)"));
        }
        return allActions;
    }

    private Set getDistinctCategories() {
        TreeSet<String> set = new TreeSet<String>();
        for (IdeAction act : KeyStrokePanel.getAllActions()) {
            set.add(this.getCategory(act));
        }
        return set;
    }

    private boolean hasCategories() {
        Set setCategories = this.getDistinctCategories();
        return setCategories.size() > 1;
    }

    public void valueChanged(ListSelectionEvent e) {
        Object src = e.getSource();
        if (src == this._jlActions.getSelectionModel()) {
            this.actionSelectionChange();
        } else if (src == this._jlShortcuts.getSelectionModel()) {
            this.shortcutSelectionChange();
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this._jbRemove) {
            this.whenRemove();
        } else if (src == this._jbAdd) {
            this.whenAdd();
        } else if (src == this._jbPresets) {
            this.whenPreset();
        } else if (src == this._jksNewShortcut.getModel()) {
            this.whenShortcutFieldChange();
        } else if (src == this._jcbCategory) {
            this.whenCategorySelectionChange();
        }
    }

    static Icon ra$NULL_ICON(KeyStrokePanel keyStrokePanel) {
        return keyStrokePanel.NULL_ICON;
    }

    final class 1
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            ActionElement ae = (ActionElement)value;
            Icon icon = (Icon)ae._act.getValue("SmallIcon");
            if (icon == null) {
                icon = KeyStrokePanel.ra$NULL_ICON(KeyStrokePanel.this);
            }
            this.setIcon(icon);
            return c;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ActionElement
    implements Comparable {
        final IdeAction _act;
        final KeyStrokeContext _ksc;
        final boolean _bGlobal;

        ActionElement(KeyStrokeContext ksc, IdeAction act, boolean bGlobal) {
            this._ksc = ksc;
            this._act = act;
            this._bGlobal = bGlobal;
        }

        public final String toString() {
            String s = (String)this._act.getValue("NoCtxName");
            if (s != null && s.length() > 0) {
                return s;
            }
            String name = (String)this._act.getValue("Name");
            if (name != null) {
                return name;
            }
            int commandId = this._act.getCommandId();
            String command = this._act.getCommand();
            String message = "Action has no name: Command id= " + commandId + " ; Command = " + String.valueOf(command);
            FeedbackManager.reportException(message, new IllegalArgumentException());
            return "";
        }

        public final int compareTo(Object o) {
            return String.CASE_INSENSITIVE_ORDER.compare(this.toString(), o.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ShortcutElement
    implements Comparable {
        final KeyStrokeMap _map;
        final KeyStrokes _kss;

        ShortcutElement(KeyStrokeMap map, KeyStrokes kss) {
            this._map = map;
            this._kss = kss;
        }

        public final String toString() {
            return this._kss.toString();
        }

        public final int compareTo(Object o) {
            KeyStrokes kss2 = (KeyStrokes)o;
            return this.toString().compareTo(kss2.toString());
        }
    }
}

