/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DockingParam;
import oracle.ide.keyboard.Dumpable;
import oracle.ide.keyboard.KeyStroke2String;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.MyModel;
import oracle.ide.keyboard.ResKeystrokeContext;
import oracle.ide.layout.Layout;
import oracle.ide.layout.ViewId;
import oracle.ide.util.GraphicsUtils;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.util.Pair;

final class KeyboardDockable
extends DockableWindow
implements DockableFactory {
    private static final String VIEW_TYPE_ID = "KF";
    private static final String DOCKABLE_ID = "KF.KF";
    private static KeyboardDockable INSTANCE = null;
    private JTable _table;
    private JComponent _GUI;
    private MyModel _model;
    private JList _list;

    private KeyboardDockable() {
        super(DOCKABLE_ID);
        DockStation ds = DockStation.getDockStation();
        ds.registerDockableFactory(VIEW_TYPE_ID, this);
        KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
        this._model = new MyModel();
        kso.addChangeListener(this._model);
        JMenu viewMenu = MenuManager.getJMenu("View");
        JMenuItem item = viewMenu.add("Keyboard");
        item.addActionListener(new 1(this, item, ds));
    }

    static void initialize() {
        if (INSTANCE == null) {
            INSTANCE = new KeyboardDockable();
        }
    }

    public String getTitleName() {
        return "Keyboard Dockable";
    }

    public String getTabName() {
        return this.getTitleName();
    }

    public int getDefaultVisibility(Layout layout) {
        return super.getDefaultVisibility(layout) | 1;
    }

    public Component getGUI() {
        if (this._GUI == null) {
            KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
            keyStrokeContextRegistry.loadAcceleratorDefinitionFiles();
            this._table = new JTable(this._model);
            this._table.setColumnSelectionAllowed(false);
            this._table.getTableHeader().addMouseListener(new 2());
            this._table.addMouseListener(new 3());
            JScrollPane tableScrollPane = new JScrollPane(this._table);
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.addTab("1", tableScrollPane);
            DefaultListModel<Pair> listModel = new DefaultListModel<Pair>();
            this._list = new 4(this, listModel, listModel);
            this._list.setCellRenderer(new 5());
            Iterator allContexts = keyStrokeContextRegistry.getAllContexts();
            while (allContexts.hasNext()) {
                KeyStrokeContext keyStrokeContext = (KeyStrokeContext)allContexts.next();
                int i = 0;
                while (i < 2) {
                    boolean global = i == 0;
                    Set allActions = keyStrokeContext.getAllActions(global);
                    if (allActions != null && !allActions.isEmpty()) {
                        listModel.addElement(new Pair((Object)keyStrokeContext, (Object)global));
                    }
                    ++i;
                }
            }
            this._list.addListSelectionListener(new 6());
            JScrollPane listScrollPane = new JScrollPane(this._list);
            tabbedPane.addTab("2", listScrollPane);
            this._GUI = tabbedPane;
        }
        return this._GUI;
    }

    private void whenContextSelectionChanges() {
        Pair selectedValue = (Pair)this._list.getSelectedValue();
        KeyStrokeContext keyStrokeContext = (KeyStrokeContext)selectedValue.first;
        boolean global = Boolean.TRUE.equals(selectedValue.second);
        StringBuffer buffer = new StringBuffer();
        Set allActions = keyStrokeContext.getAllActions(global);
        buffer.append("<context scope=\"" + (global ? "global" : "local") + "\">\n");
        List allPresets = keyStrokeContext.getAllPresets();
        if (allPresets != null && !allPresets.isEmpty()) {
            int i = 0;
            while (i < allPresets.size()) {
                Object preset = allPresets.get(i);
                StringBuffer presetBuffer = new StringBuffer();
                KeyStrokeMap presetKeyStrokeMap = keyStrokeContext.getPresetKeyStrokeMap(preset, global);
                Set keystrokes = presetKeyStrokeMap.keySet();
                for (KeyStrokes keyStrokes : keystrokes) {
                    Integer binding = presetKeyStrokeMap.getBindingFor(keyStrokes);
                    int cmdID = binding;
                    String cmdName = Ide.findCmdName(cmdID);
                    if (cmdName != null) {
                        presetBuffer.append("    <map action=\"" + cmdName + "\">\n");
                        int length = keyStrokes.getLength();
                        int j = 0;
                        while (j < length) {
                            KeyStroke keyStroke = keyStrokes.getKeyStroke(j);
                            presetBuffer.append("      <accel>" + KeyStroke2String.toString(keyStroke) + "</accel>\n");
                            ++j;
                        }
                        presetBuffer.append("    </map>\n");
                    }
                    IdeAction action = IdeAction.find(cmdID);
                    allActions.remove(action);
                }
                if (presetBuffer.length() > 0) {
                    buffer.append("  <preset name=\"" + preset + "\">\n");
                    buffer.append(presetBuffer);
                    buffer.append("  </preset>\n");
                }
                ++i;
            }
        }
        if (!allActions.isEmpty()) {
            buffer.append("  <allActions>\n");
            for (IdeAction action : allActions) {
                int commandId = action.getCommandId();
                String cmdName = Ide.findCmdName(commandId);
                if (cmdName == null) continue;
                buffer.append("    <map action=\"" + cmdName + "\"/>\n");
            }
            buffer.append("  </allActions>\n");
        }
        buffer.append("</context>\n");
        StringSelection ss = new StringSelection(buffer.toString());
        ClipboardStack.pushCurrentClipboard();
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
    }

    public Dockable getDockable(ViewId viewId) {
        return this;
    }

    public void install() {
        DockStation ds = DockStation.getDockStation();
        DockingParam dockingParam = new DockingParam();
        dockingParam.setPosition(0);
        ds.dock(this, dockingParam);
    }

    private boolean whenMouseEvent(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showCtxMenu(e);
            return true;
        }
        return false;
    }

    private void showCtxMenu(MouseEvent e) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem item = new JMenuItem("Dump");
        item.addActionListener(new 7());
        popup.add(item);
        item = new JMenuItem("Copy");
        item.addActionListener(new 8());
        popup.add(item);
        Point pt = GraphicsUtils.getPopupMenuShowPoint((JPopupMenu)popup, (MouseEvent)e);
        popup.show(this._GUI, pt.x, pt.y);
    }

    private ArrayList collect(KeyStrokeContextRegistry kscr, String sPreset) {
        ArrayList list = new ArrayList(200);
        Iterator iKsc = kscr.getAllContexts();
        while (iKsc.hasNext()) {
            KeyStrokeContext ksc = (KeyStrokeContext)iKsc.next();
            String sContext = ksc.getName();
            Object pc = KeyStrokeContextRegistry.searchPreset(ksc, sPreset);
            int i = 0;
            while (i < 2) {
                boolean bGlobal = i == 0;
                Set setActions = ksc.getAllActions(bGlobal);
                if (setActions != null) {
                    KeyStrokeMap ksm = ksc.getPresetKeyStrokeMap(pc, bGlobal);
                    KeyboardDockable.collect(list, sContext, ksm, setActions, bGlobal);
                }
                ++i;
            }
        }
        return list;
    }

    private ArrayList collectCurrent(KeyStrokeContextRegistry kscr, KeyStrokeOptions kso) {
        ArrayList list = new ArrayList(200);
        KeyStrokeMap ksmGlobal = kso.getGlobalKeyMap();
        Iterator iKsc = kscr.getAllContexts();
        while (iKsc.hasNext()) {
            KeyStrokeContext ksc = (KeyStrokeContext)iKsc.next();
            String sContext = ksc.getName();
            KeyStrokeMap ksmLocal = kso.getLocalKeyMap(ksc);
            int i = 0;
            while (i < 2) {
                boolean bGlobal = i == 0;
                Set setActions = ksc.getAllActions(bGlobal);
                if (setActions != null) {
                    KeyboardDockable.collect(list, sContext, bGlobal ? ksmGlobal : ksmLocal, setActions, bGlobal);
                }
                ++i;
            }
        }
        return list;
    }

    private static void collect(ArrayList list, String sContext, KeyStrokeMap ksm, Set setActions, boolean bGlobal) {
        for (Action a : setActions) {
            IdeAction ia;
            int nCmdID;
            if (!(a instanceof IdeAction) || (nCmdID = (ia = (IdeAction)a).getCommandId()) == -1) continue;
            IdeAction ideAction = IdeAction.find(nCmdID);
            if (ideAction != null) {
                List l;
                String sActionName = (String)ideAction.getValue("Name");
                if (ksm == null || (l = ksm.getKeyStrokesFor((Integer)nCmdID)).isEmpty()) continue;
                for (KeyStrokes kss : l) {
                    if (kss == null) continue;
                    Dumpable d = new Dumpable(sContext, sActionName, bGlobal, kss);
                    list.add(d);
                }
                continue;
            }
            System.out.println("Strange: " + a.getValue("Name") + (bGlobal ? "" : "(local)") + " is not found by IdeAction.find()");
        }
    }

    private String dump2(KeyStrokeContextRegistry kscr, String sPresetName) {
        ArrayList list = this.collect(kscr, sPresetName);
        Collections.sort(list);
        String sName = "_" + sPresetName + ".kdf";
        this.dump2(list, sName, "_" + sPresetName);
        return sName;
    }

    private void dumpCurrent(KeyStrokeContextRegistry kscr, KeyStrokeOptions kso) {
        ArrayList list = this.collectCurrent(kscr, kso);
        Collections.sort(list);
        this.dump2(list, "_noname.kdf", "New Preset");
    }

    private void dump2(List list, String sFileName, String sPresetName) {
        try {
            ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
            URL url = er.getSystemDirectory(Ide.getProductID());
            File fOut = new File(url.getPath(), sFileName);
            FileWriter fw = new FileWriter(fOut);
            BufferedWriter bw = new BufferedWriter(fw);
            PrintWriter out = new PrintWriter(bw);
            out.println("<document>");
            out.println("  <preset name=\"" + sPresetName + "\">");
            String sContext = "!@!@";
            boolean bFirstCtx = true;
            for (Dumpable d : list) {
                if (!sContext.equals(d._sContext)) {
                    if (bFirstCtx) {
                        bFirstCtx = false;
                    } else {
                        out.println("    </context>");
                    }
                    out.println("    <context name=\"" + d._sContext + "\">");
                    sContext = d._sContext;
                }
                KeyboardDockable.dump(out, d._kss, d._sActionName, d._bGlobal);
            }
            out.println("    </context>");
            out.println("  </preset>");
            out.println("</document>");
            out.close();
            bw.close();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void dump(PrintWriter out, KeyStrokes kss, String sActionName, boolean bGlobal) {
        out.println("      <map action=\"" + sActionName + "\" scope=\"" + (bGlobal ? "global" : "local") + "\">");
        if (kss != null) {
            int iKey = 0;
            while (iKey < kss.getLength()) {
                KeyStroke ks = kss.getKeyStroke(iKey);
                String sKey = KeyStroke2String.toString(ks);
                out.println("        <accel>" + sKey + "</accel>");
                ++iKey;
            }
        }
        out.println("      </map>");
    }

    private void whenDump() {
        StringBuffer msg = new StringBuffer();
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        Iterator iPC = kscr.getAllPresets().iterator();
        String sSep = " ";
        msg.append("Created ");
        while (iPC.hasNext()) {
            String sPresetName = (String)iPC.next();
            System.out.println("==================================================");
            System.out.println("Generating " + sPresetName);
            String s = this.dump2(kscr, sPresetName);
            msg.append(sSep + s);
            sSep = ", ";
        }
        KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
        this.dumpCurrent(kscr, kso);
        msg.append(" and _noname.kdf in the System directory");
        JOptionPane.showMessageDialog(this.getHostedComponent(), msg, "KeyboardDockable addin", 1);
    }

    private void whenCopy() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this._model.getRowCount()) {
            int j = 0;
            while (j < this._model.getColumnCount()) {
                if (j != 0) {
                    sb.append('\t');
                }
                Object cell = this._model.getValueAt(i, j);
                String s = "";
                if (cell != null) {
                    s = cell.toString();
                }
                sb.append(s);
                ++j;
            }
            sb.append('\n');
            ++i;
        }
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection contents = new StringSelection(sb.toString());
        ClipboardStack.pushCurrentClipboard();
        cb.setContents(contents, null);
    }

    static void mav$whenDump(KeyboardDockable keyboardDockable) {
        keyboardDockable.whenDump();
    }

    static void mav$whenCopy(KeyboardDockable keyboardDockable) {
        keyboardDockable.whenCopy();
    }

    static boolean mav$whenMouseEvent(KeyboardDockable keyboardDockable, MouseEvent mouseEvent) {
        return keyboardDockable.whenMouseEvent(mouseEvent);
    }

    static JTable ra$_table(KeyboardDockable keyboardDockable) {
        return keyboardDockable._table;
    }

    static MyModel ra$_model(KeyboardDockable keyboardDockable) {
        return keyboardDockable._model;
    }

    static JList ra$_list(KeyboardDockable keyboardDockable) {
        return keyboardDockable._list;
    }

    static void mav$whenContextSelectionChanges(KeyboardDockable keyboardDockable) {
        keyboardDockable.whenContextSelectionChanges();
    }

    final class 1
    implements ActionListener {
        private final /* synthetic */ JMenuItem v$item;
        private final /* synthetic */ DockStation v$ds;
        final /* synthetic */ KeyboardDockable this$0;

        public void actionPerformed(ActionEvent e) {
            boolean bSet = this.v$item.isSelected() ^ true;
            this.v$item.setSelected(bSet);
            this.v$ds.setDockableVisible(this.this$0, bSet);
        }

        public 1(KeyboardDockable keyboardDockable, JMenuItem jMenuItem, DockStation dockStation) {
            this.v$ds = dockStation;
            this.v$item = jMenuItem;
            this.this$0 = keyboardDockable;
        }
    }

    final class 2
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            KeyboardDockable.mav$whenMouseEvent(KeyboardDockable.this, e);
        }

        public void mouseReleased(MouseEvent e) {
            KeyboardDockable.mav$whenMouseEvent(KeyboardDockable.this, e);
        }

        public void mouseClicked(MouseEvent e) {
            if (!KeyboardDockable.mav$whenMouseEvent(KeyboardDockable.this, e)) {
                TableColumnModel columnModel = KeyboardDockable.ra$_table(KeyboardDockable.this).getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = KeyboardDockable.ra$_table(KeyboardDockable.this).convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    KeyboardDockable.ra$_model(KeyboardDockable.this).sort(column);
                }
            }
        }
    }

    final class 3
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            KeyboardDockable.mav$whenMouseEvent(KeyboardDockable.this, e);
        }

        public void mouseReleased(MouseEvent e) {
            KeyboardDockable.mav$whenMouseEvent(KeyboardDockable.this, e);
        }

        public void mouseClicked(MouseEvent e) {
            KeyboardDockable.mav$whenMouseEvent(KeyboardDockable.this, e);
        }
    }

    final class 4
    extends JList {
        private final /* synthetic */ DefaultListModel v$listModel;
        final /* synthetic */ KeyboardDockable this$0;

        public String getToolTipText(MouseEvent event) {
            String ret = null;
            int i = KeyboardDockable.ra$_list(this.this$0).locationToIndex(event.getPoint());
            Pair elementAt = (Pair)this.v$listModel.getElementAt(i);
            KeyStrokeContext contextAt = (KeyStrokeContext)elementAt.first;
            ret = contextAt.getClass().getName();
            return ret;
        }

        public 4(KeyboardDockable keyboardDockable, ListModel listModel, DefaultListModel defaultListModel) {
            this.v$listModel = defaultListModel;
            this.this$0 = keyboardDockable;
            super(listModel);
        }
    }

    final class 5
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Pair pair = (Pair)value;
            KeyStrokeContext keyStrokeContext = (KeyStrokeContext)pair.first;
            boolean global = Boolean.TRUE.equals(pair.second);
            boolean isResContext = keyStrokeContext instanceof ResKeystrokeContext;
            String label = keyStrokeContext.getName();
            if (!global) {
                label = label + "_local";
            }
            if (!isResContext) {
                label = label + " (" + keyStrokeContext.getClass().getName() + ")";
            }
            Component ret = super.getListCellRendererComponent((JList<?>)list, label, index, isSelected, cellHasFocus);
            if (!isSelected) {
                if (isResContext) {
                    this.setForeground(list.getForeground());
                } else {
                    this.setForeground(Color.RED);
                }
            }
            return ret;
        }
    }

    final class 6
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            KeyboardDockable.mav$whenContextSelectionChanges(KeyboardDockable.this);
        }
    }

    final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            KeyboardDockable.mav$whenDump(KeyboardDockable.this);
        }
    }

    final class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            KeyboardDockable.mav$whenCopy(KeyboardDockable.this);
        }
    }
}

