/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.MultiInputMap;

public final class MultiMapAdapter {
    private static void fillMap(MultiInputMap mm, KeyStrokeMap ksm) {
        mm.clear();
        for (KeyStrokes kss : ksm.keySet()) {
            Integer bind = ksm.getBindingFor(kss);
            mm.put(kss, (Object)bind);
        }
    }

    private static MultiInputMap getMap(KeyStrokeMap ksm) {
        MultiInputMap mm = new MultiInputMap();
        if (ksm != null) {
            MultiMapAdapter.fillMap(mm, ksm);
        }
        return mm;
    }

    public static MultiInputMap getGlobalMap(KeyStrokeOptions kso) {
        MultiInputMap mm = MultiMapAdapter.getMap(kso.getGlobalKeyMap());
        return mm;
    }

    public static void fillGlobalMap(MultiInputMap mim, KeyStrokeOptions kso) {
        MultiMapAdapter.fillMap(mim, kso.getGlobalKeyMap());
    }

    public static MultiInputMap getLocalMap(KeyStrokeOptions kso, KeyStrokeContext ksc) {
        KeyStrokeMap localKeyMap = kso.getLocalKeyMap(ksc);
        MultiInputMap mm = MultiMapAdapter.getMap(localKeyMap);
        return mm;
    }

    public static void fillLocalMap(MultiInputMap mim, KeyStrokeOptions kso, KeyStrokeContext ksc) {
        MultiMapAdapter.fillMap(mim, kso.getLocalKeyMap(ksc));
    }
}

