/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.ResKeystrokeReader;

class ResKeystrokeContext
implements KeyStrokeContext {
    private ClassLoader _classLoader;
    private String _fileName;
    private boolean _global;
    private HashSet _actionNames;
    private HashSet _knownPresets;
    private HashMap _presets;

    public ResKeystrokeContext(ClassLoader classLoader, String fileName) {
        this._classLoader = classLoader;
        this._fileName = fileName;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getName() + "]";
    }

    void load(ResKeystrokeReader reader) {
        this._actionNames = new HashSet();
        this._knownPresets = new HashSet(5);
        this._presets = new HashMap();
        try {
            reader.read(this);
        }
        catch (Exception e) {
            System.err.println("Failed to read " + this._fileName);
            e.printStackTrace();
        }
    }

    void unload() {
        this._global = true;
        this._actionNames = null;
        this._knownPresets = null;
        this._presets = null;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public String getAcceleratorFile() {
        return null;
    }

    public Set getAllActions(boolean bGlobal) {
        HashSet<IdeAction> ret = null;
        if (this.isInitialized() && bGlobal == this._global) {
            HashSet<IdeAction> allActions = new HashSet<IdeAction>();
            for (String actionName : this._actionNames) {
                IdeAction action;
                int commandID;
                Integer cmdID = Ide.findCmdID(actionName);
                if (cmdID == null || (commandID = cmdID.intValue()) == -1 || (action = IdeAction.find(commandID)) == null) continue;
                allActions.add(action);
            }
            ret = allActions;
        }
        return ret;
    }

    public List getAllPresets() {
        ArrayList ret = this.isInitialized() ? new ArrayList(this._knownPresets) : null;
        return ret;
    }

    public String getName() {
        return this._fileName;
    }

    public KeyStrokeMap getPresetKeyStrokeMap(Object preset, boolean bGlobal) {
        KeyStrokeMap ret = null;
        if (this.isInitialized() && bGlobal == this._global) {
            ret = new KeyStrokeMap();
            ArrayList mappings = (ArrayList)this._presets.get(preset);
            if (mappings != null) {
                int i = 0;
                while (i < mappings.size()) {
                    Mapping mapping = (Mapping)mappings.get(i);
                    String actionName = mapping._actionName;
                    KeyStrokes keyStrokes = mapping._keyStrokes;
                    ret.addMap(keyStrokes, actionName);
                    ++i;
                }
            }
        }
        return ret;
    }

    InputStream getInputStream() {
        ClassLoader classLoader = this._classLoader != null ? this._classLoader : this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(this._fileName);
        return inputStream;
    }

    void setGlobal(boolean global) {
        this._global = global;
    }

    void addActionName(String actionName) {
        this._actionNames.add(actionName);
    }

    void addPresetName(String presetName) {
        this._knownPresets.add(presetName);
    }

    void addMapping(String presetName, String actionName, KeyStrokes keyStrokes) {
        ArrayList<Mapping> mappings = (ArrayList<Mapping>)this._presets.get(presetName);
        if (mappings == null) {
            mappings = new ArrayList<Mapping>(5);
            this._presets.put(presetName, mappings);
        }
        Mapping mapping = new Mapping(actionName, keyStrokes);
        mappings.add(mapping);
    }

    private boolean isInitialized() {
        if (this._presets == null) {
            KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
            keyStrokeContextRegistry.loadAcceleratorDefinitionFiles();
        }
        return this._presets != null;
    }

    private static class Mapping {
        String _actionName;
        KeyStrokes _keyStrokes;

        public Mapping(String actionName, KeyStrokes keyStrokes) {
            this._actionName = actionName;
            this._keyStrokes = keyStrokes;
        }
    }
}

