/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.log;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogRecognizer;
import oracle.ide.resource.LogArb;

public abstract class AbstractLogManager
extends LogManager
implements Controller {
    public static final int CLOSE_LOG_CMD_ID = Ide.findOrCreateCmdID("CLOSE_LOG_CMD_ID");
    protected static final int CLEAR_LOG_CMD_ID = Ide.findOrCreateCmdID("CLEAR_LOG_CMD_ID");
    protected static final int CLOSE_OTHER_LOGS_CMD_ID = Ide.findOrCreateCmdID("CLOSE_OTHER_LOGS_CMD_ID");
    protected static final int CLOSE_ALL_LOGS_CMD_ID = Ide.findOrCreateCmdID("CLOSE_ALL_LOGS_CMD_ID");
    protected static final int OPEN_FILE_CMD_ID = Ide.findOrCreateCmdID("OPEN_FILE_CMD_ID");
    private ContextMenu _contextMenu;
    private MouseListener _mouseListener;
    private ContextMenuListener _contextMenuListener;
    private ArrayList _logRecognizers;

    private void $init$() {
        this._logRecognizers = new ArrayList();
    }

    public void addPage(LogPage page) {
        this.installMouseListener(page);
        Ide.getMainWindow().registerView(page.getLogPageView());
    }

    public void removePage(LogPage page) {
        page.removeMouseListener(this._mouseListener);
        Ide.getMainWindow().unregisterView(page.getLogPageView());
    }

    private JMenuItem clearMenu(MenuManager mgr) {
        return mgr.createMenuItem(IdeAction.find(CLEAR_LOG_CMD_ID), MenuConstants.WEIGHT_LOG_WINDOW_CLEAR);
    }

    private JMenuItem closeMenu(MenuManager mgr) {
        return mgr.createMenuItem(IdeAction.find(CLOSE_LOG_CMD_ID), MenuConstants.WEIGHT_FILE_CLOSE);
    }

    public ContextMenu getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu();
            IdeAction action = IdeAction.get(CLEAR_LOG_CMD_ID, null, LogArb.getString(21), null, LogArb.getInteger(18), null, null, true);
            action.addController(this);
            action = IdeAction.get(CLOSE_LOG_CMD_ID, null, LogArb.getString(28), null, LogArb.getInteger(22), null, null, true);
            action.addController(this);
            action = IdeAction.get(CLOSE_OTHER_LOGS_CMD_ID, null, LogArb.getString(23), null, LogArb.getInteger(9), null, null, true);
            action.addController(this);
            action = IdeAction.get(CLOSE_ALL_LOGS_CMD_ID, null, LogArb.getString(5), null, LogArb.getInteger(32), null, null, true);
            action.addController(this);
            this.installContextMenuListener();
        }
        return this._contextMenu;
    }

    public void registerLogRecognizer(LogRecognizer logRecognizer) {
        this._logRecognizers.add(logRecognizer);
    }

    public void unregisterLogRecognizer(LogRecognizer logRecognizer) {
        this._logRecognizers.remove(logRecognizer);
    }

    public int getPageCount() {
        return 0;
    }

    public LogPage[] getPages() {
        return new LogPage[0];
    }

    protected Context getContext(EventObject event) {
        return null;
    }

    protected void triggerPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            JTree tree;
            TreePath current;
            Component component = e.getComponent();
            component.requestFocus();
            ContextMenu menu = this.getContextMenu();
            if (menu == null) {
                return;
            }
            if (component instanceof JTree && (current = (tree = (JTree)component).getPathForLocation(e.getX(), e.getY())) != null) {
                TreePath[] paths = tree.getSelectionPaths();
                boolean isSelected = false;
                if (paths != null) {
                    int i = 0;
                    while (i < paths.length) {
                        if (paths[i].getLastPathComponent() == current.getLastPathComponent()) {
                            isSelected = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (!isSelected) {
                    tree.setSelectionPath(current);
                }
            }
            Context context = this.getContext(e);
            menu.show(context);
        }
    }

    protected void installContextMenuListener() {
        if (this._contextMenuListener == null) {
            this._contextMenuListener = new 1();
        }
        this._contextMenu.addContextMenuListener(this._contextMenuListener);
    }

    protected void installMouseListener(LogPage page) {
        if (this._mouseListener == null) {
            this._mouseListener = new 2();
        }
        page.addMouseListener(this._mouseListener);
    }

    protected List getLogRecognizers() {
        return this._logRecognizers;
    }

    public AbstractLogManager() {
        this.$init$();
    }

    static JMenuItem mav$clearMenu(AbstractLogManager abstractLogManager, MenuManager menuManager) {
        return abstractLogManager.clearMenu(menuManager);
    }

    static JMenuItem mav$closeMenu(AbstractLogManager abstractLogManager, MenuManager menuManager) {
        return abstractLogManager.closeMenu(menuManager);
    }

    final class 1
    implements ContextMenuListener {
        public void menuWillShow(ContextMenu popup) {
            popup.add((Component)AbstractLogManager.mav$clearMenu(AbstractLogManager.this, popup), MenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
            popup.add((Component)AbstractLogManager.mav$closeMenu(AbstractLogManager.this, popup), MenuConstants.SECTION_LOG_WINDOW_CLOSE_CTXT_MENU);
        }

        public void menuWillHide(ContextMenu popup) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }

    final class 2
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            AbstractLogManager.this.triggerPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            AbstractLogManager.this.triggerPopup(e);
        }
    }
}

