/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.log;

import java.awt.Component;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.controller.Controller;
import oracle.ide.docking.DockStation;
import oracle.ide.layout.ViewId;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogOwner;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogWindow;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.view.View;

public abstract class AbstractLogPage
extends View
implements LogPage {
    private Icon _icon;
    private String _name;

    protected AbstractLogPage(String viewId, String displayName, Icon icon, boolean addPage) {
        super(viewId);
        this._icon = icon;
        this._name = displayName;
        if (addPage) {
            AbstractLogPage._addPage(this);
        }
    }

    protected AbstractLogPage(ViewId viewId, Icon icon, boolean addPage) {
        this(viewId.getId(), viewId.getDisplayName(), icon, addPage);
    }

    protected AbstractLogPage(ViewId viewId, Icon icon) {
        this(viewId, icon, true);
    }

    protected AbstractLogPage(ViewId viewId) {
        this(viewId, null);
    }

    public void log(Object msg) {
        this.log(msg, false);
    }

    public void log(Object msg, boolean forceDisplay) {
        this.requestShow(forceDisplay);
        this.logMsg(msg);
    }

    public void logQuietly(Object msg) {
        this.logMsg(msg);
    }

    public void clearAll() {
    }

    public String getTitleName() {
        return this.getTabName();
    }

    public String getTabName() {
        return this._name;
    }

    public void tabNameUpdated() {
        LogWindow lw = LogManager.getIdeLogWindow();
        if (lw != null) {
            lw.updateTitle(null);
            lw.updateTabTitle(this, this.getTabName());
        }
    }

    public Icon getTabIcon() {
        return this._icon;
    }

    public String getToolTip() {
        return this.getTabName();
    }

    public void setOwner(LogOwner owner) {
        View logOwnerView = null;
        if (owner != null) {
            logOwnerView = owner.getLogOwnerView();
        }
        super.setOwner(logOwnerView);
    }

    public void addMouseListener(MouseListener listener) {
    }

    public void removeMouseListener(MouseListener listener) {
    }

    public View getLogPageView() {
        return this;
    }

    public boolean isDisplayComponentScrollable() {
        return false;
    }

    public Component getTopComponent() {
        return this.getLogPageView().getToolbar();
    }

    public Component getBottomComponent() {
        return null;
    }

    protected void logMsg(Object msg) {
    }

    protected void requestShow(boolean forceDisplay) {
        AbstractLogPage logPage = this;
        1 runner = new 1(this, forceDisplay, logPage);
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            SwingUtilities.invokeLater(runner);
        }
    }

    protected void requestShow() {
        this.requestShow(false);
    }

    private static void _addPage(AbstractLogPage page) {
        2 runner = new 2(page);
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            try {
                SwingUtilities.invokeLater(runner);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public Controller getController() {
        if (this.owner() != null) {
            return this.owner().getController();
        }
        return null;
    }

    public void show() {
        if (this.owner() == null) {
            LogManager.getLogManager().addPage(this);
        }
        ((LogOwner)((Object)this.owner())).selectPage(this);
        LogWindow logWindow = LogManager.getIdeLogWindow();
        DockStation.getDockStation().activateDockable(logWindow);
        GraphicsUtils.focusComponentOrChild((Component)this.getGUI(), (boolean)true);
    }

    public void close() {
        if (this.owner() != null) {
            this.owner().close();
        }
    }

    public boolean isVisible() {
        if (this.owner() == null) {
            return false;
        }
        return this.owner().isVisible();
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ boolean v$forceDisplay;
        private final /* synthetic */ LogPage v$logPage;
        final /* synthetic */ AbstractLogPage this$0;

        public void run() {
            LogOwner logOwner = (LogOwner)((Object)this.this$0.owner());
            LogWindow logWindow = LogManager.getIdeLogWindow();
            if (!this.v$forceDisplay && logOwner != null && DockStation.getDockStation().isDockableVisible(logWindow)) {
                logOwner.highlightPage(this.v$logPage);
            } else {
                this.this$0.show();
            }
        }

        public 1(AbstractLogPage abstractLogPage, boolean bl, LogPage logPage) {
            this.v$logPage = logPage;
            this.v$forceDisplay = bl;
            this.this$0 = abstractLogPage;
        }
    }

    static final class 2
    implements Runnable {
        private final /* synthetic */ AbstractLogPage v$page;

        public void run() {
            LogManager logManager = LogManager.getLogManager();
            if (logManager != null) {
                logManager.addPage(this.v$page);
            }
        }

        public 2(AbstractLogPage abstractLogPage) {
            this.v$page = abstractLogPage;
        }
    }
}

