/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.log;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogPageWrapper;
import oracle.ide.log.LogPipe;
import oracle.ide.nulls.DefaultPrintStream;

public class LogPrintStream
extends PrintStream {
    private final LogPage _logPage;

    public LogPrintStream(LogPage logPage) {
        super(LogPrintStream.getOutputStreamToWrap(logPage), true);
        this._logPage = logPage;
    }

    public LogPage getLogPage() {
        return this._logPage;
    }

    public LogPage getWrappedLogPage() {
        LogPage delegate = this.getLogPage();
        return new 1(delegate);
    }

    private static OutputStream getOutputStreamToWrap(LogPage logPage) {
        if (logPage != null) {
            try {
                PipedOutputStream pos = new PipedOutputStream();
                PipedInputStream pis = new PipedInputStream(pos);
                InputStreamReader isr = new InputStreamReader(pis);
                new LogPipe(logPage, new BufferedReader(isr));
                PipedOutputStream pipedOutputStream = pos;
                return pipedOutputStream;
            }
            catch (IOException e) {
                System.err.println("Unable to create PrintStream for log window -- wiring into System.out instead...");
                e.printStackTrace();
            }
        }
        return new DefaultPrintStream();
    }

    final class 1
    extends LogPageWrapper {
        public void log(Object msg) {
            if (msg != null) {
                LogPrintStream.this.print(msg.toString());
            }
        }

        public 1(LogPage logPage) {
            super(logPage);
        }
    }
}

