/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.migration;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.ide.config.ClientSetting;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.Object2DomLogger;
import oracle.ide.migration.Migrator;
import oracle.ide.net.URLFactory;
import oracle.ide.util.Assert;
import oracle.javatools.util.Copyable;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.xml.sax.SAXParseException;

public abstract class ExtensionMigrator
implements Migrator {
    protected static final int SETTINGS = 0;
    protected boolean isSelected;

    private void $init$() {
        this.isSelected = true;
    }

    public int[] getMigrationCategories() {
        return new int[]{0};
    }

    public String getDescription(int category) {
        return null;
    }

    public boolean canMigrate(int category, File sourceDir) {
        File file;
        return category == 0 && sourceDir != null && sourceDir.exists() && (file = this.getSourceFile(sourceDir)) != null && file.exists() && file.canRead();
    }

    public void setSelected(int category, boolean selected) {
        if (category == 0) {
            this.isSelected = selected;
        }
    }

    public boolean isSelected(int category) {
        return category == 0 ? this.isSelected : false;
    }

    public String[] migrate(File sourceDir, File destDir) {
        if (this.isSelected(0) && sourceDir != null && sourceDir.exists()) {
            File srcFile = this.getSourceFile(sourceDir);
            File destFile = this.getDestFile(destDir);
            String extensionId = this.getExtensionID();
            if (extensionId == null) {
                new NullPointerException(this.getClass() + " returned null from getExtensionID()").printStackTrace();
                return null;
            }
            return ExtensionMigrator.copyPreferenceObjectsAsIs(srcFile, destFile, this.getSettingKeys(), this.getExtensionID());
        }
        return null;
    }

    public static String[] copyPreferenceObjectsAsIs(File srcFile, File destFile, List settingKeys, String extensionID) {
        ArrayList<String> errors = new ArrayList<String>();
        URL url = URLFactory.newFileURL((File)srcFile);
        Object2Dom o2d = Object2Dom.newInstance();
        Map map = null;
        try {
            NullLogger logger = new NullLogger(null);
            o2d.setLogger(2, (Object2DomLogger)logger);
            map = (Map)o2d.toObject(url);
        }
        catch (Exception e) {
            String[] stringArray = new String[]{e.getLocalizedMessage()};
            return stringArray;
        }
        if (destFile != null && destFile.exists()) {
            try {
                destFile.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ClientSetting setting = ClientSetting.findOrCreate(extensionID);
        for (Object key : settingKeys) {
            try {
                if (!map.containsKey(key)) continue;
                setting.putData((String)key, (Copyable)map.get(key));
            }
            catch (Exception e) {
                errors.add(e.getLocalizedMessage());
            }
        }
        return errors.toArray(new String[errors.size()]);
    }

    protected File getSourceFile(File sourceDir) {
        File file = new File(sourceDir, "preferences.xml");
        if (!file.exists()) {
            file = new File(sourceDir, "settings.xml");
        }
        return file;
    }

    protected File getDestFile(File destDir) {
        return new File(destDir, "preferences.xml");
    }

    protected abstract List getSettingKeys();

    protected abstract String getExtensionID();

    public ExtensionMigrator() {
        this.$init$();
    }

    private static final class NullLogger
    implements Object2DomLogger {
        public void logXMLParseException(XMLParseException e) {
            Assert.println((String)e.getLocalizedMessage());
        }

        public void logSAXParseException(SAXParseException e) {
            Assert.println((String)e.getLocalizedMessage());
        }

        public void logUnmarshalException(int line, int col, Throwable t) {
            Assert.println((String)t.getLocalizedMessage());
        }

        public void logOtherException(Throwable t) {
            Assert.println((String)t.getLocalizedMessage());
        }

        public void logMessage(String mesg) {
            Assert.println((String)mesg);
        }

        public void logXMLDocument(XMLDocument document) {
        }

        private NullLogger() {
        }

        NullLogger(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

