/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.migration;

import java.net.URL;
import java.util.StringTokenizer;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.model.Node;

public abstract class MigrationInfo {
    public static final String EARLIEST_VERSION = "900";
    public static final String POST_1013 = "1013";
    public static final MigrationStatus MIGRATION_IO_ERROR = new MigrationStatus("migration backup error", null);
    public static final MigrationStatus MIGRATION_DONE = new MigrationStatus("migration done", null);
    public static final MigrationStatus MIGRATION_DONE_BUT_NOT_SAVED = new MigrationStatus("migration done but not saved", null);
    public static final MigrationStatus MIGRATION_ERROR = new MigrationStatus("migration error", null);
    public static final MigrationStatus MIGRATION_PENDING = new MigrationStatus("migration pending", null);
    public static final MigrationStatus MIGRATION_CANCELED = new MigrationStatus("migration canceled", null);
    public static final MigrationStatus MIGRATION_NOT_NEEDED = new MigrationStatus("migration not needed", null);
    public static final MigrationStatus MIGRATION_NOT_POSSIBLE = new MigrationStatus("migration not possible", null);
    public static final VersionStatus VERSION_UNKNOWN = new VersionStatus("version unknown", null);
    public static final VersionStatus VERSION_OLDER = new VersionStatus("version older", null);
    public static final VersionStatus VERSION_NEWER = new VersionStatus("version newer", null);
    public static final VersionStatus VERSION_CURRENT = new VersionStatus("version current", null);
    private final Node _node;
    private VersionStatus _versionStatus;
    private String _version;
    private MigrationStatus _migrationStatus;
    private URL _backupURL;

    protected MigrationInfo(Node node) {
        this._node = node;
        this._migrationStatus = MIGRATION_PENDING;
    }

    public final Node getNode() {
        return this._node;
    }

    public Status getVersionStatus() {
        this.ensureVersionInfo();
        return this._versionStatus;
    }

    protected final void setVersionStatusDirectly(VersionStatus versionStatus) {
        this._versionStatus = versionStatus;
    }

    public MigrationStatus getMigrationStatus() {
        this.ensureVersionInfo();
        return this._migrationStatus;
    }

    public void setMigrationStatus(MigrationStatus status) {
        this._migrationStatus = status;
    }

    public String getVersion() {
        this.ensureVersionInfo();
        return this._version;
    }

    protected final String getVersionDirectly() {
        return this._version;
    }

    protected final void setVersionDirectly(String version) {
        this._version = version;
    }

    final URL getBackupURL() {
        return this._backupURL;
    }

    final void setBackupURL(URL backupURL) {
        this._backupURL = backupURL;
    }

    protected abstract void ensureVersionInfo();

    public NodeMigratorHelper[] getHelpers() {
        return new NodeMigratorHelper[0];
    }

    protected static String getVersionFromNamespaceURI(String namespaceURI) {
        int count = 0;
        StringTokenizer st = new StringTokenizer(namespaceURI, "/");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (++count != 4) continue;
            return token;
        }
        return null;
    }

    public static class Status {
        private final String _status;

        public String toString() {
            return this._status;
        }

        private Status(String status) {
            this._status = status;
        }

        Status(String string, 1 var2_2) {
            this(string);
        }

        public final class 1 {
        }
    }

    public static final class VersionStatus
    extends Status {
        private VersionStatus(String status) {
            super(status, null);
        }

        VersionStatus(String string, 1 var2_2) {
            this(string);
        }

        public final class 1 {
        }
    }

    public static final class MigrationStatus
    extends Status {
        private MigrationStatus(String status) {
            super(status, null);
        }

        MigrationStatus(String string, 1 var2_2) {
            this(string);
        }

        public final class 1 {
        }
    }
}

