/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.model.DataList;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.Reference;
import oracle.ide.model.SubDirtyable;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.FilePath;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.marshal.ObjectStore;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataContainer
extends Node
implements PropertyStorage,
Folder,
Observer {
    final HashStructure _hash;
    final DirtyTracker _hashDirtyTracker;
    private final List<Element> _children;
    private static final String URL = "URL";
    private static final String NODE_CLASS = "nodeClass";
    private transient ObjectStore _objectStore;
    private static final String LIST_OF_CHILDREN = "listOfChildren";

    private void $init$() {
        this._hash = HashStructure.newInstance();
        this._hashDirtyTracker = new HashDirtyTracker();
        this._children = new ArrayList<Element>();
    }

    public DataContainer() {
        this.$init$();
        this.init();
    }

    public DataContainer(URL url) {
        super(url);
        this.$init$();
        this.init();
    }

    private void init() {
        this.getAttributes().set(ElementAttributes.HIDE_FILE_EXTENSION);
    }

    @Override
    public URL getURL() throws TransientMarker {
        return super.getURL();
    }

    public HashStructure getProperties() {
        return this.getSharedPropertiesOnly();
    }

    public HashStructure getUserPropertiesOnly() {
        return this.getSharedPropertiesOnly();
    }

    public final HashStructure getSharedPropertiesOnly() {
        this.readLock();
        try {
            this.ensureLoad();
            HashStructure hashStructure = this._hash;
            return hashStructure;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.readUnlock();
        }
    }

    public final String getProperty(String name) {
        return this.getProperties().getString(name);
    }

    public final String getProperty(String name, String defaultValue) {
        return this.getProperties().getString(name, defaultValue);
    }

    public final void setProperty(String name, String value) {
        this.getProperties().putString(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getListOfChildren() throws TransientMarker {
        List<Element> list = this._children;
        synchronized (list) {
            DataList dataList = new DataList(this._children);
            return dataList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListOfChildren(List<?> list) {
        List<Element> list2 = this._children;
        synchronized (list2) {
            this.detachFromAll(this._children);
            this._children.clear();
            this.getListOfChildrenListStructure().clear();
        }
        if (list != null) {
            for (Object next : list) {
                if (next instanceof Reference) {
                    Reference ref = (Reference)next;
                    this.add(ref.getData());
                    continue;
                }
                if (!(next instanceof Element)) continue;
                this.add((Element)next);
            }
        }
    }

    @Override
    public boolean mayHaveChildren() {
        return true;
    }

    @Override
    public Iterator<Element> getChildren() {
        return this.getChildrenImpl(true);
    }

    final Iterator<Element> getChildrenImpl(boolean includeOwnedChildren) {
        try {
            if (this.ensureLoad()) {
                ArrayList children = new ArrayList();
                this.copyChildrenTo(children, includeOwnedChildren);
                Iterator<Element> iterator = children.iterator();
                return iterator;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Collections.emptyList().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyChildrenTo(List list, boolean includeOwnedChildren) {
        if (this._children.size() > 0) {
            List<Element> list2 = this._children;
            synchronized (list2) {
                list.addAll(this._children);
            }
        }
    }

    @Override
    public boolean canAdd(Element element) {
        return element != null;
    }

    @Override
    public boolean add(Element element) {
        return this.add(element, false);
    }

    @Override
    public boolean canRemove(Element element) {
        return element != null;
    }

    @Override
    public boolean remove(Element element) {
        return this.remove(element, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsChild(Element child) {
        try {
            this.load();
            List<Element> list = this._children;
            synchronized (list) {
                boolean bl = this._children.contains(child);
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        try {
            this.load();
            List<Element> list = this._children;
            synchronized (list) {
                int n = this._children.size();
                return n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public void removeAll() {
        this.removeAll(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Element element, boolean notify) {
        boolean addOk = false;
        try {
            this.open();
            List<Element> list = this._children;
            synchronized (list) {
                if (element != null && !this._children.contains(element)) {
                    addOk = this._children.add(element);
                    if (element instanceof Locatable) {
                        Locatable locatable = (Locatable)((Object)element);
                        HashStructure hash = HashStructure.newInstance();
                        hash.putURL(URL, locatable.getURL());
                        if (!(element instanceof Project)) {
                            hash.putString(NODE_CLASS, element.getClass().getName());
                        }
                        this.getListOfChildrenListStructure().add((Object)hash);
                        this.attachTo(element);
                    }
                    if (addOk) {
                        this.setSubDirtyableOwner(element, this);
                        this.markDirty(true);
                    }
                }
            }
            if (notify && addOk) {
                UpdateMessage.fireChildAdded(this, element);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return addOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Element element, boolean notify) {
        boolean removeOk = false;
        try {
            this.open();
            List<Element> list = this._children;
            synchronized (list) {
                if (element != null && this._children.contains(element)) {
                    removeOk = this._children.remove(element);
                    if (element instanceof Locatable) {
                        Locatable locatable = (Locatable)((Object)element);
                        URL url = locatable.getURL();
                        ListStructure list2 = this.getListOfChildrenListStructure();
                        Iterator iter = list2.iterator();
                        while (iter.hasNext()) {
                            HashStructure hash = (HashStructure)iter.next();
                            if (!ModelUtil.areEqual((Object)url, (Object)hash.getURL(URL))) continue;
                            iter.remove();
                            this.detachFrom(element);
                            break;
                        }
                    }
                    this.setSubDirtyableOwner(element, null);
                    this.markDirty(true);
                }
            }
            if (notify && removeOk) {
                UpdateMessage.fireChildRemoved(this, element);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return removeOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(boolean notify) {
        try {
            this.open();
            ArrayList<Element> children = null;
            List<Element> list = this._children;
            synchronized (list) {
                this.resetSubDirtyableOwners(this._children);
                if (notify && !this._children.isEmpty()) {
                    children = new ArrayList<Element>(this._children);
                    this.detachFromAll(children);
                }
                this._children.clear();
                this.getListOfChildrenListStructure().clear();
            }
            if (children != null) {
                UpdateMessage.fireChildrenRemoved(this, children);
            }
            this.markDirty(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final String getBaseDirectory() {
        URL url = this.getURL();
        String path = url.getPath();
        String baseDir = FilePath.getParent(path);
        return baseDir;
    }

    @Override
    void loadImpl() throws IOException {
        URL url = this.getURL();
        if (URLFileSystem.exists((URL)url) && this.getObjectStore().open(url, this.getObjectStoreTarget())) {
            this.markDirty(false);
        }
        this._hash.setParentDirtyable((oracle.javatools.data.Dirtyable)this._hashDirtyTracker);
        this.initListOfChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeImpl() throws IOException {
        List<Element> list = this._children;
        synchronized (list) {
            this._children.clear();
        }
    }

    @Override
    void unloadImpl() {
        this._hash.setParentDirtyable(null);
        this._hash.clear();
        this._children.clear();
    }

    @Override
    protected void saveImpl() throws IOException {
        this.getObjectStore().save(this.getURL(), this.getObjectStoreTarget());
    }

    protected ObjectStore newObjectStore() {
        return Object2Dom.newInstance();
    }

    protected Object getObjectStoreTarget() {
        return this;
    }

    void initListOfChildren() {
        ListStructure list = this.getListOfChildrenListStructure();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            try {
                Node node;
                HashStructure hash = (HashStructure)iter.next();
                URL url = hash.getURL(URL);
                String typeStr = hash.getString(NODE_CLASS);
                Class<?> type = null;
                if (typeStr != null) {
                    try {
                        type = Class.forName(typeStr);
                    }
                    catch (ClassNotFoundException e) {
                        type = null;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                Node node2 = node = type != null ? NodeFactory.findOrCreate(type, url) : NodeFactory.findOrCreate(url);
                if (node instanceof Project) {
                    hash.remove(NODE_CLASS);
                }
                this._children.add(node);
                this.attachTo(node);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void update(Object observed, UpdateMessage change) {
        if (change.getMessageID() == UpdateMessage.OBJECT_RENAMED && observed instanceof Locatable) {
            Locatable loc = (Locatable)observed;
            ListStructure children = this.getListOfChildrenListStructure();
            block0: for (URL oldURL : change.getModifyObjects()) {
                for (HashStructure hash : children) {
                    if (!hash.getURL(URL).equals(oldURL)) continue;
                    hash.putURL(URL, loc.getURL());
                    continue block0;
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((DataContainer)obj);
    }

    protected final boolean equalsImpl(DataContainer other) {
        boolean equal = super.equalsImpl(other);
        if (this.isLoadedUnsafe() && other.isLoadedUnsafe()) {
            return equal && ModelUtil.areEqual((Object)this._hash, (Object)other._hash);
        }
        return equal && other == this;
    }

    public boolean add(Collection childElements, boolean notify) {
        Iterator iterator = childElements.iterator();
        boolean addOk = true;
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (next instanceof Element && this.add((Element)next, false)) continue;
            addOk = false;
        }
        if (notify && addOk) {
            UpdateMessage.fireChildrenAdded(this, childElements);
        }
        return addOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetSubDirtyableOwners(List children) {
        List list = children;
        synchronized (list) {
            for (Element element : children) {
                this.setSubDirtyableOwner(element, null);
            }
        }
    }

    protected void setSubDirtyableOwner(Element element, Dirtyable owner) {
        if (element instanceof SubDirtyable) {
            ((SubDirtyable)element).setOwner(owner);
        }
    }

    ObjectStore getObjectStore() {
        if (this._objectStore == null) {
            this._objectStore = this.newObjectStore();
        }
        return this._objectStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void copyToImpl(DataContainer copy) {
        ArrayList<Element> childrenCopy;
        super.copyToImpl(copy);
        this.ensureLoad();
        copy.ensureLoad();
        this._hash.copyTo(copy._hash);
        List<Element> list = this._children;
        synchronized (list) {
            childrenCopy = new ArrayList<Element>(this._children);
        }
        List<Element> list2 = copy._children;
        synchronized (list2) {
            copy._children.clear();
            copy._children.addAll(childrenCopy);
        }
    }

    ListStructure getListOfChildrenListStructure() {
        return this.getSharedPropertiesOnly().getOrCreateListStructure(LIST_OF_CHILDREN);
    }

    private void attachTo(Element element) {
        if (element instanceof Subject && element instanceof Locatable) {
            ((Subject)((Object)element)).attach(this);
        }
    }

    private void detachFrom(Element element) {
        if (element instanceof Subject && element instanceof Locatable) {
            ((Subject)((Object)element)).detach(this);
        }
    }

    private void detachFromAll(List children) {
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            this.detachFrom((Element)iter.next());
        }
    }

    final class HashDirtyTracker
    extends DirtyTracker {
        HashDirtyTracker() {
        }
    }

    class DirtyTracker
    implements Dirtyable {
        private boolean _dirty;

        public boolean isDirty() {
            return this._dirty;
        }

        public void markDirty(boolean dirty) {
            this._dirty = dirty;
            this.propagate(dirty);
        }

        void propagate(boolean dirty) {
            DataContainer.this.markDirty(dirty);
        }

        void clearDirty() {
            this._dirty = false;
        }

        DirtyTracker() {
        }
    }
}

