/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.jcip.annotations.GuardedBy;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependableRecognizer;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependableFactory {
    private final List<DependableRecognizer> _factories;
    @GuardedBy(value="this")
    private final WeakHashMap<Element, List<DependableEntry>> _cache;

    private void $init$() {
        this._factories = new CopyOnWriteArrayList<DependableRecognizer>();
        this._cache = new WeakHashMap();
    }

    public void registerFactory(DependableRecognizer factory) {
        this._factories.add(factory);
    }

    public void removeFactory(DependableRecognizer factory) {
        this._factories.remove(factory);
    }

    public boolean hasFactory(Element source) {
        for (DependableRecognizer factory : this._factories) {
            if (!factory.recognize(source)) continue;
            return true;
        }
        return false;
    }

    public synchronized Dependable findOrCreate(Element source, Folder owner) throws IllegalAccessException, InstantiationException {
        if (source == null) {
            return null;
        }
        List<DependableEntry> dependables = this.findList(source);
        Dependable dependable = this.findOwnedBy(owner, dependables);
        if (dependable == null) {
            for (DependableRecognizer factory : this._factories) {
                if (!factory.recognize(source)) continue;
                dependable = factory.create(source, owner);
                if (dependable == null) break;
                this.cache(dependable, source, owner, dependables);
                break;
            }
        }
        return dependable;
    }

    public synchronized Dependable find(Element source) {
        if (source != null) {
            return this.find(source, null);
        }
        return null;
    }

    public synchronized Dependable find(Element source, Folder owner) {
        return this.findOwnedBy(owner, this.findList(source));
    }

    public synchronized Dependable[] findAll(Element source) {
        List<DependableEntry> list = this.findList(source);
        if (list == null || list.isEmpty()) {
            return null;
        }
        int size = list.size();
        Dependable[] dependables = new Dependable[size];
        int i = 0;
        while (i < size) {
            dependables[i] = DependableEntry.ra$dependable(list.get(i));
            ++i;
        }
        return dependables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cache(Dependable dependable) {
        Element source = dependable.getSource();
        Folder owner = dependable.getSourceOwner();
        DependableFactory dependableFactory = this;
        synchronized (dependableFactory) {
            List<DependableEntry> dependables = this.findList(source);
            if (this.findOwnedBy(owner, dependables) == null) {
                this.cache(dependable, source, owner, dependables);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uncache(Dependable dependable) {
        Element source = dependable.getSource();
        Folder owner = dependable.getSourceOwner();
        DependableFactory dependableFactory = this;
        synchronized (dependableFactory) {
            int index;
            List<DependableEntry> dependables = this.findList(source);
            if (dependables != null && (index = this.findOwnedByIndex(owner, dependables)) >= 0) {
                dependables.remove(index);
            }
        }
    }

    static HashStructure toHashStructure(Dependable dep) throws Exception {
        Class<?> type = dep.getClass();
        try {
            Method getHashStructure = type.getMethod("getHashStructure", new Class[0]);
            HashStructure hash = (HashStructure)getHashStructure.invoke((Object)dep, new Object[0]);
            Assert.precondition((hash != null ? 1 : 0) != 0, (String)(type.getName() + ".getHashStructure() returned null"));
            HashStructure hashStructure = hash;
            return hashStructure;
        }
        catch (NoSuchMethodException e) {
            Method getSourceOwnerURL = type.getMethod("getSourceOwnerURL", null);
            URL sourceOwnerURL = (URL)getSourceOwnerURL.invoke((Object)dep, null);
            Method getSourceURL = type.getMethod("getSourceURL", null);
            URL sourceURL = (URL)getSourceURL.invoke((Object)dep, null);
            HashStructure depHash = HashStructure.newInstance();
            depHash.putString("class", type.getName());
            depHash.putURL("sourceOwnerURL", sourceOwnerURL);
            depHash.putURL("sourceURL", sourceURL);
            return depHash;
        }
    }

    static Dependable toDependable(HashStructure hash) throws Exception {
        try {
            Dependable dep;
            String className = hash.getString("class");
            if (className == null) {
                throw new ClassNotFoundException();
            }
            Object depObj = Class.forName(className).newInstance();
            Class<?> type = depObj.getClass();
            Method setSourceOwnerURL = type.getMethod("setSourceOwnerURL", URL.class);
            URL sourceOwnerURL = hash.getURL("sourceOwnerURL");
            setSourceOwnerURL.invoke(depObj, sourceOwnerURL);
            Method setSourceURL = type.getMethod("setSourceURL", URL.class);
            URL sourceURL = hash.getURL("sourceURL");
            setSourceURL.invoke(depObj, sourceURL);
            Dependable dependable = dep = (Dependable)depObj;
            return dependable;
        }
        catch (ClassNotFoundException e) {
            try {
                Dependable dep;
                Class<?> type = Class.forName("oracle.jdeveloper.deploy.dt.AbstractHashDependable");
                Method createDependable = type.getMethod("createDependable", HashStructure.class);
                Dependable dependable = dep = (Dependable)createDependable.invoke(null, hash);
                return dependable;
            }
            catch (Exception f) {
                throw e;
            }
        }
    }

    private List<DependableEntry> findList(Element source) {
        return this._cache.get(source);
    }

    private Dependable findOwnedBy(Folder owner, List<DependableEntry> dependables) {
        int index = this.findOwnedByIndex(owner, dependables);
        if (index >= 0) {
            return DependableEntry.ra$dependable(dependables.get(index));
        }
        return null;
    }

    private int findOwnedByIndex(Folder owner, List<DependableEntry> dependables) {
        if (dependables != null && !dependables.isEmpty()) {
            if (owner == null) {
                return 0;
            }
            int i = 0;
            while (i < dependables.size()) {
                DependableEntry dependable = dependables.get(i);
                if (DependableEntry.ra$owner(dependable) == owner) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private void cache(Dependable dependable, Element source, Folder owner, List<DependableEntry> dependables) {
        if (dependables == null) {
            dependables = new ArrayList<DependableEntry>(3);
            this._cache.put(source, dependables);
        }
        dependables.add(new DependableEntry(dependable, owner));
    }

    public DependableFactory() {
        this.$init$();
    }

    private static final class DependableEntry {
        private Dependable dependable;
        private Folder owner;

        public DependableEntry(Dependable dependable, Folder owner) {
            this.dependable = dependable;
            this.owner = owner;
        }

        static Folder ra$owner(DependableEntry dependableEntry) {
            return dependableEntry.owner;
        }

        static Dependable ra$dependable(DependableEntry dependableEntry) {
            return dependableEntry.dependable;
        }
    }
}

