/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.performance.PerformanceLogger;
import oracle.javatools.util.CopyOnWriteList;

public class IdeSubject
implements Subject {
    final CopyOnWriteList _observers;

    private void $init$() {
        this._observers = new CopyOnWriteList(Observer.class);
    }

    public final void attach(Observer observer) {
        if (observer != null) {
            this._observers.addIfAbsent((Object)observer);
        }
    }

    public final void detach(Observer observer) {
        if (observer != null) {
            this._observers.remove((Object)observer);
        }
    }

    public final void notifyObservers(Object observed, UpdateMessage change) {
        Object origin = change != null ? change.getOrigin() : null;
        Object[] observers = this._observers.getItems();
        int n = observers.length;
        int i = 0;
        while (i < n) {
            Observer observer = (Observer)observers[i];
            try {
                if (observer != origin) {
                    long startTime = System.nanoTime();
                    observer.update(observed, change);
                    long endTime = System.nanoTime();
                    PerformanceLogger.get().log("Observer.update", observer.getClass().getName(), endTime - startTime);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            ++i;
        }
    }

    public IdeSubject() {
        this.$init$();
    }
}

